
<style>
    .single-line-table {
  border-collapse: collapse;
}

.single-line-table th,
.single-line-table td {
  border: 1px solid black;
  padding: 8px;
  white-space: nowrap; /* Prevent line breaks */
}

</style>

<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Stock Movement Report
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($from_date != '') {
                ?>
                    <div class="filter-item">
                        <label>Transaction From :</label>
                        <?php echo $from_date; ?>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($to_date != '') {
                ?>
                    <div class="filter-item">
                        <label>Transaction To :</label>
                        <?php echo $to_date; ?>
                    </div>
                <?php
                }
                ?>


                <?php
                if ($product_id != '') {
                ?>
                    <div class="filter-item ">
                        <label>Product :</label>
                        <?php
                        $c = Store::model()->findByPK($product_id);
                        echo $c->part_number;
                        ?>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($warehouse_id != '') {
                ?>
                    <div class="filter-item ">
                        <label>Warehouse :</label>
                        <?php
                        $warehse = MasInventoryWarehouse::model()->findByPK($warehouse_id);
                        echo $warehse->warehouse_name;
                        ?>
                    </div>
                <?php
                }
                ?>


            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">

            <table id="tbl_goodissue_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr class="single-line-table">
                        <th>No</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Brand</th>
                        <th>Opening Qty</th>
                        <th>Opening Value</th>
                        <th>Purchase</th>
                        <th>Purchase Value</th>
                        <th>Purchase Return</th>
                        <th>PR Value</th>
                        <th>Sales</th>
                        <th>Sales Value</th>
                        <th>Sales Return </th>
                        <th>SR Value</th>
                        <th>Goods Receipt</th>
                        <th>GR Value</th>
                        <th>Goods Issue</th>
                        <th>G Value</th>
                        <th>Transfer In</th>
                        <th>Transfer In Value</th>
                        <th>Transfer Out</th>
                        <th>Transfer Out Value</th>
                        <th>Closing Qty</th>
                         <th>Closing Value</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    $condition = '1=1';
                    $opencondition = '1=1';
                    $closecondition = '1=1';
                    $storecondition = '1=1';

                    if ($from_date != '') {
                        $from_date = str_replace('/', '-', $from_date);
                        $from_date = date('Y-m-d', strtotime($from_date));

                        $condition .= ' AND transaction_date >="' . $from_date . '"';
                        $opencondition .= ' AND transaction_date <"' . $from_date . '"';
                    }

                    if ($to_date != '') {
                        $to_date = str_replace('/', '-', $to_date);
                        $to_date = date('Y-m-d', strtotime($to_date));
                        $condition .= ' AND transaction_date <="' . $to_date . '"';
                    }

                    if ($brand_id > 0) {
                        $storecondition .= ' AND S.brand_class_id ="' . $brand_id . '"';
                        // $opencondition  .= ' AND  brand_id ="' . $brand_id . '"';

                    }
                    if ($product_id > 0) {
                        $storecondition .= ' AND S.id ="' . $product_id . '"';

                        $condition .= ' AND product_id ="' . $product_id . '"';
                    }
                    if ((int)$warehouse_id > 0) {
                        $condition .= " AND warehouse_id = " . $warehouse_id;
                        $storecondition .= ' AND S.warehouse_id ="' . $warehouse_id . '"';

                        $opencondition .= " AND warehouse_id = " . $warehouse_id;
                    }



                    $sql = '
                        SELECT
                                    S.id AS product_id,part_number,S.description,S.brand_class_id AS brand_id,B.product_class AS brand_name,S.warehouse_id as warehouse_id,
                                    IFNULL(openingqty,0) AS openingqty,
                                    IFNULL(receiptqty,0) AS receiptqty,
                                    IFNULL(issueqty,0) AS issueqty,
                                    IFNULL(salesqty,0) AS salesqty,
                                    IFNULL(salesreturnqty,0) AS salesreturnqty,
                                    IFNULL(purchaseqty,0) AS purchaseqty,
                                    IFNULL(purchasereturnqty,0) AS purchasereturnqty,
                                    IFNULL(tinqty,0) AS tinqty,
                                    IFNULL(toutqty,0) AS toutqty,
                                    IFNULL(openingsum,0) AS openingsum,
                                    IFNULL(purchasesum,0) AS purchasesum,
                                    IFNULL(purchasereturnsum,0) AS purchasereturnsum,
                                    IFNULL(receiptsum,0) AS receiptsum,
                                    IFNULL(toutsum,0) AS toutsum,
                                    IFNULL(tinsum,0) AS tinsum, 
                                    IFNULL(salesreturnsum,0) AS salesreturnsum,
                                    IFNULL(salessum,0) AS salessum,
                                     IFNULL(issuesum,0) AS issuesum
                                    
       
                            FROM
                                erp_store S
                            LEFT JOIN  erp_product_class AS B
                                ON
                                    B.id = S.brand_class_id
                            LEFT JOIN(
                                    SELECT
                                        product_id,
                                       SUM(quantity) AS receiptqty,
                                        sum(cost_price * quantity) as  receiptsum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from = "INVENTORY_GOODS_RECEIPT" 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS R
                                ON
                                    R.product_id = S.id
                            LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS issueqty,
                                         sum(cost_price * quantity) as  issuesum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from = "GOODS_ISSUE" 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS GI
                                ON
                                    GI.product_id = S.id
                            LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS salesqty,
                                         sum(cost_price * quantity) as  salessum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from IN("DIRECT_INVOICE", "CANCEL_INVOICE") 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS I
                                ON
                                    I.product_id = S.id
                            LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS salesreturnqty,
                                         sum(cost_price * quantity) as  salesreturnsum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from = "CREDIT_NOTE" 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS SR
                                ON
                                    SR.product_id = S.id
                            LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS purchaseqty,
                                        sum(cost_price * quantity) as  purchasesum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from = "PURCHASE_QUALITY_CHECK" 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS P
                                ON P.product_id = S.id
                            LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS purchasereturnqty,
                                        sum(cost_price * quantity) as  purchasereturnsum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from = "DEBIT_NOTE" 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS PR
                                ON
                                    PR.product_id = S.id
                                LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS tinqty,
                                         sum(cost_price * quantity) as  tinsum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from = "DIRECT_TRANSFER_IN" 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS TRI
                                ON
                                    TRI.product_id = S.id
                                LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS toutqty,
                                         sum(cost_price * quantity) as  toutsum
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        transaction_from = "DIRECT_TRANSFER_OUT" 
                                        AND ' . $condition . '
                                    GROUP BY product_id
                                ) AS TRO
                                ON
                                    TRO.product_id = S.id
                                LEFT JOIN(
                                    SELECT
                                        product_id,
                                        SUM(quantity) AS openingqty,
                                         sum(cost_price * quantity) AS openingsum
                                        
                                    FROM
                                        erp_stock_ledger
                                    WHERE
                                        ' . $opencondition . '
                                    GROUP BY product_id
                                ) AS OP
                                ON
                                    OP.product_id = S.id
                            WHERE ' . $storecondition . '
                            ';
                    $arr_items = Yii::app()->db->createCommand($sql)->queryAll();


                    foreach ($arr_items as $i => $each) {
                        $closing_balance = $each['openingqty'] + $each['purchaseqty'] + $each['purchasereturnqty'] + $each['salesqty'] + $each['salesreturnqty'] + $each['receiptqty'] + $each['issueqty'] + $each['tinqty'] + $each['toutqty'];
                        
                        
                        $closing_value = $each['openingsum'] + $each['purchasesum'] + $each['purchasereturnsum'] + $each['salessum'] + $each['salesreturnsum'] + $each['receiptsum'] + $each['issuesum'] + $each['tinsum'] + $each['toutsum'];

                    
                    ?>

                        <tr>
                            <td class="text-center"><?php echo $i + 1; ?></td>
                            <td><?php echo $each['part_number']; ?></td>
                            <td><?php echo $each['description']; ?></td>
                            <td><?php echo $each['brand_name']; ?></td>
                            <td class="text-right"><?php echo number_format($each['openingqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['openingsum'], 2); ?></td>
                            

                            <td class="text-right"><?php echo number_format($each['purchaseqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['purchasesum'], 2); ?></td>

                            <td class="text-right"><?php echo number_format($each['purchasereturnqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['purchasereturnsum'], 2); ?></td>

                            <td class="text-right"><?php echo number_format($each['salesqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['salessum'], 2); ?></td>

                            <td class="text-right"><?php echo number_format($each['salesreturnqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['salesreturnsum'], 2); ?></td>


                            <td class="text-right"><?php echo number_format($each['receiptqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['receiptsum'], 2); ?></td>


                            <td class="text-right"><?php echo number_format($each['issueqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['issuesum'], 2); ?></td>


                            <td class="text-right"><?php echo number_format($each['tinqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['tinsum'], 2); ?></td>


                            <td class="text-right"><?php echo number_format($each['toutqty'], 2); ?></td>
                            <td class="text-right"><?php echo number_format($each['toutsum'], 2); ?></td>


                            <td class="text-right"><?php echo number_format($closing_balance, 2); ?></td>
                              <td class="text-right"><?php echo number_format($closing_value, 2); ?></td>


                        </tr>
                    <?php
                    }

                    ?>



                </tbody>
            </table>
            <br />
            <br>
            <div class="btn-wrap text-center">
                <?php //echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('reports/PrintGoodReceiptReportPDF', 'from_date' => $from_date, 'to_date' => $to_date, 'customer_shipping_id' => $customer_shipping_id, 'customer_id' => $customer_id, 'goodid' => $goodid,'warehouse_id' =>$warehouse_id), array('title' => 'Export Job Order Pdf', 'target' => '_blank', 'class' => 'btn btn-theme')); 
                ?>
                <!--<button type="button" class="btn btn-theme" onclick="excelGoodReceiptList();" title="Export Excel"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>-->
            </div>
        </div>
    </div>
</div>