<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Sales Summary Report
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($from_date != '') {
                ?>
                    <div class="filter-item">
                        <label> From :</label>
                        <?php echo $from_date; ?>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($to_date != '') {
                ?>
                    <div class="filter-item">
                        <label> To :</label>
                        <?php echo $to_date; ?>
                    </div>
                <?php
                }
                ?>
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <?php
            if ($from_date != '') {
                $from_date = str_replace('/', '-', $from_date);
                $from_date = date('Y-m-d', strtotime($from_date));
            }
            if ($to_date != '') {
                $to_date = str_replace('/', '-', $to_date);
                $to_date = date('Y-m-d', strtotime($to_date));
            }
            $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
            $condition = 'isActive="Y" AND warehouse_code!="DAM" ';
            if (Yii::app()->user->level > 1) {
                $condition .= 'AND id=' . $warehouse_id;
            }
            $modelMasInventoryWarehouse = new MasInventoryWarehouse();
            $arr_warehouse_list = $modelMasInventoryWarehouse->findAll(array('condition' => $condition));
            $arr_month = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            $start_date1 = new DateTime("$from_date");
            $end_date1 = new DateTime("$to_date");
            /* $dcsql = "SELECT * FROM view_datewise_warehouse_sales I
              WHERE I.invoice_date >= :start_date AND I.invoice_date <= :end_date";
            $command1 = Yii::app()->db->createCommand($dcsql);
            $command1->bindParam(":start_date", $from_date);
            $command1->bindParam(":end_date", $to_date);
            $datewise_warehouse_saleslist = $command1->queryAll();*/
// ---------------------------------------------
            $sql_comm = "SELECT 
                        sum(item_amount) as  amount,
                        sum(grand_total) as grand_total,
                        sum(item_tax_vat_amount) as  tax_vat_amount,
                        sum(item_deduction_amount) as deduction_amount ,
                        sum(item_net_amount) as net_amount ,
                        sum(item_amount-item_deduction_amount) as invoice_amount,
                        warehouse_id,invoice_date
                        FROM view_commission_sales_report   
                        WHERE  invoice_date >='" . $from_date . "' AND invoice_date <='" . $to_date . "'
                         GROUP BY  invoice_date,warehouse_id ";
            $commistion_list = Yii::app()->db->createCommand($sql_comm)->queryAll();
// ---------------------------------------------
            $sql_comm_cn = "SELECT 
                    sum(item_rate) as  item_rate,
                    sum(item_net_amount+item_tax_vat_amount) as net_amount,
                    sum(item_tax_vat_percentage) as  item_tax_vat_percentage,
                    sum(item_tax_vat_amount) as tax_vat_amount ,
                     sum(total_tax_amount) as total_tax_amount,
                    sum(credited_amount) as credited_amount,credited_date,
                    warehouse_id,warehouse_name,user_name,created_by,invoice_id,creditnote_no,creditnote_id,invoice_no
                    FROM view_commission_creditnote_report   
                    WHERE  credited_date >='" . $from_date . "' AND credited_date <='" . $to_date . "'
                    $condition_cr GROUP BY created_by ";
            $creditnote_list = Yii::app()->db->createCommand($sql_comm_cn)->queryAll();
            
            
            
                    
                    
// ---------------------------------------------
            $grandtotal_inv_amt_wo_tax = 0;
            $grouped_results   = [];
            $warehouse_results = [];
            foreach ($commistion_list as $result) {
                $group_key = "{$result['invoice_date']}_{$result['warehouse_id']}";
                $grouped_results[$group_key] = $result;
                $warehouse_results[$result['warehouse_id']] += $result['invoice_amount'];
                $grandtotal_inv_amt_wo_tax += $result['invoice_amount'];
            }
            
       // ---------------------------------------------
     
            $grandtotal_inv_amt_wo_tax_cr = 0;
            $grouped_results_cr   = [];
            $warehouse_results_cr = [];
            foreach ($creditnote_list as $result_cr) {
                $group_key_cr = "{$result_cr['credited_date']}_{$result_cr['warehouse_id']}";
                $grouped_results_cr[$group_key_cr] = $result_cr;
                $warehouse_results_cr[$result_cr['warehouse_id']] += $result_cr['net_amount'];
                $grandtotal_inv_amt_wo_tax_cr += $result_cr['net_amount'];
                
            }
           // ---------------------------------------------
 
            
            ?>
            <table id="tbl_salessummary_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr>
                        <th style="width:7%;">Date</th>
                        <?php foreach ($arr_warehouse_list as $warehouse_list) {
                        ?>
                            <th><?php echo $warehouse_list->warehouse_name; ?></th>
                        <?php }
                        ?>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    while ($start_date1 <= $end_date1) {
                        $total_inv_amt_wo_tax = 0;
                    ?>
                        <tr>
                            <td class="text-left"><?php echo  $start_date1->format("d") . '-' . $arr_month[(int) $start_date1->format("m") - 1] . '-' . $start_date1->format("y"); ?></td>
                            <?php foreach ($arr_warehouse_list as $warehouse_list) {
                                $inv_amt_wo_tax = $grouped_results[$start_date1->format("Y-m-d") . '_' . $warehouse_list->id]['invoice_amount'];
                                
                                $inv_amt_wo_tax_cr = $grouped_results_cr[$start_date1->format("Y-m-d") . '_' . $warehouse_list->id]['net_amount'];
                                $total_inv_amt_wo_tax += $inv_amt_wo_tax;
                                $total_inv_amt_wo_tax_cr += $inv_amt_wo_tax_cr;
                            ?>
                                <td class="text-right">
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($inv_amt_wo_tax-$inv_amt_wo_tax_cr, " "); ?>
                                </td>
                            <?php } ?>
                            <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($total_inv_amt_wo_tax-$total_inv_amt_wo_tax_cr, " "); ?>
                            </td>
                            <?php $start_date1->add(new DateInterval("P1D")); ?>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td class="text-right"> <b>Total</b></td>
                        <?php foreach ($arr_warehouse_list as $warehouse_list) {
                        ?>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($warehouse_results[$warehouse_list->id]-$warehouse_results_cr[$warehouse_list->id], " "); ?></b></td>
                        <?php } ?>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($grandtotal_inv_amt_wo_tax-$grandtotal_inv_amt_wo_tax_cr, " ");     ?></b> </td>
                    </tr>
                </tbody>
            </table>
            <br />
        </div>
    </div>
</div>