<?php
$condition = 'quantity < re_order_level';
if ($part_no != '') {

    $condition .= ' AND part_number LIKE "%' . $part_no . '%"';
}

if ($brand_id != '') {
    $condition .= ' AND brand_id =' . $brand_id;
}


$SQL = "SELECT * FROM view_all_stock_items WHERE " . $condition . "";
$modelstockItems = Yii::app()->db->createCommand($SQL)->queryAll();

?>


<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Reorder Level List

    </div>

    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:12px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Part Number</th>
                        <th>Description</th>
                        <th>Brand</th>
                        <th>Total Qty</th> 
                        <th>Reorder Level</th>

                    </tr>
                </thead>
                <tbody>



                    <?php
                    foreach ($modelstockItems as $k => $eachItem) {
                        ?>
                        <tr>
                            <td style="width: 2%;"><?php echo $k + 1; ?></td>
                            <td style="width: 5%;"><?php echo $eachItem['part_number']; ?></td>
                            <td style="width: 20%;"><?php echo $eachItem['description']; ?></td>
                            <td style="width: 5%;"><?php echo $eachItem['brand']; ?></td>
                            <td class="text-right" style="width: 5%;"><?php echo Yii::app()->numberFormatter->formatCurrency($eachItem['quantity'], " "); ?></td>
                            <td style="width: 5%;"><?php echo $eachItem['re_order_level']; ?></td>



                        </tr>
                    <?php } ?>


                </tbody>    
            </table>
            <div class="btn-wrap text-center">    
                <?php
                echo CHtml::link('PDF', array('reports/PrintReorderLevelStockPdf', 'brand_id' => $brand_id, 'part_no' => $part_no), array('title' => 'Print Reorder Level Stock', 'target' => '_blank', 'class' => 'btn btn-theme'));
                //echo CHtml::link('Export PDF',array('reports/PrintInventoryReportPDF','part_number'=>$part_number,'generic_name'=>$generic_name), array('title'=>'Print Lead List','target'=>'_blank','class' =>  'btn btn-theme')); 
                ?>    

                <button type="button" class="btn btn-theme" onclick="excelInventoryList();">Excel</button>
                <?php  //echo CHtml::link('Send Mail', array('reports/sendmailtocustomersubmit'), array('title' => 'Send Mail', 'class' => 'btn btn-theme')); ?>
                <!--               <button type="button" class="send-mail-customer-save-btn btn btn-theme" onclick="SendMailToCustomer();" id="btn_send_email" style="display:none;">Send Mail</button>-->
            </div>    
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelInventoryList", "function excelInventoryList(){

            
            var part_no  = $('#reorderlevel_part_no').val();;
            
            var brand_id     = $('#reorderlevel_brand_name').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintReorderLevelStockExcel&part_no='+part_no+'&brand_id='+brand_id, '_blank');

}", CClientScript::POS_HEAD);
$cs->registerScript("SendMailToCustomer", "function SendMailToCustomer(){
  jQuery.ajax({
           // 'data' :{'job_order_ids':job_order_ids,'agent_ids':agent_ids,'shipper_id':shipper_id,'contact_ids':contact_ids},
            'type':'post',
            'dataType' : 'json',
            'url': '" . Yii::app()->createUrl('logistics/joborder/sendmailtocustomersubmit') . "',
            'beforeSend':function()
             {
              $('.send-mail-customer-save-btn').attr('disabled', 'disabled');
              $('#process').css('display', 'block');
             },
            'success': function(data) {
              var percentage = 0;
              var success_msg = data.success;
              var error_msg = data.error;
    
              var timer = setInterval(function(){
               percentage = percentage + 20;
               progress_bar_process(percentage, timer,success_msg,error_msg,'save');
              }, 1000);
              
            }
        });
    
    
    // else{
    //     t8.error('Please choose an Email');
    //     return false;
    // }
    
    
    
}", CClientScript::POS_HEAD);


$cs->registerScript("checkAllContacts", "function checkAllContacts()
{
    if($('#chk_all_contacts').prop('checked')==true){
        $('.check_contact_ids').prop('checked', true);
    }
    else{
        $('.check_contact_ids').prop('checked', false);
    }
    
      
}", CClientScript::POS_HEAD);
?>

<script type="text/javascript">



    function progress_bar_process(percentage, timer, success_msg, error_msg, frm)
    {
        $('.progress-bar').css('width', percentage + '%');
        if (percentage > 100)
        {
            clearInterval(timer);
            //$('#send-mail-customer-form')[0].reset();
            $('#process').css('display', 'none');
            $('.progress-bar').css('width', '0%');
            if (frm == 'load') {
                $('.load-mail-customer-refresh-btn').attr('disabled', false);
                $('#div_contact_details').html("<div class='alert alert-success'>" + success_msg + "</div>");
                $('#btn_send_email').show();
            } else {
                $('.send-mail-customer-save-btn').attr('disabled', false);
                $('#success_message').html("<div class='alert alert-success'>" + success_msg + "</div>");
            }

            if (error_msg != '') {
                $('#error_message').html("<div class='alert alert-danger'>" + error_msg + "</div>");
            }
            setTimeout(function () {
                $('#success_message').html('');
                $('#error_message').html('');
            }, 10000);
        }
    }

</script>
