<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Production Consumption List
        <div class="pull-right">
            <div class="filter_details">

                <?php
                if ($from_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>From :</label>
                        <?php echo $from_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label> To :</label>
                        <?php echo $to_date ?>
                    </div>

                    <?php
                }
                ?>
                <?php if (!empty($generic_id) && $generic_id != 'null'): ?>
                    <div class="filter-item">
                        <label>Category :</label>
                        <?php
                        if (!is_array($generic_id)) {
                            $generic_id = explode(',', $generic_id); // ✅ Fix here
                        }
                        $categories = MasGeneric::model()->findAllByPk($generic_id);
                        echo implode(', ', CHtml::listData($categories, 'id', 'generic_name'));
                        ?>
                    </div>
                <?php endif; ?>

            </div>
            <?php

            ?>
        </div>
    </div>
</div>
<div class="panel-body">
    <div class="table-responsive">
        <table id="tbl_order_table" class="table table-fixed table-bordered table-primary">
            <thead>
                <tr>
                    <th>Order</th>
                    <th>PO Date</th>
                    <!-- <th>WareHouse</th> -->
                    <th>Produced Item</th>
                    <th>Produced Description</th>
                    <th>Raw Material</th>
                    <th>RM Description</th>
                    <th>Produced Quantity</th>
                    <th>RM Quantity</th>
                    <th>Rate</th>
                    <th>Value</th>
                    <th>Category</th>
                    <!-- <th>Inv. Type</th> -->
                    <!-- <th>Status</th> -->
                </tr>
            </thead>
            <tbody>
                <?php
                $condition = '1=1';
                if ($from_date != '') {
                    $from_date = str_replace('/', '-', $from_date);
                    $from_date = date('Y-m-d', strtotime($from_date));
                    $condition .= ' AND po.productionorder_date >= "' . $from_date . '"';
                }

                if ($to_date != '') {
                    $to_date = str_replace('/', '-', $to_date);
                    $to_date = date('Y-m-d', strtotime($to_date));
                    $condition .= ' AND po.productionorder_date <= "' . $to_date . '"';
                }

                if ($produced_part_no_id != '') {
                    $condition .= ' AND poi.product_id = "' . $produced_part_no_id . '"';
                }

                if ($product_no != '') {
                    $condition .= ' AND po.product_id = "' . $product_no . '"';
                }

                if (!empty($generic_id)) {
                    if (!is_array($generic_id)) {
                        $generic_id_arr = explode(',', $generic_id); // convert CSV string to array
                    } else {
                        $generic_id_arr = $generic_id;
                    }

                    $categoryIds = array_filter(array_map('intval', $generic_id_arr)); // sanitize
                
                    if (!empty($categoryIds)) {
                        $condition .= ' AND p.generic_id IN (' . implode(',', $categoryIds) . ')';
                    }
                }

                if ($inventory_type != '') {
                    $condition .= ' AND p.inventory_item_type = "' . $inventory_type . '"';
                }

                // if ($warehouse_id != '') {
                //     $condition .= ' AND po.warehouse_id = "' . $warehouse_id . '"';
                // }
                if ($POstatus != '') {
                    $condition .= ' AND po.POstatus = "' . $POstatus . '"';
                }
                // echo $condition;
                // die();
                // Build SQL with proper joins to get warehouse and product info
$sql = "
    SELECT
        po.id AS order_id,
        po.productionorder_date,
        p.part_number,
        p.description,
        p.inventory_item_type,
        p.generic_id,
        poi.product_name AS production_item_name,
        po.quantity AS production_item_quantity,
        SUM(GII.picked_qty) AS quantity,  -- Total picked qty for this product
        p.rate,
        SUM(GII.picked_qty)  * p.rate AS total_amt,
        poi.product_id,
        po.product_id AS produced_item,
        po.description AS produced_item_description

    FROM
        erp_production_order_item poi
    INNER JOIN
        erp_production_order po ON po.id = poi.production_order_id
    LEFT JOIN
        erp_store p ON p.id = poi.product_id
    LEFT JOIN
        erp_inventory_goods_issue GI ON GI.reference_id = po.id
    LEFT JOIN
        erp_inventory_goods_issue_item GII 
            ON GII.inventory_goods_issue_id = GI.id 
            AND GII.product_id = poi.product_id

    WHERE
       $condition

    GROUP BY
        po.id, poi.product_id

    ORDER BY
        po.id DESC
";

                $production_data = Yii::app()->db->createCommand($sql)->queryAll();

                foreach ($production_data as $row) {
                    // Map inventory item types
                    $inventoryTypes = [
                        1 => 'Stock Item',
                        2 => 'Service Item',
                        3 => 'Raw Material',
                        4 => 'Bunch',
                    ];
                    $inventory_item_type = isset($inventoryTypes[$row['inventory_item_type']]) ? $inventoryTypes[$row['inventory_item_type']] : 'Unknown';

                    $inventoryStatus = [
                        'AP' => 'Completed',
                        'O' => 'Open',
                        'C' => 'Cancelled'

                    ];
                    // $inventory_item_status = isset($inventoryStatus[$row['status']]) ? $inventoryStatus[$row['status']] : 'Unknown';
                
                    // Get category name safely
                    $category_name = '';
                    if (!empty($row['generic_id'])) {
                        $category = MasGeneric::model()->findByPk($row['generic_id']);
                        $category_name = $category ? $category->generic_name : '';
                    }

                    // Get subcategory name safely
                    $subcategory_name = '';


                    // Get Produced Item name safely
                    $produced_name = '';
                    if (!empty($row['produced_item'])) {
                        $produced_name = Store::model()->findByPk($row['produced_item']);
                        $produced_name = $produced_name ? $produced_name->part_number : '';
                    }
                    if ($row['quantity'] > 0) {
                        $actual_amt = $row['total_amt'] / $row['quantity'];
                    } else {
                        $actual_amt = 0;
                    }
                    $total_amount += $row['total_amt'];
                    echo '<tr>';
                    echo '<td>' . htmlspecialchars($row['order_id']) . '</td>';
                    echo '<td>' . htmlspecialchars(date('d/m/Y', strtotime($row['productionorder_date']))) . '</td>';
                    // echo '<td>' . htmlspecialchars($row['warehouse_name']) . '</td>';
                    echo '<td>' . htmlspecialchars($produced_name) . '</td>';
                    echo '<td>' . htmlspecialchars($row['produced_item_description']) . '</td>';
                    echo '<td>' . htmlspecialchars($row['production_item_name']) . '</td>';
                    echo '<td>' . htmlspecialchars($row['description']) . '</td>';                    
                    echo '<td class="text-right">' . htmlspecialchars(number_format($row['production_item_quantity'], 0)) . '</td>';
                    echo '<td class="text-right">' . htmlspecialchars(number_format($row['quantity'], 0)) . '</td>';
                    echo '<td class="text-right">' . htmlspecialchars(number_format($row['rate'], 2)) . '</td>';
                    echo '<td class="text-right">' . htmlspecialchars(number_format($row['total_amt'], 2)) . '</td>';
                    echo '<td>' . htmlspecialchars($category_name) . '</td>';
                    // echo '<td>' . htmlspecialchars($inventory_item_type) . '</td>';
                    // echo '<td>' . htmlspecialchars($inventory_item_status) . '</td>';
                    echo '</tr>';
                }
                echo '<tr>';
                echo '<td colspan="9" class="text-right"><strong>Total Amount</strong></td>';
                echo '<td class="text-right"><strong>' . number_format($total_amount, 2) . '</strong></td>';
                echo '<td colspan="4"></td>';
                echo '</tr>';
                ?>
            </tbody>
        </table>
        <br>
        <!--- Pdf & excel btns moved to filter page --- commented ---  Ambika --->
        <!--            <div class="btn-wrap text-center">
                
                <a title="Export Pdf" class="btn btn-theme" onclick="purchaseOrderListPDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a> 
                <a title="Export Excel" class="btn btn-theme" onclick="excelPurchaseOrderList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</a>
            
            </div>-->
    </div>
</div>
</div>