<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Enquiries
        <div class="pull-right">
            <div class="filter_details">

                <?php if (!empty($enquiry_fromdate)) { ?>
                    <div class="filter-item">
                        <label> From Date :</label>
                        <?php echo $enquiry_fromdate; ?>
                    </div>
                <?php } ?>

                <?php if (!empty($enquiry_todate)) { ?>
                    <div class="filter-item"> 
                        <label> To Date :</label>
                        <?php echo $enquiry_todate; ?>
                    </div>
                <?php } ?>

            </div>
        </div>
    </div>

    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_order_table" class="table table-fixed table-bordered table-primary dataTable html_table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Enquiry ID</th>
                        <th>Enquiry Date</th>
                        <th>Required Date</th>
                        <th>Suppliers</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';

                    // ✅ Enquiry date range filter
                    if (!empty($enquiry_fromdate) && !empty($enquiry_todate)) {
                        $enquiry_fromdate = date('Y-m-d', strtotime(str_replace('/', '-', $enquiry_fromdate)));
                        $enquiry_todate   = date('Y-m-d', strtotime(str_replace('/', '-', $enquiry_todate)));

                        $condition .= ' AND t.enquiry_date BETWEEN "' . $enquiry_fromdate . '" AND "' . $enquiry_todate . '"';
                    }
                   // echo $condition;
                    // ✅ Required date filter
                    if (!empty($required_date)) {
                        $required_date = date('Y-m-d', strtotime(str_replace('/', '-', $required_date)));
                        $condition .= ' AND t.required_date <= "' . $required_date . '"';
                    }

                    $model_order = PurchasingEnquiry::model()->findAll([
                        'condition' => $condition,
                        'order'     => 't.id DESC'
                    ]);

                    if (!empty($model_order)) {
                        foreach ($model_order as $i => $model) {
                            ?>
                            <tr>
                                <td><?php echo $i + 1; ?></td>
                                <td><?php echo $model->id; ?></td>

                                <td>
                                    <?php
                                    echo (!empty($model->enquiry_date) && $model->enquiry_date != '0000-00-00')
                                        ? date("d/m/Y", strtotime($model->enquiry_date))
                                        : '&nbsp;';
                                    ?>
                                </td>

                                <td>
                                    <?php
                                    echo (!empty($model->required_date) && $model->required_date != '0000-00-00')
                                        ? date("d/m/Y", strtotime($model->required_date))
                                        : '&nbsp;';
                                    ?>
                                </td>

                                <td>
                                    <?php
                                    $vendor_ids = $model->vendor_id;
                                    $ids = strpos($vendor_ids, ',') !== false
                                        ? array_map('trim', explode(',', $vendor_ids))
                                        : [trim($vendor_ids)];

                                    $names = [];
                                    foreach ($ids as $id) {
                                        if (!empty($id)) {
                                            $names[] = Vendor::getVendorName($id);
                                        }
                                    }

                                    echo implode(", ", $names);
                                    ?>
                                </td>
                            </tr>
                            <?php
                        }
                    } else { ?>
                        <tr>
                            <td colspan="5" class="text-center">No Data Found</td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <br>
        </div>
    </div>
</div>
