<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Schedule Maintenance List</title>
</head>
<style type="text/css">
    @media print {
        body {
            -webkit-print-color-adjust: exact;
        }
    }
</style>


<body>
    <div class="heading">
        <div class="row" style="align-items: center;">
           <?php $this->renderPartial('//common/header', array('header_name' => 'SCHEDULE MAINTENANCE LIST'));?>
            <div class="col-8 text-center">
                <h4 style="margin: 0; color: #000000; font-size: 16px; font-weight: bold;">

                </h4>
            </div>

            <!-- Right: Empty Space (or optional user info) -->
            <div class="col-2"></div>
        </div>

        <div class="row" style="margin-top: 10px;">
            <div class="col-12 text-center">
                <div class="h3" style="margin-top: 0; margin-bottom: 0; color: #000000; font-size: 14px;">
                    <?php echo 'SCHEDULE MAINTENANCE LIST'; ?>
                </div>
            </div>
        </div>

        <br><br><br>

        <div class="table-body">
            <table id="tbl_enquiry_table" class="table">
                <thead>
                    <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Outlet</th>
                        <th>Planned Date</th>
                        <th>Assigned User</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 0;
                    $model = new Customer();
                    $condition = "repair_request.schedule_status = 'S'";
                    if (Yii::app()->user->authorised_user != 1) {
                        $condition .= ' AND t.isActive= "Y" AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR t.created_by="' . Yii::app()->user->id . '")';
                    }
                    if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                        $searchString = $_POST['search']['value'];
                        $condition .= " AND  (customer_name LIKE '%" . $searchString . "%' OR customer_phone_no LIKE '%" . $searchString . "%' )";
                    }
                    $model = $model->with('repair_request')->findAll(array('condition' => $condition,'group'=>'repair_request.assigned_id'));

                    foreach ($model as $key => $row) {
                        $machine_id = $row->repair_request->id;
                        $modelSalesRepairRequestItem = new SalesRepairRequestItem();
                        $cnt_machine = (int) $modelSalesRepairRequestItem->count(array('condition' => 'header_id="' . $machine_id . '"'));
                        ?>
                        <tr>
                            <td><?php echo ++$i; ?></td>
                            <td><?php echo $row->customer_name; ?></td>
                            <td><?php echo $row->repair_request_det->customer_outlet->outlet_location; ?></td>
                            <td><?php echo date('d/m/Y', strtotime($row->repair_request_det->schedule_date)); ?></td>
                            <td><?php echo $row->repair_request_det->assigned->fullname; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
      <br>
    <?php $this->renderPartial("//common/footer",array('company_id'=>$company_id));?>
</body>


</html>