<?php
$modlCompy = new MasCompany();
$decimal_point = $modlCompy->no_of_decimals_rate;
?>
<!DOCTYPE html>
<html>

<head>
    <title>Purchase Order List</title>
</head>

<body>
    <div class="">
        <?php $this->renderPartial('//common/header'); ?>

        <div class="col-4">
            <br>
        </div>

        <div class="col-4">
            <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 16px;">
                <?php echo strtoupper("PURCHASE ORDER LIST"); ?>
            </div>
        </div>

        <div class="col-4" style="color:#101010;">
            <table class="table" style="width:100%">
                <?php if ($order_from_date != '') { ?>
                    <tr>
                        <td style="width:40%">From Date</td>
                        <td><?php echo $order_from_date; ?></td>
                    </tr>
                <?php } ?>

                <?php if ($order_to_date != '') { ?>
                    <tr>
                        <td style="width:40%">To Date</td>
                        <td><?php echo $order_to_date; ?></td>
                    </tr>
                <?php } ?>

                <?php if ($vendor_id != '') {
                    $v = Vendor::model()->findByPK($vendor_id);
                    ?>
                    <tr>
                        <td style="width:40%">Supplier</td>
                        <td><?php echo $v->vendor_name; ?></td>
                    </tr>
                <?php } ?>

                <?php if ($completed != '') {
                    $Status_data = array('P' => 'MR(P)', 'C' => 'Short Closure');
                    ?>
                    <tr>
                        <td style="width:40%">Status</td>
                        <td><?php echo $Status_data[$completed]; ?></td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>
    <br>

    <div class="col-md-12">

        <div class="table-body">
            <table id="tbl_enquiry_table" class="table">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Order No</th>
                        <th>File No</th>
                        <!-- <th>Title</th> -->
                        <th>Supplier</th>
                        <th>Order Date</th>
                        <th>Status</th>
                        <th>Grand Total</th>
                        <th>Grand Total(BC)</th>

                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';
                    if ($order_from_date != '') {
                        $order_from_date = str_replace('/', '-', $order_from_date);
                        $order_from_date = date('Y-m-d', strtotime($order_from_date));
                        $condition .= ' AND t.order_date >="' . $order_from_date . '"';
                    }
                    if ($order_to_date != '') {
                        $order_to_date = str_replace('/', '-', $order_to_date);
                        $order_to_date = date('Y-m-d', strtotime($order_to_date));
                        $condition .= ' AND t.order_date <="' . $order_to_date . '"';
                    }

                    if ($vendor_id != '') {
                        $condition .= ' AND t.vendor_id ="' . $vendor_id . '"';
                    }
                    if ($completed != '') {
                        $condition .= ' AND t.completed ="' . $completed . '"';
                    }
                    $total = 0;
                    $model_order = PurchasingOrder::model()->with('vendor_details')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
                    foreach ($model_order as $i => $model) {
                        $status = '';
                        if ($model->file->current_process_status == 'P_O') {
                            $status = 'Order';
                        } else if ($model->file->current_process_status == 'M_R') {
                            $status = 'Material Reciept';
                        } else if ($model->file->current_process_status == 'Q_C') {
                            $status = 'Quality Checked';
                        } else if ($model->file->current_process_status == 'P_I') {
                            $status = 'Invoice';
                        } else {
                            $status = '';
                        }
                        if ($model->completed == 'P') {
                            $status = 'Material Reciept (Partial)';
                        }
                        if ($model->completed == 'C') {
                            $status = 'Short Closure';
                        }
                        ?>
                        <tr>
                            <td>
                                <?php echo $i + 1; ?>
                            </td>
                            <td>
                                <?php echo $model->id; ?>
                            </td>
                            <td>
                                <?php echo $model->file_id; ?>
                            </td>
                            <!-- <td>
                                <?php //echo $model->title; ?>
                            </td> -->
                            <td class="nw">
                                <?php echo $model->vendor_details->vendor_name; ?>
                            </td>

                            <?php if ($model->order_date != '0000-00-00') { ?>
                                <td>
                                    <?php echo date("d/m/Y", strtotime($model->order_date)); ?>
                                </td>
                            <?php } else { ?>
                                <td>&nbsp;</td>
                            <?php } ?>
                            <td><?php echo $status; ?></td>
                            <!-- <td class="text-right">
                                <?php //echo $model->currencyname->currency_code . " "; ?><?php echo Yii::app()->numberFormatter->formatCurrency($model->stock_grand_total + $model->nonstock_grandtotal, ""); ?>
                            </td> -->
                            <td style="text-align:right;">
                                <?php echo $model->currencyname->currency_code . " "; ?>
                                <?php echo number_format(
                                    $model->stock_grand_total + $model->nonstock_grandtotal,
                                    $decimal_point,
                                    '.',
                                    ','
                                ); ?>
                            </td>

                            <?php
                            $model_currency = MasCurrency::model()->findByPk($model->currencyname->id);
                            $grand_total = $model->stock_grand_total + $model->nonstock_grandtotal;
                            $total_bc = $grand_total * $model_currency->exchange_rate;
                            $total += $total_bc
                                ?>
                            <td class="text-right"><?php echo number_format($total_bc, $decimal_point, '.', ','); ?> </td>


                        </tr>
                    <?php } ?>
                    <tr>
                        <td colspan="7" class="text-right" style=" font-weight:bold;">Total</td>
                        <td class="text-right" style="font-weight: bold;"><b>
                            <?php echo number_format($total, $decimal_point, '.', ',');?></b>
                        </td>

                    </tr>
                </tbody>
            </table>
        </div>

        <?php $this->renderPartial("//common/footer"); ?>
</body>

</html>