<?php
$condition = "1=1";

if ($vehicle_id > 0) {
    $condition .= " AND t.vehicle_id=".(int)$vehicle_id;
}
if ($employee_id > 0) {
    $condition .= " AND t.employee_id=".(int)$employee_id;
}
if (!empty($from_date)) {
    $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
    $condition .= " AND DATE(from_date) >= '" . $from_date . "'";
}
if (!empty($to_date)) {
    $to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
    $condition .= " AND DATE(to_date) <= '" . $to_date . "'";
}

$modelVehicleAllotment = VehicleAllotment::model()
    ->with('vehicle','employee')
    ->findAll(array(
        'condition' => $condition,
        'order' => 't.from_date ASC'
    ));
    //  echo $condition;
?>

<!DOCTYPE html>
<html>
<head>
    <title>Vehicle Allotment Report</title>
</head>
<body>

<div class="panel">
    <?php $this->renderPartial('//common/header'); ?>

    <div class="col-12">
        <div class="h3" style="margin-top: 0; margin-bottom: 10px; text-align: center; font-size: 16px; color:#101010;">
            <?php echo strtoupper("Vehicle Allotment Report"); ?>
        </div>

        <!-- Filter table aligned right -->
        <div class="col-4" style="color:#101010; margin-left:auto; float:right;"> 
            <table class="table" style="width:100%;">
                <?php if ($from_date != '') { ?>
                    <tr>
                        <td style="width:40%"><b>From Date</b></td>
                        <td><?php echo date("d/m/Y", strtotime($from_date)); ?></td>
                    </tr>
                <?php } ?>
                <?php if ($to_date != '') { ?>
                    <tr>
                        <td style="width:40%"><b>To Date</b></td>
                        <td><?php echo date("d/m/Y", strtotime($to_date)); ?></td>
                    </tr>
                <?php } ?>
                <?php if ($vehicle_id) {
                    $vehicle = MasVehicle::model()->findByPk($vehicle_id);
                    if ($vehicle) { ?>
                        <tr>
                            <td style="width:40%"><b>Vehicle</b></td>
                            <td><?php echo $vehicle->vehicle_make . ' ' . $vehicle->vehicle_model; ?></td>
                        </tr>
                <?php } } ?>
                <?php if ($employee_id) {
                    $emp = Employee::model()->findByPk($employee_id);
                    if ($emp) { ?>
                        <tr>
                            <td style="width:40%"><b>Employee</b></td>
                            <td><?php echo $emp->employeefullname; ?></td>
                        </tr>
                <?php } } ?>
            </table>
        </div>
    </div>
</div>


<div class="panel">
    <div class="panel-body">
        <div class="table-responsive">
            <table class="table table-fixed table-bordered table-primary">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee</th>
                        <th>Vehicle</th>
                        <th>From Date</th>
                        <th>To Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $count = 1;
                    if (!empty($modelVehicleAllotment)) {
                        foreach ($modelVehicleAllotment as $eachItem) { ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td><?php echo $eachItem->employee ? CHtml::encode($eachItem->employee->employeefullname) : '--'; ?></td>
                                <td><?php echo $eachItem->vehicle ? $eachItem->vehicle->vehicle_make . ' ' . $eachItem->vehicle->vehicle_model : '--'; ?></td>
                                <td><?php echo ($eachItem['from_date']!="0000-00-00 00:00:00") ? date('d/m/Y h:i A', strtotime($eachItem['from_date'])) : ""; ?></td>
                                <td><?php echo ($eachItem['to_date']!="0000-00-00 00:00:00") ? date('d/m/Y h:i A', strtotime($eachItem['to_date'])) : ""; ?></td>
                            </tr>
                        <?php }
                    } else { ?>
                        <tr>
                            <td colspan="5" class="text-center"><b>No Allotment Records Found</b></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $this->renderPartial("//common/footer"); ?>

</body>
</html>
