<!DOCTYPE html>
<html>

<head>
    <title>Inventory List</title>
</head>

<body>
<div class="">
<?php $this->renderPartial('//common/header'); ?>

    <div class="col-4">
        <br>
    </div>

    <div class="col-4">
        <div class="h3" style="margin-top:0;margin-bottom:0;text-align:center;font-size:16px;">
            <?php echo strtoupper("INVENTORY LIST"); ?>
        </div>
    </div>

    <div class="col-4" style="color:#101010;">
        <table class="table" style="width:100%">
            <tr>
                <td style="width:40%">Warehouse</td>
                <td>
                    <?php
                    if ($warehouse_id > 0) {
                        $w = MasInventoryWarehouse::model()->findByPk($warehouse_id);
                        echo $w ? $w->warehouse_name : "";
                    } else {
                        echo "All Warehouse";
                    }
                    ?>
                </td>
            </tr>

            <tr>
                <td>Brand</td>
                <td>
                    <?php
                    if ($brand_id > 0) {
                        $b = MasInvBrand::model()->findByPk($brand_id);
                        echo $b ? $b->brand_name : "";
                    } else {
                        echo "All Brands";
                    }
                    ?>
                </td>
            </tr>

            <?php if ($generic_id > 0): ?>
            <tr>
                <td>Category</td>
                <td>
                    <?php
                        $g = MasGeneric::model()->findByPk($generic_id);
                        echo $g ? $g->generic_name : "";
                    ?>
                </td>
            </tr>
            <?php endif; ?>
            <tr>
                <td style="width:40%">Display Type</td>
                <td>
                    <?php
                    if ($display_type == 1) {
                        echo "Having Stock";
                    } elseif ($display_type == 2) {
                        echo "All Items";
                    } else {
                        echo "All Items"; // default fallback
                    }
                    ?>
                </td>
            </tr>

        </table>
    </div>
</div>

<br>

<?php

    $condition = "1=1";  // same as AJAX function
    $qtycondition = "";

    if ($display_type == 1) {
        $qtycondition .= " WHERE quantity > 0 ";
    }

    if ($brand_id > 0) {
        $condition .= " AND brand_id = " . (int)$brand_id;
    }

    if ($generic_id > 0) {
        $condition .= " AND generic_id = " . (int)$generic_id;
    }
    

    if ($warehouse_id > 0) {
        $condition .= " AND (warehouse_id = " . (int)$warehouse_id . " OR warehouse_id = 0)";
    }
$type_array = MasInventoryItemType::getAll();
$modCompany = new MasCompany();
$decimal_point = $modCompany->no_of_decimals_rate;

// MAIN QUERY
$query = 'SELECT * FROM (
            SELECT 
                product_id,
                generic_id,
                part_number,
                description,
                brand_id,
                brand,
                SUM(quantity) AS quantity,
                inventory_item_type,
                rate,
                unit_name,
                SUM(quantity * rate) AS amount
            FROM view_warehousewise_stock
            WHERE ' . $condition . '
            GROUP BY product_id
        ) A ' . $qtycondition . '
        ORDER BY part_number ASC';

$model = Yii::app()->db->createCommand($query)->queryAll();

// TOTALS
$total = Yii::app()->db->createCommand(
    'SELECT 
        SUM(ROUND((quantity * rate),2)) AS total_rate,
        SUM(quantity) AS total_quantity
     FROM view_warehousewise_stock
     WHERE ' . $condition
)->queryAll();
// echo $condition;
?>

<div class="col-md-12">
    <div class="table-body">
        <table class="table table-bordered" id="table_inventory_list">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Part No</th>
                    <th>Description</th>
                    <th>Category</th>
                    <th>Brand Name</th>
                    <th>Item Type</th>
                    <th>Qty</th>
                    <th>Cost</th>
                    <th>Value</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach ($model as $i => $row): ?>

                <?php
                // GENERIC NAME
                $gen = MasGeneric::model()->findByPk($row['generic_id']);
                $generic_name = $gen ? $gen->generic_name : "";

                // ITEM TYPE NAME
                $item_type_name = isset($type_array[$row['inventory_item_type']])
                    ? $type_array[$row['inventory_item_type']]
                    : "";

                // UNIT
                $uom = UnitOfMeasurement::model()->find(
                    "product_id = {$row['product_id']}"
                );
                $unit_name = $uom ? $uom->name : "";

                // FORMATTED VALUES
                $formatted_cost  = number_format($row['rate'], $decimal_point, '.', ',');
                $formatted_value = number_format($row['amount'], $decimal_point, '.', ',');
                ?>
                <tr>
                    <td><?php echo $i + 1; ?></td>
                    <td><?php echo $row['part_number']; ?></td>
                    <td><?php echo $row['description']; ?></td>
                    <td><?php echo $generic_name; ?></td>
                    <td><?php echo $row['brand']; ?></td>
                    <td><?php echo $item_type_name; ?></td>
                    <td class="text-right"><?php echo $row['quantity'] . " " . $unit_name; ?></td>
                    <td class="text-right"><?php echo $formatted_cost; ?></td>
                    <td class="text-right"><?php echo $formatted_value; ?></td>
                </tr>

                <?php endforeach; ?>

                <tr>
                    <td colspan="6" class="text-right"><b>Total</b></td>
                    <td class="text-right">
                        <?php echo number_format($total[0]['total_quantity'], $decimal_point, '.', ','); ?>
                    </td>
                    <td></td>
                    <td class="text-right">
                        <?php echo number_format($total[0]['total_rate'], $decimal_point, '.', ','); ?>
                    </td>
                </tr>
            </tbody>

        </table>
    </div>

    <?php $this->renderPartial("//common/footer"); ?>
</div>

</body>
</html>
