<!DOCTYPE html>
<html>

<head>
    <title>Delivery Note List</title>
</head>

<body>
    <div class="">
        <?php $this->renderPartial('//common/header'); ?>

        <div class="col-4">
            <br>
        </div>

        <div class="col-4">
            <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 16px;">
                <?php echo strtoupper("DELIVERY NOTE LIST"); ?>
            </div>
        </div>
       
        <div class="col-4" style="color:#101010;">
            <table class="table" style="width:100%">
                <?php if ($del_from_date != '') { ?>
                    <tr>
                        <td style="width: 40%">From Date </td>
                        <td>
                            <?php echo $del_from_date; ?>
                        </td>
                    </tr>
                <?php } ?>
                <?php if ($del_to_date != '') { ?>
                    <tr>
                        <td style="width: 40%">To Date</td>
                        <td>
                            <?php echo $del_to_date; ?>
                        </td>
                    </tr>
                <?php } ?>

                <?php if ($customer_id != '') { ?>
                    <tr>
                        <td style="width: 40%">Customer </td>
                        <td>
                            <?php $c = Customer::model()->findByPK($customer_id);
                            echo $c->customer_name; ?>
                        </td>
                    </tr>
                <?php } ?>
                <?php if ($status != '') { ?>
                    <tr>
                        <td style="width: 40%">Status </td>
                        <td>
                            <?php
                            $status_type = "";
                            if ($status == 'C') {
                                echo 'Complete';
                                $status_type = 'Complete';
                            }
                            if ($status == 'P') {
                                echo 'Partial';
                                $status_type = 'Partial';
                            } ?>
                        </td>
                    </tr>
                <?php } ?>

            </table>
        </div>
    </div>
    <br>

    <div class="col-md-12">

        <div class="table-body">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Delivery No</th>
                        <th>File No</th>
                        <th>Order No</th>
                        <th>Customer Name</th>
                        <!-- <th>Created By</th> -->
                        <th>Lead Owner</th>
                        <th>Delivery Date</th>

                        <th>Delivery Status</th>

                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';
                    ;
                    if ($del_from_date != '') {
                        $del_from_date1 = str_replace('/', '-', $del_from_date);
                        $del_from_date1 = date('Y-m-d', strtotime($del_from_date1));
                        $condition .= ' AND t.delivery_date >="' . $del_from_date1 . '"';
                    }
                    if ($del_to_date != '') {
                        $del_to_date2 = str_replace('/', '-', $del_to_date);
                        $del_to_date2 = date('Y-m-d', strtotime($del_to_date2));
                        $condition .= ' AND t.delivery_date <="' . $del_to_date2 . '"';
                    }
                    if ($created_by != '') {
                        $condition .= ' AND t.created_by ="' . $created_by . '"';
                    }

                    //            if($sales_group_id != ''){
//                $condition .= ' AND t.sales_group ="' . $sales_group_id.'"';
//            }
                    if ($customer_id != '') {

                        $condition .= ' AND t.customer_id ="' . $customer_id . '"';
                    }
                    if ($status == 'P') {

                        $condition .= ' AND file.current_process_status  IN ("PD","PI")';
                    }
                    if ($status == 'C') {

                        $condition .= ' AND file.current_process_status IN ("D","I")';
                    }
                    //echo $condition;
                    $model_delivery = DeliveryNote::model()->with('customer', 'file')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
                    foreach ($model_delivery as $i => $model) {
                        $fstatus = '';
                        switch ($model['file']['current_process_status']) {
                            case 'I':
                                $fstatus = 'Invoiced';
                                break;
                            case 'D':
                                $fstatus = 'Delivered';
                                break;
                            case 'PD':
                                $fstatus = 'Partially Delivered';
                                break;
                            case 'PI':
                                $fstatus = 'Partially Invoiced';
                                break;
                        }

                        ?>
                        <tr>
                            <td><?php echo $i + 1; ?></td>
                            <td><?php echo $model->id; ?></td>
                            <td><?php echo $model->file_id; ?></td>
                            <td><?php echo $model->order_id; ?></td>
                            <td><?php echo $model->customer->customer_name; ?></td>
                            <!-- <td><?php //echo $model->getCreated_user(); ?></td> -->
                            <td>
                                <?php echo $model->order->leadowner->fullname; ?>
                            </td>
                            <?php if ($model->delivery_date != '0000-00-00') { ?>
                                <td><?php echo date("d/m/Y", strtotime($model->delivery_date)); ?></td>
                            <?php } else { ?>
                                <td>&nbsp;</td>
                            <?php } ?>
                            <!--                <td><?php //echo $model->salesgroup->group_name;   ?></td>-->
                            <td><?php echo $fstatus; ?></td>

                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <?php $this->renderPartial("//common/footer", array('company_id' => $company_id)); ?>
</body>

</html>