<!DOCTYPE HTML>
<html lang="en">

<head>
    <!--=============== basic  ===============-->

    <title>PRINT POS</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <!--=============== css  ===============-->
    <style type="text/css">
        body {
            font-family: 'Nunito', sans-serif;
            text-align: center;
            color: #777;
            background: #f9f9f9;
            font-weight: 400;
            margin: 0px;
            padding: 0px;

        }

        body h1 {
            font-weight: 500;
            margin-bottom: 0px;
            padding-bottom: 0px;
            color: #000;
        }

        @page {
            size: auto;
            margin: 0mm;
        }

        body h3 {
            font-weight: 400;
            margin-top: 10px;
            margin-bottom: 20px;
            font-style: italic;
            color: #000;
        }

        body a {
            color: #000;
        }

        .invoice-box {
            max-width: 500px;
            /* margin: 30px auto 30px; */
            margin: -29px auto 30px;
            padding: 15px;
            border: 1px solid #eee;
            font-size: 13px;
            line-height: 24px;
            background: #fff;
            color: #000;
        }

        .invoice-box table {
            width: 100%;
            /* width: 35%; */
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 3px;
            vertical-align: top;
        }

        .invoice-box table tr td:nth-child(2) {
            text-align: right;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 5px;
        }

        .invoice-box table tr.information table td {
            margin-top: 50px;
            padding-bottom: 20px;
        }

        .invoice-box table tr.heading td {
            background: #f9f9f9;
            border-bottom: 1px solid #eee;
            font-weight: 400;
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: 400;
        }

        .print-button {
            padding: 7px 26px;
            text-decoration: none;
            color: #fff;
            background: #3AACED;
            display: inline-table;
            font-weight: 900;
            margin: 20px 0;
            font-size: 13px;
            border-radius: 4px;

        }

        @media only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.top table td {
                padding-bottom: 20px;
            }

            .invoice-box table tr.information table td {
                margin-top: 20px;
                padding-bottom: 20px;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }

        @media print {
            .print-button {
                display: none;
            }

            .invoice-box {
                border: none;
            }
        }


        table th,
        table td {
            padding: 10px;
            border-bottom: 1px dashed;
            font-weight: 400;
        }

        table .desc {
            text-align: left;
        }

        table .unit {
            background: #f8f8f8;
        }

        table .qty {}

        table .total {
            background: #c00d0e;
            color: #FFFFFF;
        }

        table td.unit,
        table td.qty,
        table td.total {
            font-size: 1.2em;
        }

        .text-center {
            text-align: center !important;
        }

        .text-left {
            text-align: left !important;
        }

        .text-right {
            text-align: right !important;
        }

        .float-left {
            float: left !important;
        }

        .float-right {
            float: right !important;
        }

        .border-none {
            border: none !important;
        }

        .p-0 {
            padding: 0px !important;
        }

        .line_height {
            line-height: 0 !important;
        }

        .padd_left {
            padding-left: 0 !important;
            text-align: left !important;
        }

        .padd_right {
            padding-right: 0 !important;
            text-align: right !important;
        }

        .border-top {
            border-bottom: 1px dashed;
        }

        .product_border th {
            border: none;
        }
    </style>

</head>

<body onload="window.print()">
    <div class="invoice-box" id="divToPrint">

        <table>
            <tr class="top">
                <td colspan="2" style="border: none;">
                    <table>
                        <tr style="line-height:0;">
                            <td class="text-center border-none">

                                <?php
                                $address = '';
                                if (!empty($warehouse_id)) {
                                    $model = new MasInventoryWarehouse();

                                    $model_det = $model->findByPk($warehouse_id);
                                    $branch_logo = $model_det->upload_image;
                                    $warehouse_outlet_name = $model_det->warehouse_outlet_name;
                                    $address = $model_det->address;
                                }

                                if (!empty($branch_logo)) {

                                    $logo_name = $branch_logo;
                                } else {
                                    if (isset(Yii::app()->user->pdf_company_logo)) {
                                        $logo_name = Yii::app()->user->pdf_company_logo;
                                    } else {
                                        $logo_name = "pdf_logo.png";
                                    }
                                }




                                ?>
                                <?php if (!empty($branch_logo)) { ?>
                                    <img src="<?php echo  'uploads/warehouse/thumbs/' . $logo_name; ?>" />
                                <?php } else { ?>
                                    <img src="<?php echo  'images/logo/' . $logo_name;   ?>" />
                                <?php } ?>


                            </td>

                        </tr>
                        <tr>
                            <td class="title text-center border-none p-0">
                                <h2 style="font-size: 15px;font-weight: 600;margin: 0;"><?php echo MasInventoryWarehouse::getWarehouseName($warehouse_id) ?></h2>
                                <p style="margin: 0;font-size: 13px;width: 100%;display: inline-block;line-height: 1.4;">

                                    <?php

                                    if (!empty($address)) {
                                        echo nl2br($address);
                                    }

                                    ?>



                                    <br>

                                </p>
                            </td>
                        </tr>
                        <!-- -------------- -->
                        <table>
                            <tr>
                                <td></td>
                            </tr>
                        </table>
                        <!-- -------------- -->
                        <tr>

                            <td class="title text-center border-none p-0 line_height">
                                <p style="margin: 0;font-size: 16px;width: 50%;display: inline-block;font-weight: 600;line-height: 1;">
                                    Settlement Report </p>
                            </td>
                        </tr>

                    </table>
                </td>
            </tr>

            <!-- -------------- -->
            <table>
                <tr>
                    <td></td>
                </tr>
            </table>
            <!-- -------------- -->
            <?php
            $date = str_replace('/', '-', $date);
            $selected_date = date("Y-m-d", strtotime($date));
            $condition = " t.opening_date = '$selected_date' ";



            $modelOpCash = new OpeningCash();
            $modelOpCash = $modelOpCash->find(['condition' => $condition]);
            $opening_cash = 0;
            if (!empty($modelOpCash)) {
                $opening_cash = $modelOpCash->opening_cash;
            }



            // -----------inv----------------------------------



            $sql_inv = "SELECT 
                    sum(item_amount) as  amount,
                    sum(grand_total) as grand_total,
                    sum(item_tax_vat_amount) as  tax_vat_amount,
                    sum(item_deduction_amount) as deduction_amount ,
                    sum(item_net_amount) as net_amount ,
                    sum(item_cost_amount) as item_cost_amount,
                    sum(received_cash_amount) as received_cash_amount, 
                    sum(received_card_amount) as received_card_amount, 
                    sum(commission_amount) AS commission_amount ,
                    warehouse_id,warehouse_name,user_name,created_by,invoice_id,invoice_no
                    FROM view_commission_sales_report   
                    WHERE invoice_date = :selected_date AND warehouse_id = :warehouse_id
                    ";

            $command1 = Yii::app()->db->createCommand($sql_inv);
            $command1->bindParam(":selected_date", $selected_date);
            $command1->bindParam(":warehouse_id", $warehouse_id);
            $inv_details = $command1->queryAll();


            $inv_amount            = isset($inv_details[0]['amount']) ? $inv_details[0]['amount'] : 0;

            $deduction_amount      = isset($inv_details[0]['deduction_amount']) ? $inv_details[0]['deduction_amount'] : 0;

            $total_discount_inv    = !empty($inv_details) ? $inv_details[0]['deduction_amount'] : 0;

            $total_cash_amount_inv = !empty($inv_details) ? $inv_details[0]['received_cash_amount'] : 0;

            $total_card_amount_inv = !empty($inv_details) ? $inv_details[0]['received_card_amount'] : 0;

            $total_vat_inv         = !empty($inv_details) ? $inv_details[0]['tax_vat_amount'] : 0;

            $gross_total_inv       = $inv_amount;

            $net_total_inv         = $inv_amount - $deduction_amount;


            // -----------credit-note----------------------------------


            $sql_cr = "SELECT 
                        SUM(item_net_amount) AS item_net_amount,
                        SUM(item_net_amount + item_tax_vat_amount) AS cr_total_amount,
                         sum(total_tax_amount) as total_tax_amount,
                        SUM(item_tax_vat_amount) AS item_tax_vat_amount,
                         sum(paid_card_amount) as paid_card_amount, 
                        warehouse_id,
                        credited_date
                    FROM view_commission_creditnote_report
                    WHERE credited_date = :selected_date AND warehouse_id = :warehouse_id
                    ";

            $command = Yii::app()->db->createCommand($sql_cr);
            $command->bindParam(":selected_date", $selected_date);
            $command->bindParam(":warehouse_id", $warehouse_id);
            $creditnote_list = $command->queryAll();

            $total_sales_return = !empty($creditnote_list) ? $creditnote_list[0]['cr_total_amount'] : 0;

            $drawer_amount_inv     = $total_cash_amount_inv + $opening_cash - $total_sales_return;

            $net_total_cr         = $total_sales_return;
            $total_vat_cr         = !empty($creditnote_list) ? $creditnote_list[0]['total_tax_amount'] : 0;
            //   ---  ------------------------------------


            ?>

            <!-- -------------- -->


            <table border="0" cellspacing="0" cellpadding="0" style="padding: 0px;">



                <table border="0" cellspacing="0" cellpadding="0" style="padding: 0px;">

                    <tbody style="font-size: 13px; border-top: 1px dashed;">
                        <tr style="line-height: 1.5;">
                            <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Date</th>

                            <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                                <?php echo date('d/m/Y', STRTOTIME($date)); ?>
                            </th>
                        </tr>
                        <!--=============== basic  ===============-->
                    <!--<tbody>-->
                    <!--    <tr>-->
                    <!--        <th class="padd_left" colspan="5" style="padding: 2px;"></th>-->
                    <!--    </tr>-->
                    <!--</tbody>-->
                    <!--=============== basic  ===============-->
                    <!--<tr style="line-height: 1.5;">-->
                    <!--    <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Branch</th>-->

                    <!--    <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;"><?php //echo Yii::app()->numberFormatter->formatCurrency($discount, " "); ?></th>-->
                    <!--</tr>-->
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">

                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Cash At Starting </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;"><?php echo Yii::app()->numberFormatter->formatCurrency($opening_cash, " "); ?></th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Cash Sale </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($total_cash_amount_inv, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Card Sale </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($total_card_amount_inv, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Payback/Sales Return </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($total_sales_return, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Expense </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency(0, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Total VAT </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($total_vat_inv - $total_vat_cr, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Amount in Cash Drawer </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($drawer_amount_inv, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Gross Total </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($gross_total_inv, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Discount </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($total_discount_inv, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    <tr style="line-height: 1.5;">
                        <th class="padd_left border-none" colspan="3" style="padding: 0px 5px;">Net Total </th>
                        <th class="padd_right border-none" colspan="2" style="padding: 0px 5px;">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($net_total_inv - $net_total_cr, " "); ?>
                        </th>
                    </tr>
                    <!--=============== basic  ===============-->
                    <tbody>
                        <tr>
                            <th class="padd_left" colspan="5" style="padding: 2px;"></th>
                        </tr>
                    </tbody>
                    <!--=============== basic  ===============-->
                    </tbody>
                </table>


                </tfoot>
            </table>
            <br>

            <a href="javascript:window.print()" class="print-button">Print </a>


            <a style="background:#c33612;" href="javascript:window.close()" class="print-button">Close </a>


    </div>
</body>

</html>