<div id="div_vehicle_report_filter">
    <?php

    $fin_month = Yii::app()->user->fin_year;

    $year = date('Y');
    $year_next = $year + 1;
    if ($fin_month == 1) {
        $from_date = $year . '-01-01';
        $end_date = $year . '-12-31';
    } else {
        $from_date = $year . '-04-01';
        $end_date = $year_next . '-03-31';
    }
    $startDate = date("d-m-Y", strtotime($from_date));

    $endDate = date("d-m-Y", strtotime($end_date));

    ?>
    <ul class="clearfix form-ul material" id="vehiclelist-form-hide">

        <!-- Scheduled From Date -->
        <!-- <li class="col-sm-3">
            <div class="material">
                <?php
                // echo CHtml::textField(
                //     'scheduled_from_date',
                //     '',
                //     array(
                //         'class' => 'form-control datepicker',
                //         'placeholder' => 'DD-MM-YYYY',
                //         'data-label' => 'Scheduled From Date',
                //         'id' => 'scheduled_from_date'
                //     )
                // );
                ?>
            </div>
        </li> -->
        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('sheduled_from_date', $startDate, array('class' => 'datepicker', 'data-label' => 'Scheduled From Date ')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('sheduled_to_date', $endDate, array('class' => 'datepicker', 'data-label' => 'Scheduled To Date ')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php
                echo CHtml::dropDownList(
                    'vehicle_model',   // name
                    '',                // selected value
                    CHtml::listData(
                        MasVehicle::model()->findAll(), // records
                        'id',             // value field
                        'vehicle_model'      // label field
                    ),
                    array(
                        'class' => 'tooltipster',
                        'data-label' => 'Vehicle Model',
                        'data-search' => 'true',
                        'empty' => '--Select--'
                    )
                );
                ?>
            </div>
        </li>

        <!-- Scheduled To Date -->
        <!-- <li class="col-sm-3">
            <div class="material">
                <?php
                // echo CHtml::textField(
                //     'scheduled_to_date',
                //     '',
                //     array(
                //         'class' => 'form-control datepicker',
                //         'placeholder' => 'DD-MM-YYYY',
                //         'data-label' => 'Scheduled To Date',
                //         'id' => 'scheduled_to_date'
                //     )
                // );
                ?>
            </div>
        </li> -->

    </ul>
</div>

<div class='btn-wrap text-center'>
    <button type="button" class="btn btn-theme" onclick="loadMasterReport();" title="HTML">
        <i class="fa fa-file-text"></i> &nbsp;HTML
    </button>
    <?php if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["fleet_vechicle_service_list_download"]) { ?>

        <button type="button" class="btn btn-theme" onclick="loadVehicleMaintainPDF();" title="Print Vehicle List">
            <i class="fa fa-file-pdf-o"></i> &nbsp;PDF
        </button>
        <button type="button" class="btn btn-theme" onclick="exportVehicleMaintainExcel();">
            <i class="fa fa-file-excel-o"></i> &nbsp;Excel
        </button>
    <?php } ?>
</div>

<?php
$cs = Yii::app()->getClientScript();
// PDF Export
$cs->registerScript("loadVehicleMaintainPDF", "function loadVehicleMaintainPDF(){                                       
    var vehicle_model = $('#vehicle_model').val();
    var sheduled_from_date = $('#sheduled_from_date').val();
    var sheduled_to_date   = $('#sheduled_to_date').val(); 

    window.open($('#liveSite').val()+'index.php?r=reports/VehicleMaintatinancePDF&vehicle_model='+vehicle_model+'&sheduled_from_date='+sheduled_from_date+'&sheduled_to_date='+sheduled_to_date, '_blank'); 
    return false;                
}", CClientScript::POS_HEAD);

// Excel Export
$cs->registerScript("exportVehicleMaintainExcel", "function exportVehicleMaintainExcel(){                                       
    var sheduled_from_date = $('#sheduled_from_date').val();
    var sheduled_to_date   = $('#sheduled_to_date').val(); 
    var vehicle_model = $('#vehicle_model').val(); 

    window.open($('#liveSite').val()+'index.php?r=reports/VehicleMaintatinanceExcel&vehicle_model='+vehicle_model+'&sheduled_from_date='+sheduled_from_date+'&sheduled_to_date='+sheduled_to_date, '_blank'); 
    return false;                
}", CClientScript::POS_HEAD);
?>