<div id="div_vehicle_allotment_filter">
    <?php
    // ✅ Default financial year date range
    $fin_month = Yii::app()->user->fin_year;
    $year = date('Y');
    $year_next = $year + 1;

    if ($fin_month == 1) {
        $from_date = $year . '-01-01';
        $end_date = $year . '-12-31';
    } else {
        $from_date = $year . '-04-01';
        $end_date = $year_next . '-03-31';
    }

    $startDate = date("d-m-Y", strtotime($from_date));
    $endDate = date("d-m-Y", strtotime($end_date));
    ?>

    <ul class="clearfix form-ul material" id="vehicleallotment-form-hide">
        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('from_date', $startDate, array(
                    'class' => 'datepicker',
                    'data-label' => 'From Date',
                )); ?>
            </div>
        </li>

        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('to_date', $endDate, array(
                    'class' => 'datepicker',
                    'data-label' => 'To Date',
                )); ?>
            </div>
        </li>

        <li class="col-sm-3">
            <div class="material">
                <?php
                echo CHtml::dropDownList(
                    'vehicle_id',
                    '',
                    MasVehicle::getVehicleMakeModelList(),
                    array(
                        'class' => 'tooltipster',
                        'data-label' => 'Vehicle',
                        'empty' => '--Select Vehicle--',
                        'data-search' => 'true'
                    )
                );
                ?>
            </div>
        </li>

        <li class="col-sm-3">
            <div class="material">
                <?php
                echo CHtml::dropDownList(
                    'employee_id',
                    '',
                    Employee::getEmployee(),
                    array(
                        'class' => 'tooltipster',
                        'data-label' => 'Employee Name',
                        'empty' => '--Select Employee--',
                        'data-search' => 'true'
                    )
                );
                ?>
            </div>
        </li>
    </ul>


</div>

<div class="btn-wrap text-center">
    <button type="button" class="btn btn-theme" onclick="loadMasterReport();" title="HTML">
        <i class="fa fa-file-text"></i> &nbsp;HTML
    </button>
    <?php if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["fleet_vechicle_allotment_download"]) { ?>

        <button type="button" class="btn btn-theme" onclick="exportVehicleAllotmentPDF();" title="PDF Report">
            <i class="fa fa-file-pdf-o"></i> &nbsp;PDF
        </button>
        <button type="button" class="btn btn-theme" onclick="exportVehicleAllotmentExcel();" title="Excel Report">
            <i class="fa fa-file-excel-o"></i> &nbsp;Excel
        </button>
    <?php } ?>
</div>

<div class="table-responsive">
    <div id="vehicle_allotment_result" style="display:none;">
        <!-- Results load here -->
    </div>
</div>

<?php
$cs = Yii::app()->getClientScript();

// PDF Export
$cs->registerScript("exportVehicleAllotmentPDF", "
function exportVehicleAllotmentPDF(){
    var from_date = $('#from_date').val();
    var to_date   = $('#to_date').val();
    var vehicle_id   = $('#vehicle_id').val();
    var employee_id  = $('#employee_id').val();

    window.open($('#liveSite').val()+'index.php?r=reports/VehicleAllotmentPDF&from_date='+from_date+'&to_date='+to_date+'&vehicle_id='+vehicle_id+'&employee_id='+employee_id, '_blank');
    return false;
}
", CClientScript::POS_END);

// Excel Export
$cs->registerScript("exportVehicleAllotmentExcel", "
function exportVehicleAllotmentExcel(){
    var from_date = $('#from_date').val();
    var to_date   = $('#to_date').val();
    var vehicle_id   = $('#vehicle_id').val();
    var employee_id  = $('#employee_id').val();

    window.open($('#liveSite').val()+'index.php?r=reports/VehicleAllotmentExcel&from_date='+from_date+'&to_date='+to_date+'&vehicle_id='+vehicle_id+'&employee_id='+employee_id, '_blank');
    return false;
}
", CClientScript::POS_END);
?>