<div id="div_master_report_invoicelist">
 <?php
    $fin_month = Yii::app()->user->fin_year;

    $year = date('Y');
    $year_next = $year + 1;
    if ($fin_month == 1) {
        $from_date = $year . '-01-01';
        $end_date = $year . '-12-31';
    } else {
        $from_date = $year . '-04-01';
        $end_date = $year_next . '-03-31';
    }
    $startDate = date("d-m-Y", strtotime($from_date));

    $endDate = date("d-m-Y");
    ?>

    <ul class="clearfix form-ul material" id="orderlist-form-hide">

        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::textField('sales_from_date', $startDate, array('class' => 'datepicker', 'data-label' => 'From Date')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::textField('sales_to_date', $endDate, array('class' => 'datepicker', 'data-label' => 'To Date')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::dropdownlist('brandid', '', MasInvBrand::getAllBrand(), array('class' => '', 'data-label' => 'Brand', 'empty' => 'All')); ?>
            </div>
        </li>

    </ul>
</div>
<div class='btn-wrap text-center'>
    <button type="button" class="btn btn-theme" onclick="loadMasterReport();return false;" title="HTML"><i
            class="fa fa-file-text"></i> &nbsp;HTML</button>
    <?php if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["sales_items_by_brand_download"]) { ?>

        <button type="button" class="btn btn-theme" onclick="excelsaleList();"><i class="fa fa-file-excel-o"></i>
            &nbsp;Excel</button>
    <?php } ?>


</div>
<?php $cs = Yii::app()->getClientScript();

$cs->registerScript("excelsaleList", "function excelsaleList(){

    var from_date = $('#sales_from_date').val();

    var to_date = $('#sales_to_date').val(); 

    var brandid = $('#brandid').val();
    window.open($('#liveSite').val()+'index.php?r=reports/PrintSaleBrandList&from_date='+from_date+'&to_date='+to_date+'&brandid='+brandid, '_blank');

}", CClientScript::POS_HEAD);
?>