<div id="div_master_report_orderlist">
	<?php
    $fin_month = Yii::app()->user->fin_year; 
    $year = date('Y');
    $year_next = $year + 1;
    if($fin_month == 1){
        $from_date = $year.'-01-01';
        $end_date = $year.'-12-31';
    }else{
        $from_date = $year.'-04-01';
        $end_date = $year_next.'-03-31';
    }
	$startDate = date("d-m-Y", strtotime($from_date));	 
	$endDate = date("d-m-Y", strtotime($end_date)); ?>
    <ul class="clearfix form-ul material" id="orderlist-form-hide"><br><br>
        <li class="col-sm-4">
            <div class="material">    
                <?php echo CHtml::textField('customer_name','',array('class' => 'tooltipster', 'placeholder' => 'Please choose a customer','data-label'=>'Customer','onKeyup' => 'js:autoCompleteCustomer(this.id,"lead");')); ?>
                <?php echo CHtml::hiddenField('customer_id'); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">    
                <?php echo CHtml::textField('from_date', $startDate,array('class' => 'datepicker','data-label'=>'Date From'));?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">    
                <?php echo CHtml::textField('to_date', $endDate ,array('class' => 'datepicker','data-label'=>'Date To'));?>
            </div>
        </li>
       <li class="col-sm-2">
            <div class="material">    
                 <?php echo CHtml::dropDownList('type', '',array( 1=> 'Machine' , 2 => 'Oil'),array('class' => 'tooltipster','data-label'=>'Type','empty'=>'All'));?>
            </div>
        </li>
        <?php /*<li class="col-sm-2 hidden">
            <div class="material">    
                <?php echo CHtml::dropDownList('status', '',array( 1=> 'Pending' , 2 => 'Partial'),array('class' => 'tooltipster','data-label'=>'Status','empty'=>'All'));?>
            </div>
        </li>*/?>
    </ul>
</div>
<div class='btn-wrap text-center'>
    <button type="button" class="btn btn-theme" onclick="if($('#customer_id').val()){loadMasterReport();return false;} else {t8.error('Please select a customer');return false;}" title="HTML"><i class="fa fa-file-text"></i> &nbsp;HTML</button>
    <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["report_machinelist_download"]))) { ?>
        <button type="button" class="btn btn-theme" onclick="printMachineListReportPDF();" title="Print Machine List'"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>
    <?php } ?> 
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm) {
    $('#ocustomer_id').val('');
	var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "'+'&frm='+frm;
	$('#'+field_id).autocomplete({
        minLength   : 1,
        source      : function (request, response) { autoCompleteSource(request, response,url) },
        focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
        select      : function( event, ui ) {
            event.preventDefault();
            //CustomerOutletLocation::getShippingLocation()
            trigger_target_id  	=   $(event.target).attr('id');
			var crm_user_id=ui.item.value; 	
            $('#customer_id').val(crm_user_id); 
		}
	})
}", CClientScript::POS_HEAD);
$cs->registerScript("printMachineListReportPDF", "function printMachineListReportPDF(){
    var from_date = $('#from_date').val();
    var to_date = $('#to_date').val();
    var customer_id = $('#customer_id').val();
    var outlet = $('#outlet').val();
    var status = $('#order_status').val();
    var type= $('#type').val();
    window.open($('#liveSite').val()+'index.php?r=reports/PrintMachineListReportPDF&from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&outlet='+outlet+'&status='+status+'&type='+type, '_blank');
}", CClientScript::POS_HEAD);