<div id="div_master_report_invoicelist">
    <?php

    $fin_month = Yii::app()->user->fin_year;

    $year = date('Y');
    $year_next = $year + 1;
    if ($fin_month == 1) {
        $from_date = $year . '-01-01';
        $end_date = $year . '-12-31';
    } else {
        $from_date = $year . '-04-01';
        $end_date = $year_next . '-03-31';
    }
    $startDate = date("d-m-Y", strtotime($from_date));

    $endDate = date("d-m-Y", strtotime($end_date));

    ?>
    <!--                    <h2 class="line-title">Employee List</h2>-->
    <ul class="clearfix form-ul material" id="orderlist-form-hide">
        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('grossprofit_customer_name', '', array('class' => 'tooltipster', 'placeholder' => 'Please choose a customer', 'data-label' => 'Customer', 'onKeyup' => 'js:autoCompletenetsalesCustomer(this.id,"netsales");')); ?>
                <?php echo CHtml::hiddenField('grossprofit_customer_id'); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php // echo CHtml::textField('grossprofit_sales_group','',array('class' => 'tooltipster', 'placeholder' => 'Please enter sales group','data-label'=>'Sales group')); ?>
                <?php echo CHtml::dropDownList('grossprofit_sales_group', 'grossprofit_sales_group', MasSalesGroup::getSalesGroups(), array('class' => 'tooltipster', 'data-label' => 'Sales group', 'data-search' => 'true', 'empty' => 'Select')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::dropDownList('grossprofit_leadowner_id', 'grossprofit_leadowner_id', User::getLeadOwners(), array('class' => 'tooltipster', 'data-label' => 'Lead Owner', 'data-search' => 'true', 'empty' => 'Select')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::textField('grossprofit_from_date', $startDate, array('class' => 'datepicker', 'data-label' => 'From Date')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::textField('grossprofit_to_date', $endDate, array('class' => 'datepicker', 'data-label' => 'To Date')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::dropDownList('grossprofit_invoicetype', 'grossprofit_invoicetype', MasInvoiceType::getInvoceType('sales'), array('class' => 'tooltipster', 'data-label' => 'Invoice Type', 'empty' => 'Select')); ?>
            </div>
        </li>



    </ul>
</div>
<div class='btn-wrap text-center'>
    <button type="button" class="btn btn-theme" onclick="loadMasterReport();return false;" title="HTML"><i
            class="fa fa-file-text"></i> &nbsp;HTML</button>
    <?php if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["report_sale_grossprofit_download"]) { ?>

        <button type="button" class="btn btn-theme" onclick="printGrossProfitPDF();" title="Print Credit List"><i
                class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>

        <button type="button" class="btn btn-theme" onclick="excelGrossProfit();"><i class="fa fa-file-excel-o"></i>
            &nbsp;Excel</button>

    </div>
<?php } ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompletenetsalesCustomer", "function autoCompletenetsalesCustomer(field_id,frm)

		{
//                alert(frm);
		var url = '" . Yii::app()->createUrl('customer/GetcustomerDetails') . "'+'&frm='+frm;

		$('#'+field_id).autocomplete({

                minLength   : 1,

                source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

				var crm_user_id=ui.item.value; 	
                                 $('#grossprofit_customer_id').val(crm_user_id)
             

			}

			})



		}", CClientScript::POS_HEAD);

$cs->registerScript("excelGrossProfit", "function excelGrossProfit(){

    var url= '" . Yii::app()->createUrl('reports/PrintGrossProfitReportExcel') . "';
   
var from_date =  $('#grossprofit_from_date').val();
var to_date =  $('#grossprofit_to_date').val();
var customer_id =  $('#grossprofit_customer_id').val();
var leadowner_id =  $('#grossprofit_leadowner_id').val();
var salesgroup =  $('#grossprofit_sales_group').val();
var inv_type =  $('#grossprofit_invoicetype').val();

var param = '&from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&leadowner_id='+leadowner_id+'&salesgroup='+salesgroup+'&inv_type='+inv_type;
    window.open($('#liveSite').val()+'index.php?r=reports/PrintGrossProfitReportExcel'+param, '_blank');

}", CClientScript::POS_HEAD);
$cs->registerScript("printGrossProfitPDF", "function printGrossProfitPDF(){

    var url= '" . Yii::app()->createUrl('reports/PrintGrossProfitReportPDF') . "';
   
var from_date =  $('#grossprofit_from_date').val();
var to_date =  $('#grossprofit_to_date').val();
var customer_id =  $('#grossprofit_customer_id').val();
var leadowner_id =  $('#grossprofit_leadowner_id').val();
var salesgroup =  $('#grossprofit_sales_group').val();
var inv_type =  $('#grossprofit_invoicetype').val();

var param = '&from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&leadowner_id='+leadowner_id+'&salesgroup='+salesgroup+'&inv_type='+inv_type;
    window.open($('#liveSite').val()+'index.php?r=reports/PrintGrossProfitReportPDF'+param, '_blank');

}", CClientScript::POS_HEAD);