<div id="div_master_report_invoicelist">
    <?php
    $fin_month = Yii::app()->user->fin_year;
    $year = date('Y');
    $year_next = $year + 1;
    if ($fin_month == 1) {
        $from_date = $year . '-01-01';
        $end_date = $year . '-12-31';
    } else {
        $from_date = $year . '-04-01';
        $end_date = $year_next . '-03-31';
    }
    $startDate = date("d-m-Y", strtotime($from_date));
    $endDate = date("d-m-Y", strtotime($end_date));
    ?>
    <!--                    <h2 class="line-title">Employee List</h2>-->
    <ul class="clearfix form-ul material" id="orderlist-form-hide">

        <li class="col-sm-4">
            <div class="material">
                <?php echo CHtml::textField('deltoinv_customer_name', '', array('class' => 'tooltipster', 'title' => 'Please choose a customer', 'placeholder' => 'Please choose a customer', 'data-label' => 'Customer', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"deltoinv");')); ?>
                <?php echo CHtml::hiddenField('deltoinv_customer_id'); ?>

            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php echo CHtml::dropDownList('deltoinv_country', '', MasCountry::getCountry(), array('class' => 'tooltipster', 'data-label' => 'Country', 'data-search' => true, 'empty' => 'Select')); ?>
            </div>
        </li>

        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('deltoinv_from_date', $startDate, array('class' => 'datepicker', 'data-label' => 'From Date ')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">
                <?php echo CHtml::textField('deltoinv_to_date', $endDate, array('class' => 'datepicker', 'data-label' => 'To Date ')); ?>
            </div>
        </li>
        <li class="col-sm-4">
            <div class="material">
                <?php echo CHtml::dropDownList('deltoinv_shipped_by', '', MasShipping::getShipping(), array('class' => 'tooltipster', 'data-label' => 'Shipped By', 'empty' => '--Select--')); ?>
            </div>
        </li>


    </ul>
</div>
<div class='btn-wrap text-center'>
    <button type="button" class="btn btn-theme" onclick="loadMasterReport();return false;" title="HTML"><i
            class="fa fa-file-text"></i> &nbsp;HTML</button>
    <?php if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["report_sale_delivertoinvoice_download"]) { ?>

        <button type="button" class="btn btn-theme" onclick="printDeliverytobeInvoicedpdf();" title="Print Lead List"><i
                class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>
        <button type="button" class="btn btn-theme" onclick="excelDeliverytoInvoiceList();"><i
                class="fa fa-file-excel-o"></i> &nbsp;Excel</button>
    <?php } ?>

</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id,frm)

		{
                $('#deltoinv_customer_id').val('');
//                alert(frm);
		var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "'+'&frm='+frm;

		$('#'+field_id).autocomplete({

                minLength   : 1,

                source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

			    var customer_id=ui.item.value; 	
                $('#deltoinv_customer_id').val(customer_id);
             

			}

			})



		}", CClientScript::POS_HEAD);

$cs->registerScript("excelDeliverytoInvoiceList", "function excelDeliverytoInvoiceList(){

        var url= '" . Yii::app()->createUrl('reports/PrintDeliverytoInvoiceList') . "';

        var from_date = $('#deltoinv_from_date').val();

        var to_date = $('#deltoinv_to_date').val(); 

        var customer_id = $('#deltoinv_customer_id').val();

        var shipped_by = $('#deltoinv_shipped_by').val(); 

        var country = $('#deltoinv_country').val();

        window.open($('#liveSite').val()+'index.php?r=reports/PrintDeliverytoInvoiceList&from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&shipped_by='+shipped_by+'&country='+country, '_blank');

    }", CClientScript::POS_HEAD);

$cs->registerScript("printDeliverytobeInvoicedpdf", "function printDeliverytobeInvoicedpdf(){

        var url= '" . Yii::app()->createUrl('reports/PrintDeliverytoInvoiceList') . "';

        var from_date = $('#deltoinv_from_date').val();

        var to_date = $('#deltoinv_to_date').val(); 

        var customer_id = $('#deltoinv_customer_id').val();

        var shipped_by = $('#deltoinv_shipped_by').val(); 

        var country = $('#deltoinv_country').val();

        window.open($('#liveSite').val()+'index.php?r=reports/PrintDeliverytobeInvoicedpdf&from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&shipped_by='+shipped_by+'&country='+country, '_blank');

    }", CClientScript::POS_HEAD);