<div>
    <?php
    $fin_month = Yii::app()->user->fin_year;

    $year = date('Y');
    $year_next = $year + 1;
    if ($fin_month == 1) {
        $from_date = $year . '-01-01';
        $end_date = $year . '-12-31';
    } else {
        $from_date = $year . '-04-01';
        $end_date = $year_next . '-03-31';
    }
    $startDate = date("d-m-Y", strtotime($from_date));

    $endDate = date("d-m-Y", strtotime($end_date));
    ?>
    <!--                    <h2 class="line-title">Employee List</h2>-->
    <ul class="clearfix form-ul material"> 
        <li class="col-sm-3">
            <div class="material">    
                <?php echo CHtml::textField('datewisesales_customer_name', '', array('class' => 'tooltipster', 'placeholder' => 'Please choose a customer', 'data-label' => 'Customer', 'onKeyup' => 'js:autoCompletedatewisesalesCustomer(this.id,"datewisesales");')); ?>
                <?php echo CHtml::hiddenField('datewisesales_customer_id'); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">    
                <?php echo CHtml::dropDownList('datewisesales_leadowner_id', 'datewisesales_leadowner_id', User::getLeadOwners(), array('class' => 'tooltipster', 'data-label' => 'Lead Owner', 'data-search' => 'true', 'empty' => 'Select')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">    
            <?php echo CHtml::textField('datewisesales_from_date', $startDate, array('class' => 'datepicker', 'data-label' => 'From Date')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">    
            <?php echo CHtml::textField('datewisesales_to_date', $endDate, array('class' => 'datepicker', 'data-label' => 'To Date')); ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">    
            <?php echo CHtml::dropDownList('datewisesales_invoicetype', 'datewisesales_invoicetype', MasInvoiceType::getInvoceType('sales'), array('class' => 'tooltipster', 'data-label' => 'Invoice Type', 'empty' => 'Select')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">    
            <?php echo CHtml::dropDownList('datewisesales_emirates_id', 'datewisesales_emirates_id',MasEmiratesList::getEmiratesList(), array('class' => 'tooltipster','data-label'=>'Taxable Category','empty'=>'Select')); ?>
            </div>
        </li> 
    </ul>
</div>
<div class='btn-wrap text-center'>
    
<button type="button" class="btn btn-theme" onclick="loadMasterReport();return false;" title="HTML"><i class="fa fa-file-text"></i> &nbsp;HTML</button>
  <button type="button" class="btn btn-theme" onclick="printDatewiseReportPDF();" title="Print Credit List"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</button>
<!--<button type="button" class="btn btn-theme" onclick="excelDatewisesaleList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>-->
                 
    
    
    
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompletedatewisesalesCustomer", "function autoCompletedatewisesalesCustomer(field_id,frm)		{
        $('#datewisesales_customer_id').val('');
		var url = '" . Yii::app()->createUrl('customer/GetcustomerDetails') . "'+'&frm='+frm;

		$('#'+field_id).autocomplete({

                minLength   : 1,

                source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

				var crm_user_id=ui.item.value; 	
                                 $('#datewisesales_customer_id').val(crm_user_id)
             

			}

			})



		}", CClientScript::POS_HEAD);
$cs->registerScript("printDatewiseReportPDF", "function printDatewiseReportPDF(){
    var from_date = $('#datewisesales_from_date').val();
    var to_date = $('#datewisesales_to_date').val();
    var customer_id = $('#datewisesales_customer_id').val();
    var leadowner_id = $('#datewisesales_leadowner_id').val();
    var inv_type = $('#datewisesales_invoicetype').val();
    var emirates_id = $('#datewisesales_emirates_id').val();
    var pars = 'from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&leadowner_id='+leadowner_id+'&report_from='+report_from+'&inv_type='+inv_type+'&emirates_id='+emirates_id;
    window.open($('#liveSite').val()+'index.php?r=reports/PrintDatewiseSalesReportPDF&'+pars, '_blank');
}", CClientScript::POS_HEAD);
$cs->registerScript("excelDatewisesaleList", "function excelDatewisesaleList(){
    var from_date = $('#datewisesales_from_date').val();
    var to_date = $('#datewisesales_to_date').val();
    var customer_id = $('#datewisesales_customer_id').val();
    var leadowner_id = $('#datewisesales_leadowner_id').val();
    var inv_type = $('#datewisesales_invoicetype').val();
    var emirates_id = $('#datewisesales_emirates_id').val();
    var pars = 'from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&leadowner_id='+leadowner_id+'&report_from='+report_from+'&inv_type='+inv_type+'&emirates_id='+emirates_id;
    window.open($('#liveSite').val()+'index.php?r=reports/PrintDatewiseSalesReportExcel&'+pars, '_blank');
}", CClientScript::POS_HEAD);