<html>
<head>
    <title>Vehicle Service / Maintenance Report</title>
    <style>
            table, th, td {
                border: 1px solid black;
                border-collapse: collapse;
            }
             td {
                padding: 5px;
                text-align: left;
            }
            th {
            text-align: center;
        }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        </style>
</head>
<body>

    <table style="width:100%">
        <thead>
            <tr>
                <th colspan="6">Vehicle Service / Maintenance Report</th>
            </tr>
            <?php if ($sheduled_from_date != '') { ?>
                <tr>
                    <td colspan="2"><b>Scheduled From :</b></td>
                    <td colspan="4"><?php echo $sheduled_from_date; ?></td>
                </tr>
            <?php } ?>
            <?php if ($sheduled_to_date != '') { ?>
                <tr>
                    <td colspan="2"><b>Scheduled To :</b></td>
                    <td colspan="4"><?php echo $sheduled_to_date; ?></td>
                </tr>
            <?php } ?>
            <?php 
            if (!empty($services) && $services[0]->vehicle) {
                $vehicleNameFilter = $services[0]->vehicle->vehicle_make . ' ' . $services[0]->vehicle->vehicle_model;
            ?>
                <tr>
                    <td colspan="2"><b>Vehicle :</b></td>
                    <td colspan="4"><?php echo $vehicleNameFilter; ?></td>
                </tr>
            <?php } ?>
        </thead>

        <thead>
            <tr>
                <th style="width:5%;">No</th>
                <th style="width:20%;">Scheduled Date/Time</th>
                <th style="width:20%;">Vehicle</th>
                <th style="width:20%;">Garage</th>
                <th style="width:20%;">Maintenance Type</th>
                <th style="width:15%;" class="text-right">Cost</th>
            </tr>
        </thead>

        <tbody>
            <?php
            // ================== CONDITION ==================
            $condition = "1=1";

            if (!empty($sheduled_from_date)) {
                $sheduled_from_date = date("Y-m-d", strtotime(str_replace('/', '-', $sheduled_from_date)));
                $condition .= " AND DATE(sheduled_date_time) >= '" . $sheduled_from_date . "'";
            }
            if (!empty($sheduled_to_date)) {
                $sheduled_to_date = date("Y-m-d", strtotime(str_replace('/', '-', $sheduled_to_date)));
                $condition .= " AND DATE(sheduled_date_time) <= '" . $sheduled_to_date . "'";
            }
            if ($vehicle_model != '') {
                $condition .= " AND vehicle_name='" . $vehicle_model . "'";
            }

            $services = MasMaintainanceService::model()->findAll([
                'condition' => $condition,
                'order' => 'sheduled_date_time ASC'
            ]);
            // ================================================

            $grandTotal = 0;
            $count = 1;

            if (!empty($services)) {
                foreach ($services as $service) {
                    $vehicleType = '';
                    if ($service->vehicle) {
                        $vehicleType = $service->vehicle->vehicle_make . ' ' . $service->vehicle->vehicle_model;
                    }

                    $details = ServiceDetails::model()->findAllByAttributes(['service_id' => $service->id]);

                    if (!empty($details)) {
                        foreach ($details as $detail) {
                            $maintType = MasMaintainance::model()->findByPk($detail->maintainance_master_id);
                            $typeName = $maintType ? $maintType->maintainance_type : '--';
                            $grandTotal += (float)$detail->service_cost;
            ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td><?php echo date('d/m/Y', strtotime($service->sheduled_date_time)); ?></td>
                                <td><?php echo $vehicleType; ?></td>
                                <td><?php echo $service->garage_name; ?></td>
                                <td><?php echo $typeName; ?></td>
                                <td class="text-right"><?php echo number_format((float)$detail->service_cost, 2, '.', ''); ?></td>
                            </tr>
            <?php
                        }
                    }
                }
            } else { ?>
                <tr>
                    <td colspan="6" class="text-center"><b>No Service Details Found</b></td>
                </tr>
            <?php } ?>
        </tbody>

        <?php if ($grandTotal > 0) { ?>
        <tfoot>
            <tr>
                <td colspan="5" class="text-right"><b>Total Cost:</b></td>
                <td class="text-right"><b><?php echo number_format($grandTotal, 2, '.', ''); ?></b></td>
            </tr>
        </tfoot>
        <?php } ?>
    </table>

</body>
</html>
