<html>
<head>
    <title>Purchase Enquiry List</title>
    <style>
            table, th, td {
                border: 1px solid black;
                border-collapse: collapse;
            }
             td {
                padding: 5px;
                text-align: left;
            }
            th {
            text-align: center;
        }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        </style>
</head>
<body>
    <table style="width:100%">
        <thead>
             <tr>
                <th colspan="5" style="border:0; text-align:center;">Purchase Enquiry List</th>
            </tr>
            <?php if ($fromdate != '') { ?>
            <tr style="border:0;">
                <td colspan="1" style="border:0;"><b> From Date :</b></td>
                <td colspan="1" style="border:0;"><?php echo $fromdate; ?></td>
            </tr>
            <?php } ?>
            <?php if ($todate != '') { ?>
            <tr style="border:0;">
                <td colspan="1" style="border:0;"><b>To Date :</b></td>
                <td colspan="1" style="border:0;"><?php echo $todate; ?></td>
            </tr>
            <?php } ?>
            <tr style="border:0;"></tr>
        </thead>
        <table border="1" style="width:100%; border-collapse:collapse;">

            <colgroup>
                <col style="width:5%">
                <col style="width:10%">
                <col style="width:15%">
                <col style="width:15%">
                <col style="width:55%">
            </colgroup>
        <thead>
                        <tr>
                        <th>No</th>
                        <th>Enquiry ID</th>
                        <th>Enquiry Date</th>
                        <th>Required Date</th>
                        <th>Suppliers</th>
                        </tr>
                    </thead>

        <tbody>
                    <?php
                    // Build condition
                    $condition = '1=1';

                    if (!empty($fromdate) && !empty($todate)) {
                        $fromdate = date('Y-m-d', strtotime(str_replace('/', '-', $fromdate)));
                        $todate   = date('Y-m-d', strtotime(str_replace('/', '-', $todate)));
                        $condition .= ' AND t.enquiry_date BETWEEN "' . $fromdate . '" AND "' . $todate . '"';
                    }

                    // Fetch data
                    $model_order = PurchasingEnquiry::model()->findAll(array(
                        'condition' => $condition,
                        'order' => 't.id DESC'
                    ));

                    if (!empty($model_order)) {

                        foreach ($model_order as $i => $row) {
                    ?>
                            <tr>
                                <td><?php echo $i + 1; ?></td>

                                <td><?php echo $row->id; ?></td>

                                <td>
                                    <?php
                                    if ($row->enquiry_date != '0000-00-00' && $row->enquiry_date != '') {
                                        echo date("d/m/Y", strtotime($row->enquiry_date));
                                    } else {
                                        echo "&nbsp;";
                                    }
                                    ?>
                                </td>

                                <td>
                                    <?php
                                    if ($row->required_date != '0000-00-00' && $row->required_date != '') {
                                        echo date("d/m/Y", strtotime($row->required_date));
                                    } else {
                                        echo "&nbsp;";
                                    }
                                    ?>
                                </td>

                                <td>
                                    <?php
                                    $vendor_ids = $row->vendor_id;

                                    if (strpos($vendor_ids, ',') !== false) {
                                        $ids = array_map('trim', explode(',', $vendor_ids));
                                    } else {
                                        $ids = [trim($vendor_ids)];
                                    }

                                    $names = [];
                                    foreach ($ids as $id) {
                                        if ($id != "") {
                                            $names[] = Vendor::getVendorName($id);
                                        }
                                    }

                                    echo implode(", ", $names);
                                    ?>
                                </td>

                            </tr>
                        <?php
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="10">No Data Found</td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
    </table>
</body>
</html>
