<html>

<head>
    <title>Item Wise Detailed Good Issue List</title>
    <style>
        table,
        th,
        td {
            border: 1px solid black;
        }
    </style>

</head>


<body>
    <table style="width:100%">
        <thead>
            <tr>
                <th colspan="11">Item Wise Detailed Good Issue List</th>
            </tr>
            <tr>
                <th>No</th>
                <th>Issue #</th>
                <th>Issue Date</th>
                <th>Product</th>
                <th>Description</th>
                <th>Warehouse</th>
                <th>Unit</th>
                <th>Picked Qty</th>
                <th>Rate</th>
                <th>Value</th>
                <th>Reference</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $condition = 't.picked_qty!=0';
            
             
                     if ($sort_id == 'issue_id') { // issue # //inventory_goods_receipt_id
                        $orderby = 't.inventory_goods_issue_id ASC';
                        } else   if ($sort_id == 'issue_date') { // Issue Date
                        $orderby = 'inventorygoodsissue.goods_issue_date ASC';
                        } else   if ($sort_id == 'product') { //Product
                            $orderby = 't.product_name ASC';
                        } else { // nill
                            $orderby = 't.id DESC';
                        }
                        

            if ($issue_from_date != '') {
                $issue_from_date = str_replace('/', '-', $issue_from_date);
                $issue_from_date = date('Y-m-d', strtotime($issue_from_date));
                $condition .= ' AND inventorygoodsissue.goods_issue_date >="' . $issue_from_date . '"';
            }
            if ($issue_to_date != '') {
                $issue_to_date = str_replace('/', '-', $issue_to_date);
                $issue_to_date = date('Y-m-d', strtotime($issue_to_date));
                $condition .= ' AND inventorygoodsissue.goods_issue_date <="' . $issue_to_date . '"';
            }

            if ($customer_id != '') {
                $condition .= ' AND inventorygoodsissue.customer_id ="' . $customer_id . '"';
            }

            if ($goodissue_id != '') {
                $condition .= ' AND inventorygoodsissue.id ="' . $goodissue_id . '"';
            }


            if ((int)$warehouse_id > 0) {
                $condition .= " AND inventorygoodsissue.warehouse_id = " . $warehouse_id;
            }

            if ($issue_type != '') {
                $condition .= ' AND inventorygoodsissue.issue_type ="' . $issue_type . '"';
            }
                    $model_goodissue = InventoryGoodsIssueItem::model()->with('inventorygoodsissue')->findAll(array('select' => 'product_id ,inventory_goods_issue_id,picked_qty as picked_qty,product_name,description,unit', 'condition' => $condition,'order' => $orderby));
            $total_free_quantity = $total_qty = $total_value = $total_cost_amount = 0;
            foreach ($model_goodissue as $i => $model) {
                $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $model->product_id . '"'));
                $total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $model->product_id . '"'));
                $free_quantity = $total_available_product->quantity - $total_allocated_product->quantity;

                $cost_amount = Yii::app()->db->createCommand("select IFNULL(cost_price,0)   from erp_stock_ledger where transaction_from='GOODS_ISSUE' AND product_id='" . $model->product_id . "'  AND (header_id ='" . $model->inventory_goods_issue_id . "') AND (header_item_id ='" . $model->id . "') ")->queryScalar();
            ?>
                <tr>
                    <td>
                        <?php echo ($i + 1); ?>
                    </td>
                    <td class="nw"> <?php echo $model->inventory_goods_issue_id; ?></td>
                    <td class="nw"> <?php echo date('d/m/Y', strtotime($model->inventorygoodsissue->goods_issue_date)); ?></td>
                    <td class="nw"> <?php echo $model->product_name; ?></td>
                    <td class="nw"> <?php echo $model->description; ?></td>
                    <td class="nw"> <?php echo $model->inventorygoodsissue->warehouse_det->warehouse_name; ?></td>

                    <td class="nw">
                        <?php echo $model->uom->name; ?>
                    </td>

                    <td class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($model->picked_qty, "");
                        $total_qty += $model->picked_qty;
                        ?>
                    </td>

                    <td class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($cost_amount, "");
                        ?>
                    </td>

                    <td class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($model->picked_qty * $cost_amount, "");
                        $total_value += $model->picked_qty * $cost_amount;
                        ?>
                    </td>
                    <td class="nw">
                        <?php echo $model->inventorygoodsissue->reference; ?>
                    </td>

                </tr>
            <?php
            }
            ?>
        </tbody>
        <tr>
            <td class="text-right" colspan="7"><b>Total</b></td>
            <td class="text-right"> <?php echo   Yii::app()->numberFormatter->formatCurrency($total_qty, ""); ?> </td>
            <td class="text-right"> </td>
            <td class="text-right"> <?php echo   Yii::app()->numberFormatter->formatCurrency($total_value, ""); ?> </td>
            <td></td>
        </tr>

    </table>

    <br />



    </table>
</body>

</html>