<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            /* font-size: 13px; */
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
        }
        th {
            font-weight: bold;
            text-align: center;
        }
        .right { text-align: right; }
        .center { text-align: center; }
        /* .bold { font-weight: bold; } */
        .noframe td { border: 0 !important; }
    </style>
</head>
<body>

<table class="noframe">
    <tr>
        <th colspan="9" style="border:0; text-align:center;">
            Inventory List
        </th>
    </tr>
</table>

<!-- FILTERS TABLE -->
<table class="noframe" style="margin-bottom: 10px;">
    <tr>
        <td style="width:40%"><b>Brand : </b></td>
        <td>
            <?php
            if ($brand_id > 0) {
                $b = MasInvBrand::model()->findByPk($brand_id);
                echo $b ? $b->brand_name : "";
            } else {
                echo "All Brands";
            }
            ?>
        </td>
    </tr>

    <tr>
        <td><b>Category :</b></td>
        <td>
            <?php
            if ($generic_id > 0) {
                $g = MasGeneric::model()->findByPk($generic_id);
                echo $g ? $g->generic_name : "";
            } else {
                echo "All Categories";
            }
            ?>
        </td>
    </tr>

    <tr>
        <td><b>Warehouse :</b></td>
        <td>
            <?php
            if ($warehouse_id > 0) {
                $w = MasInventoryWarehouse::model()->findByPk($warehouse_id);
                echo $w ? $w->warehouse_name : "";
            } else {
                echo "All Warehouse";
            }
            ?>
        </td>
    </tr>

    <tr>
        <td><b>Display Type :</b></td>
        <td>
            <?php
            if ($display_type == 1) {
                echo "Having Stock";
            } elseif ($display_type == 2) {
                echo "All Items";
            } else {
                echo "All Items";
            }
            ?>
        </td>
    </tr>
    <tr></tr>
</table>

<table>
    <thead>
        <tr>
            <th>No</th>
            <th>Part No</th>
            <th>Description</th>
            <th>Category</th>
            <th>Brand</th>
            <th>Item Type</th>
            <th>Qty</th>
            <th>Cost</th>
            <th>Value</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $m = 1;
        $type_array = MasInventoryItemType::getAll();
        $company = new MasCompany();
        $decimal_point = $company->no_of_decimals_rate;

        foreach ($model as $row):
            $generic = MasGeneric::model()->findByPk($row['generic_id']);
            $generic_name = $generic ? $generic->generic_name : '';
        ?>
        <tr>
            <td><?= $m ?></td>
            <td><?= $row['part_number'] ?></td>
            <td><?= $row['description'] ?></td>
            <td><?= $generic_name ?></td>
            <td><?= $row['brand'] ?></td>
            <td><?= $type_array[$row['inventory_item_type']] ?></td>
            <td class="right"><?= $row['quantity'] ?></td>
            <td class="right"style="mso-number-format:'\@';"><?= number_format($row['rate'], $decimal_point, '.', ',') ?></td>
            <td class="right"style="mso-number-format:'\@';"><?= number_format($row['amount'], $decimal_point, '.', ',') ?></td>
        </tr>
        <?php $m++; endforeach; ?>
    </tbody>

    <tfoot>
        <tr>
             <td colspan="6" class="text-right" style="font-weight:bold; text-align:right; mso-number-format:'\@';"> Total </td>
            <td class="text-right" style="font-weight:bold; text-align:right;mso-number-format:'\@';"><?= number_format($total['total_qty']) ?></td>
            <td></td>
            <td class="text-right" style="font-weight:bold; text-align:right;mso-number-format:'\@';"><?= number_format($total['total_val'], $decimal_point, '.', ',') ?></td>
        </tr>
    </tfoot>
</table>

</body>
</html>
