<?php
$cs = Yii::app()->getClientScript();
$goods_receipt_date = date("d/m/Y");
$con = "";
if ($model->id > 0) {
    $goods_receipt_date = date("d/m/Y", strtotime($model->goods_receipt_date));
    $con = "'readonly'";
}
$crm_login_company_id = Yii::app()->user->master_user_company_id;
$privillage_modal = new MasCompanySettings();
$privillage_condition = 'crm_company_id=' . $crm_login_company_id;

?>

<ul class="clearfix form-ul material">
    <?php echo $form->hiddenField($model, 'id'); ?>
    <?php echo $form->hiddenField($model, 'customer_id'); ?>
    <li class="col-sm-4">
        <?php echo $form->textField($model, 'goods_receipt_date', array('class' => 'datepicker', 'value' => $goods_receipt_date, 'data-label' => 'Goods Receipt Date <span style="color:red;">*<span> ')); ?>
    </li>
    <?php if ($frm == 'PR') {
        ?>
        <li class="col-sm-2">
            <?php
            echo $form->textField($model, 'reference_id', array('class' => 'tooltipster', 'data-label' => 'PO# <span style="color:red;">*<span> ', 'onKeyup' => 'js:autoCompleteOrderId(this.id,"gi");'));
            ?>
        </li>
        <li class="col-sm-2">
            <?php echo $form->textField($model, 'reference', array('class' => 'tooltipster', 'data-label' => 'Reference <span style="color:red;">*<span> ', 'readonly' => $con)); ?>
        </li>
        <?php
    } else {
        ?>
        <li class="col-sm-2">
            <?php
            echo $form->textField($model, 'reference_id', array('class' => 'tooltipster', 'data-label' => 'PO# <span style="color:red;">*<span> ', 'onKeyup' => 'js:autoCompleteOrderId(this.id,"gi");'));
            ?>
        </li>
        <li class="col-sm-2">
            <?php
            echo $form->textField($model, 'reference', array('class' => 'tooltipster', 'data-label' => 'Reference <span style="color:red;">*<span> ', 'readonly' => $con));
            // echo $form->hiddenField($model, 'reference_id');
            ?>
        </li>
        <?php
    }
    ?>

    <?php if ((int) Yii::app()->user->haveLevelPermissionOn['master_level_permission_warehouses'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
        <li class="col-sm-4">
            <?php
            if (empty($model->warehouse_id)) {
                $model->warehouse_id = MasInventoryWarehouse::base_warehouse_id();
            }
            ?>
            <?php echo $form->dropDownList($model, 'warehouse_id', MasInventoryWarehouse::getWarehouses(), array('data-label' => 'Warehouse <span style="color:red;">*<span>', 'empty' => '-Select-')); ?>
        </li>
    <?php } else {
        $model->warehouse_id = MasInventoryWarehouse::base_warehouse_id();
        echo $form->hiddenField($model, 'warehouse_id');
    }
    ?>

    <li class="col-sm-4">
        <?php echo $form->textField($model, 'customer_name', array('class' => 'tooltipster', 'value' => $model->customer->customer_name, 'data-label' => 'Customer', 'onKeyup' => 'js:autoCompleteCustomer(this.id,"issue");')); ?>
        <?php echo $form->error($model, 'customer_name'); ?>

    </li>

    <?php if (isset(Yii::app()->user->fm_module) && Yii::app()->user->fm_module == 'Y') { ?>

        <li class="col-sm-2">
            <?php
            $modelTicketHeader = new TicketHeader();
            echo $form->dropDownList($model, 'ticket_id', $modelTicketHeader->GetJoblist(), array('class' => '', 'prompt' => '--Select--', 'title' => 'Select Job', 'data-label' => 'Job Order No')); ?>
        </li>
    <?php } ?>


    <?php if (isset(Yii::app()->user->project_module) && Yii::app()->user->project_module == 'Y') { ?>
        <li class="col-sm-2">
            <?php

            $modelProject = new WsProject;
            echo $form->dropDownList($model, 'project_id', array(), array('class' => '', 'data-label' => 'Project ', 'empty' => '-Select-'));

            ?>
        </li>
    <?php } ?>
     <li class="col-sm-2">
     <?php

        if ($frm == 'PRO') {

            $model->receipt_type = 'PR';

            $modelMasInventoryStockAdjustmentType = new MasInventoryStockAdjustmentType;

            echo $form->dropDownList($model, 'receipt_type', $modelMasInventoryStockAdjustmentType->getInventoryStockAdjustmentType_code_issue(), array('data-label' => 'Receipt Type', 'disabled' => true));

            echo $form->hiddenField($model, 'receipt_type');

        } else {

            $modelMasInventoryStockAdjustmentType = new MasInventoryStockAdjustmentType;

            echo $form->dropDownList($model, 'receipt_type', $modelMasInventoryStockAdjustmentType->getInventoryStockAdjustmentType_code_issue(), array('data-label' => 'Receipt Type'));

        }

        ?>

   </li>
    

</ul>
<?php
$cs = Yii::app()->getClientScript();



$cs->registerScript("autoCompleteOrderId", "function autoCompleteOrderId(field_id,frm)

    {

        var url = '" . Yii::app()->createUrl('assembly/production/GetProductionOrders') . "'+'&frm='+frm;

        $('#'+field_id).autocomplete({



            minLength   : 1,



            source      : function (request, response) { autoCompleteSource(request, response,url) },

            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

            select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

                var order_id=ui.item.value; 	

                $('#InventoryGoodsReceipt_reference').addClass('filled');
                        
                $('#InventoryGoodsReceipt_customer_name').addClass('filled');

                $('#InventoryGoodsReceipt_reference_id').val(order_id);
                
                var warehouse_id = $('#InventoryGoodsIssue_warehouse_id').val();

                jQuery.ajax({

                    'type': 'POST',

                    'dataType': 'json',

                    'url': '" . Yii::app()->createUrl('assembly/production/GetPODetailsForGoodsReceipt') . "',

                    'data': {'order_id': order_id,'warehouse_id':warehouse_id},

                    'cache': false,

                    'beforeSend': function() {

                        

                    },

                    'success': function(data) {


                        $('#InventoryGoodsReceipt_customer_id').val(data.customer_id);
                        $('#InventoryGoodsReceipt_customer_name').val(data.customer_name);
                        
                        


                        $('#InventoryGoodsReceipt_reference').val(data.reference);


                        if(data.model_items!='')

                        $('#tbody_goods_receipt_item').html(data.model_items);

                        //calculateValues($('#tbl_gr_item'));

                    },

                }); 

                

            }

        })

    }", CClientScript::POS_HEAD);
