<?php

if($type == 'C'){
    $prefix = "service_contract";
}else if( $type == "T"){
    $prefix = "service_trial";
}else{
     $prefix = "quotes";
}

$currentYear = date('Y');
$currentMonth = date('m');

if ($frm == 3) {
    $con = "t.qtn_type = 'service'";
    if ($type == "C" || $type == "T") {
        $sales_group_id = MasSalesGroup::getDefaultServiceGroupId($type);
        if ($sales_group_id > 0) {
            $con .= " AND t.sales_group_id = {$sales_group_id}";
        }
    }
} else {
    $con = "t.qtn_type != 'service'";
}

// ✅ Pass the condition string directly
$totalQuotes = Quotes::model()->count($con);

if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {

    $criteria = new CDbCriteria();

    if ($frm == 3) {
        // Service-related condition
        $criteria->condition = 't.qtn_type = "service"';

        if ($type == "C" || $type == "T") {
            $sales_group_id = MasSalesGroup::getDefaultServiceGroupId($type);
            if ($sales_group_id > 0) {
                $criteria->addCondition('t.sales_group_id = :sales_group_id');
                $criteria->params[':sales_group_id'] = $sales_group_id;
            }
        }

        // Restrict to current user as owner if needed
        $criteria->addCondition('t.lead_owner_id = :owner');
        $criteria->params[':owner'] = Yii::app()->user->id;

    } else {
        // Non-service condition
        $criteria->condition = 't.qtn_type != "service"';
        $criteria->addCondition('t.lead_owner_id = :owner');
        $criteria->params[':owner'] = Yii::app()->user->id;
    }

    $totalQuotes = Quotes::model()->count($criteria);
}




$addedThisYear = Quotes::model()->count('YEAR(qtn_start_date) = :year', array(':year' => $currentYear));
$addedThisMonth = Quotes::model()->count('YEAR(qtn_start_date) = :year AND MONTH(qtn_start_date) = :month', array(':year' => $currentYear, ':month' => $currentMonth));

if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
    $criteriaYear = new CDbCriteria();
    $criteriaYear->condition = 'lead_owner_id = :owner AND YEAR(qtn_start_date) = :year';
    $criteriaYear->params = array(':owner' => Yii::app()->user->id, ':year' => $currentYear);
    $addedThisYear = Quotes::model()->count($criteriaYear);

    $criteriaMonth = new CDbCriteria();
    $criteriaMonth->condition = 'lead_owner_id = :owner AND YEAR(qtn_start_date) = :year AND MONTH(qtn_start_date) = :month';
    $criteriaMonth->params = array(':owner' => Yii::app()->user->id, ':year' => $currentYear, ':month' => $currentMonth);
    $addedThisMonth = Quotes::model()->count($criteriaMonth);
}

?>
<?php
$totalQuotesAmount = 0;

$allQuotes = Quotes::model()->findAll(['condition'=>$con]);

if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
    $criteria = new CDbCriteria();

    // Always restrict to owner
    $criteria->condition = 't.lead_owner_id = :owner';
    $criteria->params[':owner'] = Yii::app()->user->id;

    if ($frm == 3) {
        // Service quotes
        $criteria->addCondition('t.qtn_type = "service"');

        if ($type == "C" || $type == "T") {
            $sales_group_id = MasSalesGroup::getDefaultServiceGroupId($type);
            if ($sales_group_id > 0) {
                $criteria->addCondition('t.sales_group_id = :sales_group_id');
                $criteria->params[':sales_group_id'] = $sales_group_id;
            }
        }
    } else {
        // Non-service quotes
        $criteria->addCondition('t.qtn_type != "service"');
    }

    $allQuotes = Quotes::model()->findAll($criteria);
}

foreach ($allQuotes as $row) {
    $totalQuotesAmount += (float)$row->grand_total * (float)$row->exchange_rate;
}
?>
<?php
$color = array();
$colorname = array();
$modelcolor = MasColourScheme::model()->findAll();
foreach ($modelcolor as $evalue) {
    $color[$evalue->id] = $evalue->colour;
    $colorname[$evalue->id] = $evalue->field;
}
$modelCompanySettings = new MasCompanySettings();
$modelCompanySettings = $modelCompanySettings->find(array('condition'=>'crm_company_id='.(int) Yii::app()->user->master_user_company_id));  

///////////////////////////////////////////////////////////
$print_standard = $print_with_discount = $print_wo_discount = $print_with_desc = $print_wo_part = $print_image_desc = $print_with_all  = 0;
$ModelCompany = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
$print_permission_array = array();
   if (!empty($ModelCompany->print_permissions)) {
        $print_permission_array = CJSON::decode($ModelCompany->print_permissions);
        $formatted_array = array_map(function ($num) {
            return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
        }, $print_permission_array);
    }
    if($print_permission_array['print_standard']==1)
        $print_standard = 1;

    if($print_permission_array['print_with_discount']==1)
        $print_with_discount = 1;

    if($print_permission_array['print_wo_discount']==1)
        $print_wo_discount = 1;

    if($print_permission_array['print_with_desc']==1)
        $print_with_desc = 1;

    if($print_permission_array['print_wo_part']==1)
        $print_wo_part = 1;

    if($print_permission_array['print_image_desc']==1)
        $print_image_desc = 1;

    if($print_permission_array['print_with_all']==1)
        $print_with_all = 1;

//////////////////////////////////////////////////////////////
$cs = Yii::app()->getClientScript();

$cs->registerScript("check_convert", "function check_convert(id){ 

    if(id == 'Q')
    {

    }else{

        alert('You have no privilege to convert this Order again..');

        $('.order-save-btn').hide();

    }

 }", CClientScript::POS_HEAD);
$cs->registerScript("sendQtnMail", "function sendQtnMail(){
    jQuery.ajax({
        'type': 'post',
        'dataType': 'json',
        'url': '" . Yii::app()->createUrl('quotation/SendQuotationConversionMail') . "',
        'cache': false,
        'success': function(data) {
            t8.success('Mail Send Successfully');
        }
    });
 }", CClientScript::POS_HEAD);
?>

<script>
    $(document).ready(function() {
    table_id = "#tble_quotations";
    var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
    data.project_classification_id = $("#quotes_project_classification_id").val();
    data.date_from = $("#quotes_date_from").val();
    data.date_to = $("#quotes_date_to").val();
    data.status = $("#quotes_status").val();
    data.frm = $("#frm").val();
    return data;
    }).DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            columns: [{
            className: ""
            },
            {
            className: ""
            },
            {
            className: "nw sl col-max-7"
            },
            {
            className: ""
            },
            {
            className: ""
            },
            {
            className: ""
            },
            {
            className: ""
            },
            {
            className: "text-right"
            },
            {
            className: "text-right"
            },
            {
            className: "text-right"
            },
            {
            className: ""
            },
            {
            className: ""
            },
           
            ],
            order: [
            [0, "desc"]
            ],
            columnDefs: [{
            "targets": [11],
                    "visible": false,
            },
            {
            "bSortable": false,
                    "aTargets": []
            },
            ],
            ajax: {
            url: "<?php echo Yii::app()->createUrl('quotation/getquotationslist') ?>",
                    data: {
                    "frm": <?php echo $frm; ?>,
                     "type": "<?php echo $type; ?>"
                    },
                    type: "POST",
                    cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "rowCallback": function(row, data) {
            if (data[11].state == "1") {
            $("td", row).css("background-color", "<?php echo $color[10]; ?>"); //expired
            //$("td", row).css("background-color", "#c8c8c8");
            // $("td", row).css("text-decoration", "line-through");
            } else if (data[11].state == "2") {
            $("td", row).css("background-color", "<?php echo $color[8]; ?>"); //unapproved

            } else {
            $("td", row).css("background-color", "<?php echo $color[9]; ?>"); //approved
            }
            },
            /*"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){

             } */
    });
    $('#tble_quotations tbody').on('mouseover', 'tr', function() {
    $.contextMenu('destroy');
    });
    $('#tble_quotations tbody').on('click', 'tr', function() {
    //$.contextMenu( 'destroy' );
    var data = table.row(this).data();
    //$('#tble_quotations tbody tr').addClass("context-menu");
    var is_approved = data[11].is_approved;
    var checked_count = data[11].checked_count;
    var current_process = data[11].current_process_status;
    var sales_group_id=data[12];
    "<?php echo $variabledata = null; ?>"
            if (current_process == 'Q') {
    "<?php echo $variabledata = 'Q'; ?>"
    }

    var is_approved_status = data[11].is_approved;
    var currentApproveLevel = data[11].currentApproveLevel;
    var accessApproveLevel = data[11].accessApproveLevel;
    $.contextMenu({
    selector: '.context-menu',
            callback: function(key, options) {
            var action_id = key;
            var data = table.row(this).data();
            console.log(data);
            var file_id = data[0];
            var frm =  <?php echo $frm; ?>;
            var id = data[1];
            var customer_name = data[2];
            var current_process_status = data[11].current_process_status;
            //alert(current_process_status);
            var is_approved = data[11].is_approved;
            var print_standard = <?php echo $print_standard; ?>;
            //alert(is_approved);
            var customer_id = data[11].customer_id;
            var checked_count = data[11].checked_count;
            var sales_group_id=data[12];
            if (action_id == "edit" && current_process_status == 'Q') {
            loadPopupModal("quotation/create&frm=" + frm + "&id=" + id + "&file_id=" + file_id, "Edit Quotation - " + file_id + "/" + id + "/" + customer_name, "xl");
            } 
            //else if (action_id == "view" && current_process_status != 'Q') {
            else if (action_id == "view") {
            loadPopupModal("quotation/create&frm=" + frm + "&id=" + id + "&file_id=" + file_id + '&type=view', "View Quotation - " + file_id + "/" + id + "/" + customer_name, "xl");
            } else if (action_id == "convert" && current_process_status == 'Q' && is_approved == 'Y') {
            if (checked_count > 0) {
            var url = "order/create&frm=" + frm + "&quote_id=" + id + "&file_id=" + file_id + "&q_id=" + id;
            //            var dataParam = {
            //            file_id:file_id,
            //                    quote_id:id,
            //            };
            //            url = "order/create&" + encodeURIComponent($.param(dataParam));
            loadPopupModal(url, "Convert to Order-" + file_id + "/" + id + "/" + customer_name, "xl");
            } else {
            t8.error("None of the Quotation items are selected for Order");
            }
            } else if (action_id == "copy") {
            loadPopupModal('quotation/create&frm=' + frm + '&id=' + id + '&duplicate=1', 'Copy Quotation', 'xl');
            }
            else if (action_id == "analysis") {
            loadPopupModal('quotation/analysis&frm=' + frm + '&id=' + id, 'Analyze - '+ id + "/" +customer_name,"xl");
            } else if (action_id == "printpreview") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&type=2&preview=Y&id=" + id, "_blank")
            } else if (action_id == "print") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&type=1&id=" + id, "_blank")
            }
            else if (action_id == "print1") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDFNew&print_type=1&type=1&id=" + id, "_blank")
            }
             else if (action_id == "print2") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDFNew&print_type=2&type=1&id=" + id, "_blank")
            }
             else if (action_id == "print3") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDFNew&print_type=3&type=1&id=" + id, "_blank")
            }
             else if (action_id == "print4") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDFNew&print_type=4&type=1&id=" + id, "_blank")
            }
             else if (action_id == "print5") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&print_type=5&type=1&id=" + id, "_blank")
            }
             else if (action_id == "print6") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&print_type=6&type=1&id=" + id, "_blank")
            }
             else if (action_id == "print7") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&print_type=7&type=1&id=" + id, "_blank")
            }

             else if(action_id == "print_preview"){
            window.open($('#liveSite').val()+"/index.php?r=quotation/PrintQuotationReportPDF&type=2&preview=Y&id="+id,"_blank")
            }

            else if(action_id == "print_monthly"){
        	window.open($('#liveSite').val()+"/index.php?r=quotation/PrintQuotationReportPDFMonthly&type=1&id="+id,"_blank")
        	}
            else if(action_id == "print_yearly"){
            loadPopupModal('quotation/CreateYearly&type=1&id='+id,'Print Yearly','sm');
            //	window.open($('#liveSite').val()+"/index.php?r=sales/quotation/PrintQuotationYearlyReportPDF&type=1&id="+id,"_blank")
            }
             else if (action_id == "printimg") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&type=2&id=" + id, "_blank")
            } else if (action_id == "print_without_part_no") {
            //window.open($('#liveSite').val()+"/index.php?r=quotation/PrintQuotation&id="+id,"_blank")
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&type=3&id=" + id, "_blank")
            } else if (action_id == "printimg_technical") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&type=5&id=" + id, "_blank")
            } else if (action_id == "printimg_without_part_no") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationReportPDF&type=4&id=" + id, "_blank")
            } else if (action_id == "printprofit") {
            preview = 'N';
            if (is_approved == 'N') {
            preview = 'Y';
            }
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationProfitReportPDF&type=5&preview=" + preview + "&id=" + id, "_blank")
            } else if (action_id == "activity") {
            loadPopupModal("activity/activity/history&file_id=" + file_id + "&customer_id=" + customer_id + "&id=" + id + "&header_id=" + id + "&frm=QN", "Quotation", "xl");
            } else if (action_id == "approve_level" && current_process_status == 'Q' && is_approved == "N" && currentApproveLevel > 0) {
                loadPopupModal("quotation/approvelevel&frm=" + frm +"&id=" + id + "&file_id=" + file_id + "&level="+currentApproveLevel, "Level "+currentApproveLevel+" Approve Quotation-" + file_id + "/" + id + "/" + customer_name, "lg");
            /*} else if (action_id == "approve" && current_process_status == 'Q' && is_approved == "N") {
            loadPopupModal("quotation/create&frm=" + frm +"&id=" + id + "&file_id=" + file_id + "&type=1", "Approve Quotation-" + file_id + "/" + id + "/" + customer_name, "xl");
            } else if (action_id == "unapprove" && current_process_status == 'Q' && is_approved == "Y") {
            loadPopupModal("quotation/create&frm=" + frm +"&id=" + id + "&file_id=" + file_id + "&type=2", "Unapprove Quotation-" + file_id + "/" + id + "/" + customer_name, "xl");*/
            } else if (action_id == "printhiring") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintHiringQuotationReportPDF&id=" + id + "&print_type=img", "_blank")
            } else if (action_id == "checkquantity") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintQuotationAvailableQtyPDF&id=" + id, "_blank")
            } else if (action_id == "printhiringword") {
            window.open($('#liveSite').val() + "/index.php?r=quotation/PrintHiringQuotationWordNew&id=" + id, "_blank")
            } else if (action_id == "revision") {
            loadPopupModal('quotation/revisionhistory&id=' + id, 'Revision', 'lg');
            } else if (action_id == "allocate") {
            loadPopupModal('inventory/allocatematerials&id=' + id + '&file_id=' + file_id + '&frm=Q', 'Allocate Products', 'xl');
            }


            },
            items: {
<?php if ((!empty($variabledata) && $variabledata == 'Q') && (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_edit"]))) { ?> "edit": {
                name: "Edit",
                        icon: "edit",
                        disabled: function(key, opt) {
                        // this references the trigger element
                        if (current_process != 'Q') {
                        return !this.data('editDisabled');
                        }
                        }
                },
<?php } ?>
<?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_view"]))) { ?> "view": {
                name: "View",
                        icon: "fa-eye",
                        disabled: function(key, opt) {
                        // this references the trigger element
                        /*if (current_process == 'Q') {
                        return !this.data('viewDisabled');
                        }*/
                        }
                },
<?php } ?>

<?php if ((!empty($variabledata) && $variabledata == 'Q') && (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_convert"]))) { ?> "convert": {
                name: "Convert",
                        icon: "fa-retweet",
                        disabled: function(key, opt) {
                        // this references the trigger element
                        if (is_approved == 'N' || current_process!='Q') { //current_process!='Q' &&
                        return !this.data('convertDisabled');
                        }
                        }, visible: function(key, opt) {
            return ((is_approved_status == 'Y' && currentApproveLevel == 0) || is_approved_status == 'Y');
        }
                },
<?php } ?>
<?php if ((int) Yii::app()->user->haveLevelPermissionOn['sales_level_permission_approvals'] > 0 || Yii::app()->user->authorised_user == 1) {?>
    <?php if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_approve"]))){ ?>
        "approve_level": {
            name: "Approve Level "+currentApproveLevel, icon: "fa-question", disabled: function(key, opt) {
                // this references the trigger element
                if(is_approved=='Y' || accessApproveLevel =='N'){
                    return !this.data('approveDisabled');
                }
            },
            visible: function(key, opt) {
                return (is_approved=='N' && currentApproveLevel > 0);
            }
        },
    <?php } ?>
<?php } ?>
<?php  /*if ((int) Yii::app()->user->haveLevelPermissionOn['sales_level_permission_approvals'] > 0 || Yii::app()->user->authorised_user == 1) {?>
<?php  if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_approve"]))){ ?>
  "approve": {name: "Approve", icon: "fa-question", disabled: function(key, opt) {
  // this references the trigger element
  if(is_approved=='Y'){
  return !this.data('approveDisabled');
  }
  }
  },
  <?php } ?>
  <?php }*/ ?>
  <?php  /*if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_approve"]))){ ?>
  "unapprove": {name: "Unapprove", icon: "fa-thumb-tack", disabled: function(key, opt) {
  // this references the trigger element
  if(is_approved=='N' || current_process!='Q'){
  return !this.data('unapproveDisabled');
  }
  }
  },
  <?php } */ ?>
   <?php if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_pdf"]))){ ?>
"prints": {
    name: "Prints",
    icon: "fa-print",
    items: {

         "print_preview": {
            name: "Preview",
            icon: "fa-eye",
            disabled: function(key, opt) {
                    // this references the trigger element
                    if ((is_approved == 'Y' )) {
                    return !this.data('printDisabled');
                    }
                    }
        },
         "printimg": {
            name: "Print",
                    icon: "fa-print",
                    disabled: function(key, opt) {
                    // this references the trigger element
                    if ((is_approved == 'N' && current_process == 'Q')) {
                    return !this.data('printDisabled');
                    }
                    if(sales_group_id==1){
                        return this.data('viewDisabled'); 
                    }
                    else if(sales_group_id==2)
                    {
                        return !this.data('viewDisabled'); 
                    }
                    }
            },
             <?php if ($frm == 3) { ?>
        "print_monthly": {
            name: "Monthly Quotation",
            icon: "fa-print",
            disabled: function(key, opt) {
                    // this references the trigger element
                    if ((is_approved == 'N' && current_process == 'Q')) {
                    return !this.data('printDisabled');
                    }
                    if(sales_group_id==1){
                        return !this.data('viewDisabled'); 
                    }
                    else if(sales_group_id==2)
                    {
                        return this.data('viewDisabled'); 
                    }
                    }
        },
        "print_yearly": {
            name: "Yearly Quotation",
            icon: "fa-print",
            disabled: function(key, opt) {
                    // this references the trigger element
                    if ((is_approved == 'N' && current_process == 'Q')) {
                    return !this.data('printDisabled');
                    }
                     if(sales_group_id==1){
                        return !this.data('viewDisabled'); 
                    }
                    else if(sales_group_id==2)
                    {
                        return this.data('viewDisabled'); 
                    }
                    }
        },
        

       <?php } ?>
      
        
        <?php if($print_wo_part == 1){ ?>
        "print5": {
            name: "Print with Image",
            icon: "fa-print",
            disabled: function(key, opt) {
                if ((is_approved == 'N' && current_process == 'Q')) {
                    return !this.data('printDisabled');
                }
            }
        },
        <?php } ?>
        <?php /*if($print_image_desc == 1){ ?>
        "print6": {
            name: "Without Image",
            icon: "fa-print",
            disabled: function(key, opt) {
                if ((is_approved == 'N' && current_process == 'Q')) {
                    return !this.data('printDisabled');
                }
            }
        },
        <?php }*/ ?>
        <?php /*if($print_with_all == 1){ ?>
        "print7": {
            name: "All",
            icon: "fa-print",
            disabled: function(key, opt) {
                if ((is_approved == 'N' && current_process == 'Q')) {
                    return !this.data('printDisabled');
                }
            }
        }
        <?php }*/ ?>

       
    }, visible: function(key, opt) {
            return ((is_approved_status == 'Y' && currentApproveLevel == 0) || is_approved_status == 'Y');
        }
},
<?php }?>
<?php /* if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_view"]))){ ?>
  "revision": {name: "Revision", icon: "fa-file"},
  <?php } ?>

  <?php  if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_allocate"]))){ ?>
  "allocate": {name: "Allocate", icon: "fa-file", disabled: function(key, opt) {
  // this references the trigger element
  if(is_approved=='N'){
  return !this.data('allocateDisabled');
  }
  }},
  <?php } */ ?>

<?php /* if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["report_sale_qtn_profit_view"])) && $frm!=1){ ?>
  "printprofit": {name: "Print Profit", icon: "fa-print", disabled: function(key, opt) {
  // this references the trigger element

  }},
  <?php } */ ?> 
  <?php if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_pdf"]))){ ?>
//   "print": {
//             name: "Print",
//                     icon: "fa-print",
//                     disabled: function(key, opt) {
//                     // this references the trigger element
//                     if ((is_approved == 'N' && current_process == 'Q')) {
//                     return !this.data('printDisabled');
//                     }
//                     }
//             },
// "menuPrintNew": {
//     name: "Prints",
//     icon: "fa-print",
//     items: {
//         <?php if($print_standard == 1){ ?>
//         "print1": {
//             name: "Standard",
//             icon: "fa-print",
//             disabled: function(key, opt) {
//                 if ((is_approved == 'N' && current_process == 'Q')) {
//                     return !this.data('printDisabled');
//                 }
//             }
//         },
//         <?php } ?>
//         <?php if($print_with_discount == 1){ ?>
//         // "print2": {
//         //     name: "With Discount",
//         //     icon: "fa-print",
//         //     disabled: function(key, opt) {
//         //         if ((is_approved == 'N' && current_process == 'Q')) {
//         //             return !this.data('printDisabled');
//         //         }
//         //     }
//         // },
//         <?php } ?>
//         <?php if($print_wo_discount == 1){ ?>
//         "print3": {
//             name: "Without Discount",
//             icon: "fa-print",
//             disabled: function(key, opt) {
//                 if ((is_approved == 'N' && current_process == 'Q')) {
//                     return !this.data('printDisabled');
//                 }
//             }
//         },
//         <?php } ?>
//         <?php if($print_with_desc == 1){ ?>
//         // "print4": {
//         //     name: "With Description",
//         //     icon: "fa-print",
//         //     disabled: function(key, opt) {
//         //         if ((is_approved == 'N' && current_process == 'Q')) {
//         //             return !this.data('printDisabled');
//         //         }
//         //     }
//         // },
//         <?php } ?>
//         <?php if($print_wo_part == 1){ ?>
//         "print5": {
//             name: "Without Part Number",
//             icon: "fa-print",
//             disabled: function(key, opt) {
//                 if ((is_approved == 'N' && current_process == 'Q')) {
//                     return !this.data('printDisabled');
//                 }
//             }
//         },
//         <?php } ?>
//         <?php if($print_image_desc == 1){ ?>
//         "print6": {
//             name: "With Image & Description",
//             icon: "fa-print",
//             disabled: function(key, opt) {
//                 if ((is_approved == 'N' && current_process == 'Q')) {
//                     return !this.data('printDisabled');
//                 }
//             }
//         },
//         <?php } ?>
//         <?php if($print_with_all == 1){ ?>
//         "print7": {
//             name: "All",
//             icon: "fa-print",
//             disabled: function(key, opt) {
//                 if ((is_approved == 'N' && current_process == 'Q')) {
//                     return !this.data('printDisabled');
//                 }
//             }
//         }
//         <?php } ?>
//     }
// },
            // "printimg": {
            // name: "Print With Image",
            //         icon: "fa-print",
            //         disabled: function(key, opt) {
            //         // this references the trigger element
            //         if ((is_approved == 'N' && current_process == 'Q')) {
            //         return !this.data('printDisabled');
            //         }
            //         }
            // },
  <?php } ?>          
                    //            "fold-print": {
                    //             visible:false,
                    //            "name": "Print",
                    //                    "icon": "fa-print",
                    //                    "items": {
                    //<?php //if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_pdf"])) && $frm!=1){
?>
                    //                    /*"printpreview": {name: "Print Preview", icon: "fa-print", disabled: function(key, opt) {
                    //                     // this references the trigger element
                    //                     if ((is_approved == 'N' && current_process == 'Q')){
                    //                     return !this.data('printDisabled');
                    //                     }
                    //                     }},*/
                    //<?php //}
?>
                    //<?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_pdf"])) && $frm != 1) { ?>
                        //                        "print": {name: "Print", icon: "fa-print", disabled: function(key, opt) {
                        //                        // this references the trigger element
                        //                        if ((is_approved == 'N' && current_process == 'Q')){
                        //                        return !this.data('printDisabled');
                        //                        }
                        //                        }},
                        //<?php } ?>
                    //                    }
                    //            },
<?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_copy"]))) { ?> "copy": {
                        name: "Copy Quotation",
                                icon: "copy"
                        },
<?php } ?>
<?php if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_activity"]) { ?>
"activity": {
    name: "Activity",
    icon: "fa-certificate"
},
<?php } ?>             
<?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_add"]))|| ((int) Yii::app()->user->havePermissionOn["{$prefix}_edit"])) { ?> "analysis": {
                        name: "Analyze (Beta)",
                                icon: "fa-database"
                        },
<?php } ?>





            /*"fold-other": {
             "name": "Other",
             "icon": "fa-plus",
             "items": {

<?php /* if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"]))){ ?>
  "activity": {name: "Activity", icon: "fa-certificate"},
  <?php } */ ?>
<?php /* if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_approve"]))){ ?>
  "approve": {name: "Approve", icon: "fa-question", disabled: function(key, opt) {
  // this references the trigger element
  if(is_approved=='Y'){
  return !this.data('approveDisabled');
  }
  }
  },
  <?php } ?>

  <?php  if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_approve"]))){ ?>
  "unapprove": {name: "Unapprove", icon: "fa-thumb-tack", disabled: function(key, opt) {
  // this references the trigger element
  if(is_approved=='N' || current_process!='Q'){
  return !this.data('unapproveDisabled');
  }
  }
  },
  <?php } */ ?>
             }
             },  */






            }
    });
    });
    });</script>

<section class="panel" style="background-color:#F6F3EE;">
    <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
    <?php if ($frm == 1) { ?>
        <header class="panel-heading clearfix panel-theame-new">
    <?php } else { ?>
        <header class="panel-heading clearfix panel-theame">
    <?php } ?>

        <div class="row">
            <!-- Left: Heading -->
            <div class="col-sm-3">
                <?php if($frm==3 && $type== "C")
                        echo "Service Quotation";
                      else if($frm==3 && $type== "T")
                        echo "Service Quotation";
                       else
                        echo "Quotations"; ?>
            </div>
              <div class="col-sm-10" style="display: flex;width:75%;float:right">
                    <div style="display: flex; justify-content: flex-end; align-items: center; gap: 15px;width:100%"
                        id="invoice-filter-details">
                        <ul class="list-inline stats-inline" style="margin: 0; font-size: 13px;background: #f0f0f029;border-radius: 10px;margin-right: 5px;">
                            <li>Quantity: <?php echo $totalQuotes; ?></li>
                            <li>Value: <?php echo number_format($totalQuotesAmount, 0); ?></li>
                        </ul>
                    </div>
                    <div class="dropdown drp-tot">
                        <button class=" dropdown-toggle" type="button" data-toggle="dropdown">
                            <span class="selected-label">---SELECT---</span> <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu" id="invoice-filter">
                           <li><a href="#" data-id="today">Today</a></li>
                            <li><a href="#" data-id="yesterday">Yesterday</a></li>
                            <li><a href="#" data-id="this_week">This Week</a></li>
                            <li><a href="#" data-id="this_month">This Month</a></li>
                            <li><a href="#" data-id="quarterly">This Quarter</a></li>
                            <li><a href="#" data-id="this_year">This Year</a></li>

                        </ul>
                    </div>
             

                    <!-- Add Button -->
                    <?php
                    if ($modelCompanySettings->direct_quotation == 'Y') {
                        // var_dump($prefix);
                        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_add"])) {
                            ?>
                           <a class="ad-btn" id="add_popup" onclick="loadPopupModal('quotation/create&frm=<?php echo $frm; ?>&type=add&service_type=<?php echo $type; ?>', 'Add New Quotation', 'xl')" title="Add">
                                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </a>
                            </button>
                            <?php
                        }
                    }
                    ?>
                   </div>    
                </div>
            </div>
        </div>
    </header>

        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tble_quotations" style="font-size:13px;">
                    <thead>
                        <tr>
                            
                            <th>File</th>
                            <th>Qtn No.</th>
                            <th>Customer</th>
                            <th>Salesman</th>
                            <th>Qtn.Date</th>
                            <th>Qtn.Validity</th>
                            <th>Currency</th>
                            <th>VAT</th>
                            <th>Value</th>
                            <th>Value(BC)</th>
                            <th>Status</th>
                            <th></th>
                        </tr>
                    </thead>
                </table>
            </div>
            <div class="color-indicator">
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $color[8]; ?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php echo $colorname[8]; ?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $color[9]; ?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php echo $colorname[9]; ?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $color[10]; ?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php echo $colorname[10]; ?></span>
            </div>
        </div>
</section>



<script>
    $(document).ready(function () {
        $('#invoice-filter li a').on('click', function (e) {
            e.preventDefault(); // Prevent default link behavior

            var filter = $(this).data('id');
            var label = $(this).text();
            var filtertype = "<?php echo $type; ?>";

            $('.selected-label').text(label);
            $.ajax({
                url: "<?php echo Yii::app()->createUrl('quotation/GetFilterQtnData'); ?>",
                type: "POST",
                dataType: "json",
                data: { filter: filter,type: filtertype },

                success: function (response) {
                    if (response.status === "success") {
                        var qty = response.data.qty || 0;
                        var total = Number(response.data.total).toLocaleString('en-IN', { maximumFractionDigits: 0 });

                        // Use actual period label for current (e.g., "26-06-2025" or "2025")
                        var periodLabel = response.data.current_period || new Date().getFullYear();

                        // Base content for current period
                        var htmlContent = '<li>(' + periodLabel + ') Count: ' + qty + '</li>' +
                            '<li>Value: ' + total + '</li>';

                        // Handle previous_years if exists
                        if (response.data.previous_years && response.data.previous_years.length > 0) {
                            response.data.previous_years.forEach(function (yearData) {
                                var prevQty = yearData.qty || 0;
                                var prevTotal = Number(yearData.total).toLocaleString('en-IN', { maximumFractionDigits: 0 });

                                // Prefer date label for today/yesterday, fallback to year
                                var label = yearData.date || yearData.year;

                                htmlContent += '<li> | (' + label + ') Count: ' + prevQty + '&nbsp;&nbsp;&nbsp; Value: ' + prevTotal + '</li>';
                            });
                        }

                        $('#invoice-filter-details ul').html(htmlContent);
                    } else {
                        t8.error("Failed to fetch invoice data.");
                    }
                },

                error: function (xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    t8.error("Something went wrong.");
                }
            });
        });
    });
</script>