<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'quotation-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    echo $form->hiddenField($model, 'id'); ?>
    <input type="hidden" name="level" id="level" value="<?php echo $level; ?>">
    <div class="tab-content">
        <div class="tab-pane active" id="quotes_tab1">
            <?php
            $modelMasCompanySettings = new MasCompanySettings();
            $modelMasCompanySettings = $modelMasCompanySettings->find(array('condition' => 'crm_company_id=' . (int) Yii::app()->user->master_user_company_id));
            $quotation_validity_days = $modelMasCompanySettings->quotation_validity_days; ?>
            <input type="hidden" id="quotation_validity_days" value="<?php echo $quotation_validity_days ?>">
            <ul class="clearfix form-ul material">
                <?php
                if ($model->customer_id > 0) {
                    $customer_name = $model->customer->customer_name;
                } else {
                    $customer_name = $model_lead->customer->customer_name;
                } ?>
                <li class="col-sm-3">
                    <?php echo CHtml::textField('customer_name', $customer_name, array('class' => 'text-bold', 'title' => 'Customer', 'data-label' => 'Customer <span style="color:red">*</span>', 'readonly' => true)); ?>
                    <?php echo $form->hiddenField($model, 'customer_id'); ?>
                    <?php echo $form->hiddenField($model, 'ticket_id'); ?>
                </li>
                <?php
                $qtn_start_date = date("d/m/Y");
                $qtn_validity = date("d/m/Y", strtotime($model->qtn_validity . '+' . $quotation_validity_days . ' days'));
                $tender_close = date("d/m/Y");
                if ($model->id > 0) {
                    $qtn_start_date = date("d/m/Y", strtotime($model->qtn_start_date));
                    $qtn_validity = date("d/m/Y", strtotime($model->qtn_validity));
                } ?>
                <li class="col-sm-3">
                    <?php echo $form->textField($model, 'qtn_start_date', array('class' => 'datepicker text-bold', 'data-label' => 'Qtn Date', 'value' => $qtn_start_date, 'readonly' => true)); ?>
                    <?php echo $form->hiddenField($model, 'tender_closing_date', array('class' => 'datepicker text-bold', 'data-label' => 'Tender Closing Date', 'value' => $tender_close)); ?>
                </li>
                <li class="col-sm-3">
                    <?php echo $form->textField($model, 'qtn_validity', array('class' => 'datepicker text-bold', 'data-label' => 'Qtn Validity ', 'value' => $qtn_validity, 'readonly' => true)); ?>
                </li>
                <li class="col-sm-3">
                    <?php
                    $MasQuotesStatus = new MasQuotesStatus();
                    echo $form->dropDownList(
                        $model,
                        'status',
                        $MasQuotesStatus->getQuotesStatus(),
                        array(
                            'data-label' => 'Status',
                            'class' => 'text-bold',
                            'disabled' => true
                        )
                    ); ?>
                </li>
                <?php if (Yii::app()->user->company_base_currency == $model->currency_id || (int) $model->id == 0) {
                        $model->exchange_rate = 1;
                    } ?>
                <li class="col-sm-3">
                    <div id="quote_currency_div">
                        <?php
                        $company = MasCompany::model()->find();
                        echo $form->hiddenField($company, 'currency_id', array('id' => 'MasCompany_currency_id'));
                        echo $form->dropDownList($model, 'currency_id', MasCurrency::getCurrency(), array(
                            'class' => 'tooltipster text-bold',
                            'title' => 'Currency',
                            'data-label' => 'Currency <span style="color:red">*</span>',
                            'disabled' => true
                        )); ?>
                    </div>
                </li>
                <li class="col-sm-3">
                    <?php echo $form->textField($model, 'exchange_rate', array(
                        'class' => 'tooltipster',
                        'title' => 'Exchange Rate',
                        'data-label' => 'Exchange Rate <span style="color:red">*</span>',
                        'readonly' => 'readonly'
                    )); ?>
                </li>
                <li class="col-sm-6">
                    <?php echo $form->textArea($model, 'notes', array(
                        'class' => 'tooltipster',
                        'title' => 'Notes',
                        'value' => '',
                        'data-label' => 'Notes',
                    )); ?>
                </li>
                <li class="col-sm-3">Total Amount 
                    <?php foreach ($modelQuoteItems as $i => $modelQuoteItems):
                        $total += $modelQuoteItems->amount;
                        $total_vat += $modelQuoteItems->tax_vat_amount;
                    endforeach;
                    $grand_total = $total;
                    $grand_total += $total_vat; ?>
                    <?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " "); ?>
                </li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="qtn_close" data-dismiss="modal">Close</button>
        <?php 
        $btn = 'Approve';
        $url = Yii::app()->createUrl('features/approvelevel/saveapprove');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#quotation-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Quotation Approved!","Success");
                    $("#qtn_close").click();
                    reloadTable("#tble_quotations");
                } else {
                    $("#quotation-form .quotation-save-btn").prop("disabled", false);
                    $("#quotation-form .quotation-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#quotation-form #"+key+"_em_").text(val).show();
                            t8.error(""+val+"");
                        });
                    }
                }',
                'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'quotation-save-btn btn btn-theme'));
        $btn = 'Reject';
        $url = Yii::app()->createUrl('features/approvelevel/savereject');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#quotation-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Quotation Rejected!","Success");
                    $("#qtn_close").click();
                    reloadTable("#tble_quotations");
                } else {
                    $("#quotation-form .quotation-save-btn").prop("disabled", false);
                    $("#quotation-form .quotation-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#quotation-form #"+key+"_em_").text(val).show();
                        t8.error(""+val+"");
                    });
                }
            }',
            'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'quotation-save-btn btn btn-theme')); ?>
    </div>
    <?php $this->endWidget(); ?>
</div>