 <style>
.info-box {
    padding: 4px 14px;
    border-radius: 12px;
    background: #ffffff;
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    font-family: 'Segoe UI', sans-serif;
    color: #333;
    margin-bottom: 5px;
}
.info-box p {
    font-size: 15px;
    font-weight: 600;
    margin-bottom: 15px;
    color: #007bff;
}
.info-box h2 {
    font-size: 13px;
    margin: 9px 0;
    padding: 2px 8px;
    background: #f5f5f5;
    border-left: 4px solid #007bff;
    border-radius: 4px;
    line-height: 18px;
}
.info-box h2:last-child {
    background: #e8eef8;
    border-left-color: #4285f4;
}
</style> 
<?php
$condition = 'quotes_id="' . $id . '"'; //To fetch all
$modelQuoteItemsAll = QuotesItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC')); ?>

<div id="page_wrap">
    <div class="banner row">
        <div id="typed-data" style="display: none;">
            <?php foreach ($modelQuoteItemsAll as $i => $modelQuoteItems): 
                $condition = 's.id = '.$modelQuoteItems->product_id;
                $query = 'SELECT s.id,sum(sl.quantity * sl.unit_factor) AS qty 
                    FROM erp_stock_ledger as sl left join  erp_store as s ON sl.product_id=s.id 
                    WHERE '.$condition.' GROUP BY sl.product_id' ;
                $modelStore = Yii::app()->db->createCommand($query)->queryRow();
                $SQL2 ="SELECT item.product_id, item.description, item.purchasing_invoice_id, item.quantity, item.rate, pi.vendor_id, pi.invoice_date,item.unit 
                    FROM erp_purchasinginvoice_item item JOIN erp_purchasinginvoice pi ON pi.id = item.purchasing_invoice_id
                    WHERE item.product_id=".$modelQuoteItems->product_id." ORDER BY pi.id LIMIT 2";
                $SQL ="SELECT * FROM `erp_stock_ledger` 
                    WHERE transaction_from = 'QUALITY_CHECK' AND product_id=".$modelQuoteItems->product_id." ORDER BY id DESC LIMIT 2;";
                $arr_Last_purchased_items = Yii::app()->db->createCommand($SQL)->queryAll();
                $modelUnit = UnitOfMeasurement::model()->findByPk($modelQuoteItems["unit_id"]); ?>
                <div class="col-lg-6">
                    <div class="info-box">
                        <p><?php echo $modelQuoteItems->product->part_number.' | '.$modelQuoteItems->description; ?></p>
                        <!-- <h2><?php echo $modelQuoteItems->description; ?></h2> -->
                        <?php if ($modelStore['qty']) { ?>
                            <h2>
                                <span style="margin-right: 40px;"><?php echo "Available Qty: " . number_format($modelStore['qty'], 3); ?></span>
                                <span style="margin-right: 40px;"><?php echo "Unit: " . $modelUnit['name']; ?></span>
                                <span><?php echo "Selling Price:"; ?></span>
                            </h2>
                            <h2>
                                <?php
                                $n = 1;
                                foreach($arr_Last_purchased_items as $eachPurchase) {
                                    $purchase_date = "";
                                    if (!empty($eachPurchase['transaction_date']) && ($eachPurchase['transaction_date'] != "0000-00-00")) {
                                        $purchase_date = date('d/m/Y', strtotime($eachPurchase["transaction_date"]));
                                    }
                                    $modelVendor = Vendor::model()->findByPk($eachPurchase["customer_vendor_id"]);
                                    echo '<span style="margin-right: 30px;">' . 
                                        $n++ . '. ' . $modelVendor->vendor_name . 
                                        ' on <span style="color:blue;">' . $purchase_date . '</span>' .
                                        ' <b>Rate</b>: <span style="color:green;">' . number_format($eachPurchase["buying_price"], 2) . '</span>' .
                                    '</span>';
                                } ?>
                            </h2>
                        <?php } else {
                            $googleProductDetails = GetGoogleSearchProducts($modelQuoteItems->description); ?>
                            <h2>
                                <span style="margin-right: 40px;">
                                    It seems we have no record of purchase of this product. We feel you could source it from 
                                    <?php
                                    if ($googleProductDetails) {
                                        foreach ($googleProductDetails as $gKey => $googleProductDetail) { ?>
                                            <br><?= (int) $gKey+1; ?>) <strong><?= $googleProductDetail['company_name']; ?></strong> at <strong><?= $googleProductDetail['address']; ?></strong>.
                                            <?php if ($googleProductDetail['website'] && $googleProductDetail['phone']) { ?>
                                                You could view the details of this company at <a href="<?= $googleProductDetail['website']; ?>" target="_blank" title="<?= $googleProductDetail['website']; ?>"><strong style="color:blue;"><?= $googleProductDetail['website']; ?></strong></a> or call them at <strong><?= $googleProductDetail['phone']; ?></strong>.
                                            <?php } else if ($googleProductDetail['website']) { ?>
                                                You could view the details of this company at <a href="<?= $googleProductDetail['website']; ?>" target="_blank" title="<?= $googleProductDetail['website']; ?>"><strong style="color:blue;"><?= $googleProductDetail['website']; ?></strong></a>. 
                                            <?php } else if ($googleProductDetail['phone']) { ?>
                                                You could call them at <strong><?= $googleProductDetail['phone']; ?></strong> for getting details of this company.
                                            <?php } ?>
                                        <?php }
                                    } ?>
                                </span>
                            </h2>
                        <?php } ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <p class="typed-text"></p>
    </div>
</div>
<div class="modal-footer"><button type="button" class="btn btn-danger" data-dismiss="modal">Close</button></div>
<script>
// Get content from the hidden div
var dynamicContent = document.getElementById('typed-data').innerHTML;
var typed = new Typed('.typed-text', {
    strings: [dynamicContent],
    typeSpeed:2,
    backSpeed: 0,
    backDelay: 0,
    startDelay: 500,         // Initial delay before first line
    loop: false,
    smartBackspace: false,   // Prevent auto-deletion
    html: true,
    showCursor: false
});

function SearchProduct() {
    var term   = $('#product_id').val();
    var quotes_id  = $('#id').val();
    if(term!='' && quotes_id>0){
        $('#loader').show();
        jQuery.ajax({
            dataType: 'html',
            type: 'POST',
            url: '?r=Quotation/SearchAnalysisProducts',
            cache: false,
            data: {'term': term,'quotes_id':quotes_id},
            success: function (data) {
                $("#div_search").html(data);
                $('#loader').hide();
            },
        });
    }else{
        t8.error('Required ');
        return false;
    }
}
</script>
<?php
function GetGoogleSearchProducts($productName) {
    $productName = 'List three suppliers in the Middle East from where we can purchase '.$productName;
    $apiKey = Yii::app()->params['googleMapKey'];
    try {
        $placeId = '';
        $palceUrl = 'https://maps.googleapis.com/maps/api/place/nearbysearch/json?';
        if (!$placeId) {
            $url = 'https://maps.googleapis.com/maps/api/place/findplacefromtext/json?' . http_build_query([
                'input' => $productName,
                'inputtype' => 'textquery',
                'fields' => 'place_id,name,formatted_address,geometry',
                'key' => $apiKey,
            ]);
            $response = makeGetRequest($url);
            $data = json_decode($response, true);
            if (empty($data['candidates'])) {
                return ['error' => 'No Google Product details found'];
            }
            $placeId = $data['candidates'][0]['place_id'];
            $palceLanLng = implode(',', $data['candidates'][0]['geometry']['location']);
            if ($palceLanLng) {
                $palceUrl = 'https://maps.googleapis.com/maps/api/place/nearbysearch/json?location='.$palceLanLng.'&radius=50000&';
            }
        }
        $url = $palceUrl . http_build_query([
            'keyword' => $productName,
            'fields' => 'name,formatted_address,formatted_phone_number,website',
            'key' => $apiKey,
        ]);
        $response = makeGetRequest($url);
        $results = json_decode($response, true)['results'] ?? [];
        if (empty($results)) {
            return ['error' => 'No Google Product details found'];
        } else {
            foreach ($results as $rKey => $resultRow) {
                if ($rKey < 3) {
                    $placeId = $resultRow['place_id'];
                    $url = 'https://maps.googleapis.com/maps/api/place/details/json?'. http_build_query([
                        'place_id' => $placeId,
                        'fields' => 'name,formatted_address,formatted_phone_number,website',
                        'key' => $apiKey,
                    ]);
                    $response = makeGetRequest($url);
                    $result = json_decode($response, true)['result'] ?? [];
                    $productDetails[] = array( 
                        'company_name' => $result['name'] ?? '',
                        'address' => $result['formatted_address'] ?? '',
                        'phone' => $result['formatted_phone_number'] ?? '',
                        'website' => $result['website'] ?? '',
                        'place_id' => $placeId,
                    );
                }
            }
        }
        return $productDetails;
    } catch (Exception $e) {
        return ['error' => 'Failed to fetch Google Product Details: ' . $e->getMessage()];
    }
}
function makeGetRequest($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'MyApp/1.0 (+https://example.com)');
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
} ?>