<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("Mrposted", "function Mrposted(mr_id) {
    jConfirm('Confirm Posting  of Material Receipt- '+mr_id+' ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':mr_id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/Posting/PostMaterialReceipt') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Material Receipt Posted!');  
                            reloadTable('#tbl_receipt_details'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error(val); 
                            }); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD); ?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_receipt_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('qualitycheck/GetMaterialRequestList') ?>",
                type: "POST",
                cache: false,
            },
            order: [
                [2, "desc"]
            ],
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                addQualityCheckContextMenu(nRow, aData);
            }
        });
    });

    function addQualityCheckContextMenu(row, datas) {
        var id = datas[3];
        var file_id = datas[1];
        var qcchecked = datas[9];
        var is_convertable = datas[10];
        var posted = datas[11];

        // Build items dynamically
        var menuItems = {};

        <?php if ((int) Yii::app()->user->havePermissionOn['purchase_qc_edit'] == 1 || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.edit = {
                name: "Quality Check",
                icon: "edit",
                accesskey: "e",
                disabled: function () {
                    return qcchecked === 'Y';
                },
                callback: function () {
                    loadPopupModal(
                        "qualitycheck/create&id=" + id + "&file_id=" + file_id,
                        "Material Receipt No - " + id,
                        "xl"
                    );
                }
            };
        <?php } ?>

        <?php if ((int) Yii::app()->user->havePermissionOn['purchase_qc_convert'] == 1 || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.convert = {
                name: "Convert",
                icon: "fa-retweet",
                accesskey: "c",
                disabled: function () {
                    return (is_convertable === 'N' || qcchecked === 'N');
                },
                callback: function () {
                    loadPopupModal(
                        "purchaseinvoice/create&mr_id=" + id + "&file_id=" + file_id,
                        "File No - " + file_id,
                        "xl"
                    );
                }
            };
        <?php } ?>

        <?php if ((int) Yii::app()->user->havePermissionOn['purchase_material_print'] == 1 || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.print = {
                name: "Print",
                icon: "fa-print",
                accesskey: "p",
                items: {
                    summary: {
                        name: "Print",
                        icon: "fa-file-pdf-o",
                        disabled: function () {
                            return (qcchecked === 'N');
                        },
                        callback: function () {
                            window.open(
                                $('#liveSite').val() + "/index.php?r=materialreceipt/Print&id=" + id + "&printtype=summary&type=qc",
                                "_blank"
                            );
                        }
                    },
                    serial: {
                        name: "Print with Serial No.",
                        icon: "fa-barcode",
                        disabled: function () {
                            return (qcchecked === 'N');
                        },
                        callback: function () {
                            window.open(
                                $('#liveSite').val() + "/index.php?r=materialreceipt/Print&id=" + id + "&printtype=serial&type=qc",
                                "_blank"
                            );
                        }
                    }
                }
            };
        <?php } ?>


        <?php if ((isset(Yii::app()->user->havePermissionOn['QC_activity']) && (int) Yii::app()->user->havePermissionOn['QC_activity'] == 1) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.activity = {
                name: "Activity",
                icon: "fa-certificate",
                accesskey: "a",
                callback: function () {
                    loadPopupModal(
                        "activity/activity/history&file_id=" + id + "&id=" + id + "&header_id=" + id + "&frm=QC",
                        "Quality Check",
                        "xl"
                    );
                }
            };
        <?php } ?>

        // ✅ Only bind contextMenu if we have at least one menu item
        if (Object.keys(menuItems).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: menuItems
            });
        }
    }

</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa"></i> Quality Check

    </header>

    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_receipt_details"
                style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Sl.No</th>
                        <th>File</th>
                        <th>Order No</th>
                        <th>MRV#</th>
                        <th>Supplier Name</th>
                        <th>QC</th>
                        <th>MRV Date</th>
                        <th>QC Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>