<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
    'id' => 'order-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<input type="hidden" name="level" id="level" value="<?php echo $level; ?>">
<div class="tab-content">
    <div class="tab-pane active" id="tab1">            
        <input type="hidden" name="hid_file_id" id="hid_file_id" value="<?php echo $file_id; ?>">
        <?php echo $form->hiddenField($model, 'id'); ?>
        <ul class="clearfix form-ul material">
            <li class="col-sm-3" id="supplier_div">
                <?php echo $form->dropDownList($model, 'vendor_id', Vendor::getVendors(), array('class' => '', 'prompt' => '-select-', 'title' => 'Select Supplier *', 'data-label' => 'Supplier <span style="color:red;">*</span>', 'disabled' => true, 'data-search' => true)); ?>
            </li>
            <li class="col-sm-3" id="p_div">
                <div id="div_payment_term">
                    <?php echo $form->dropDownList($model, 'payment_terms', MasPaymentTerm::getPaymentTerms(), array('class' => '', 'title' => 'Select Payment Terms', 'data-label' => 'Payment Terms <span style="color:red;">*</span> ')); ?>
                </div>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'required_date', array('class' => 'datepicker', 'title' => 'Required Date ', 'data-label' => 'Required Date <span style="color:red;">*</span>', 'data-search' => 'true', 'value' => $required_date)); ?>
            </li>
            <li class="col-sm-3" id="">
                <?php echo $form->textField($model, 'order_date', array('class' => 'datepicker', 'title' => 'Order Date ', 'data-label' => 'Order Date')); ?>
            </li>
            <?php if ((int) Yii::app()->user->haveLevelPermissionOn['master_level_permission_currency'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
                <li class="col-sm-3" id="c_div">
                    <?php
                    if ($model->isNewRecord) {
                        if ($model->vendor_id > 0) {
                            $model->currency = $model->vendor_details->vendor_currency_id;
                        } else if($_REQUEST['project_id']) {
                            $model->currency = MasCurrency::model()->findByAttributes(array('isBaseCurrency' => 'Y'))->id;
                        }
                    } ?>
                    <?php echo $form->dropDownList($model, 'currency', MasCurrency::getCurrency(), array( 'class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'prompt' => '--Select--', 'data-search' => true, 'disabled' => true)); ?>
                </li>
                <li class="col-sm-3">
                    <?php
                    if ($model->id == 0) {
                        if ($model->vendor_id > 0) {
                            $model->exchange_rate = $model->vendor_details->currency_detail->exchange_rate;
                        } else if($_REQUEST['project_id']) {
                            $model->exchange_rate = MasCurrency::model()->findByAttributes(array('isBaseCurrency' => 'Y'))->exchange_rate;
                        }
                    }
                    if (Yii::app()->user->company_base_currency == $model->currency) {
                        echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'data-label' => 'Exchange Rate', 'value' => $exchange_rate, 'readonly' => true));
                    } else {
                        echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'data-label' => 'Exchange Rate', 'value' => $exchange_rate));
                    } ?>
                </li>
            <?php } else {
                $model->currency = MasCurrency::base_currency_id(); 
                echo  $form->hiddenField($model, 'currency'); 
                $model->exchange_rate = MasCurrency::base_exchange_rate();
		        echo  $form->hiddenField($model, 'exchange_rate'); 
            } ?>
            <li class="col-sm-6">
                <?php echo $form->textArea($model, 'notes', array(
                    'class' => 'tooltipster',
                    'title' => 'Notes',
                    'value' => '',
                    'data-label' => 'Notes',
                )); ?>
            </li>
            <li class="col-sm-3">Total Amount 
                <?php foreach ($modelOrderStockItem as $i => $modelOrder) {
                    $stocktotal += $modelOrder->stock_item_amount;
                }
                $stockgrand_total = $stocktotal; ?>
                <?php echo Yii::app()->numberFormatter->formatCurrency($stockgrand_total, " "); ?>
            </li>
        </ul>
    </div>
</div> 
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="order_close" data-dismiss="modal">Close</button>
    <?php
    $btn = 'Approve';
    $url = Yii::app()->createUrl('features/approvelevel/saveapprove');
    echo CHtml::ajaxSubmitButton($btn, $url, array(
        'dataType' => 'json',
        'data' => 'js:$("#order-form").serialize()',
        'type' => 'post',
        'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){
                t8.success("Order Approved!","Success");
                $("#order_close").click();
                reloadTable("#tbl_order_details");
            } else {
                $("#order-form .order-save-btn").prop("disabled", false);
                $("#order-form .order-save-btn").addClass("btn-theme").removeClass("btn_loading");
                $.each(data, function(key, val) {
                    $("#order-form #"+key+"_em_").text(val).show();
                        t8.error(""+val+"");
                    });
                }
            }',
            'complete' => 'function(){}'
    ), array('id' => 'save_convert' . rand(), 'class' => 'order-save-btn btn btn-theme'));
    $btn = 'Reject';
    $url = Yii::app()->createUrl('features/approvelevel/savereject');
    echo CHtml::ajaxSubmitButton($btn, $url, array(
        'dataType' => 'json',
        'data' => 'js:$("#order-form").serialize()',
        'type' => 'post',
        'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){
                t8.success("Order Rejected!","Success");
                $("#order_close").click();
                reloadTable("#tbl_order_details");
            } else {
                $("#order-form .order-save-btn").prop("disabled", false);
                $("#order-form .order-save-btn").addClass("btn-theme").removeClass("btn_loading");
                $.each(data, function(key, val) {
                    $("#quotorderation-form #"+key+"_em_").text(val).show();
                    t8.error(""+val+"");
                });
            }
        }',
        'complete' => 'function(){}'
    ), array('id' => 'save_convert' . rand(), 'class' => 'order-save-btn btn btn-theme')); ?>        
    <?php $this->endWidget(); ?>
</div>