<?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'edit_invoice-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
?>
<ul class="clearfix form-ul material">
    <li class="col-sm-12">    
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php echo $form->textField($model, 'invoice_no', array('class' => 'tooltipster', 'data-label' => 'Invoice No <span style="color:red;">*</span> ')); ?>
    </li>      
</ul>  
<div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal" id="edit_pr_invoice_close">Close</button>
        <button type="button" class="btn btn-theme " onclick="updateinvoice();">Save</button>
</div>   
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("updateinvoice", "function updateinvoice() {
    jConfirm('Confirm Invoice Number Updation?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' : $('#edit_invoice-form').serialize(),
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('purchaseinvoice/updateinvoice') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Invoice Updated!');  
                            $('#edit_pr_invoice_close').click(); 
                            reloadTable('#tble_invoice'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error(''+val+''); 
                            }); 
                        }
                    }, 
                    'beforeSend':function(){
                        var invoice_no=$('#PurchasingInvoice_invoice_no').val(); 
                        if(invoice_no==''){
                            t8.error('Enter Invoice Number'); 
                            return false;
                        }else{
                            $('#loader').show();
                            return true;
                        }     
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 

};", CClientScript::POS_HEAD);
?>