<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteProject",  "function deleteProject(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=project/deleteProject',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    alert('Error while Delete', 'Alert');
                }else {
                    reloadTable('#tbl_project');
                    t8.success('Project Deleted SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

?>    <script>
    $(document).ready(function () {
        var table_id = "#tbl_project";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('project/getprojectlist') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                              if ( aData[6].status == "N" )  {  
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
    });
    function AddContextMenu(row, datas) {
        var id=datas[1];
        var mas_edit=0;
        var mas_disable=0;
        <?php if (isset(Yii::app()->user->havePermissionOn['mas_project_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['mas_project_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php } ?> 
        $(row).contextMenu({
            selector: 'td',

            items: {
                "edit": {
                    
                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("project/create&id=" + id, "Edit Project", "lg");
                    }, 
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
    			    }
                },

				"delete": {
                    
                      name: (datas[6].status == "Y") ?"Disable" : "Enable",
                    icon: "fa-trash-o",
                    accesskey: "d",
                    callback: function () {
                    	   Disable(datas[6].id, datas[6].status);
                    },
                    disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0'){
                                return !this.data('Disable_EnableDisabled'); 
                            }
			        }
                },

            }
        });
    }
</script>
<script>
    function Disable(id, status){
    var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
    if (r == true)
    {
    jQuery.ajax({
    'type'  : 'post',
            'datatype' :'json',
            'data'  : 'id=' + id + "&status=" + status,
            'url'  : $('#liveSite').val() + 'index.php?r=project/Disable',
            'cache': false,
            'success':function(data){
            if (data.status == 'fail'){
            t8.error('Error while Delete');
            } else {
            $('#tbl_project').DataTable().ajax.reload()
                    t8.success(' Success!');
            }
            }
    });
    }


    }
</script>
   <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-users"></i> Project
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('project/create','Add New Project','lg')"><i class="fa fa-plus"></i> ADD</button>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_project" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Project No</th>
                            <th>Project Name</th>
                            <th>Location</th>
                            <th>Project Date</th>
                            <th>Project Manager</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
