<style type="text/css">
    @media print {
        @page {
            margin-top: 4.2cm;
            margin-bottom: 4.4cm;
        }
    }
</style>
<!DOCTYPE html>
<html>

<head>
    <title>Goods Receipt</title>
</head>
<?php

$modelCompanySettings = new MasCompany();
$modelCompanySettings = $modelCompanySettings->find(array('condition' => 'id=' . (int) Yii::app()->user->master_user_company_id));
$no_of_decimals = $modelCompanySettings->no_of_decimals;

?>

<body>

    <div class="">
        <?php $this->renderPartial('//common/header'); ?>
        <div class="col-4">
            <?php
            $model_receipt = InventoryGoodsReceipt::model()->findByPk($id);

            ?>


            <div class="input-block">
                <b><?php echo $id; ?></b>
            </div>



        </div>
        <div class="col-4">
            <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 14px;">
                <?php echo "GOODS RECEIPT"; ?>
            </div>
        </div>
        <div class="col-4" style="color:#101010;">

            <table class="table" style="width:100%">

                <tr>
                    <td>Goods Receipt Date</td>
                    <?php $req_date = date("d/m/Y", strtotime($model_receipt->goods_receipt_date)); ?>
                    <td><?php echo $req_date; ?></td>
                </tr>

                <tr>
                    <td>Customer</td>

                    <td><?php echo $model_receipt->customer->customer_name; ?></td>
                </tr>
                <tr>
                    <td>Warehouse/Branch</td>

                    <td><?php echo $model_receipt->warehouse_det->warehouse_name; ?></td>
                </tr>

            </table>
        </div>
    </div>
    <br>
    <div class="col-md-12">


        <?php
        $model_receipt_items = InventoryGoodsReceiptItem::model()->with('unitdetails')->findAll(array('condition' => 't.goods_receipt_id = ' . $id));
        ?>
        <table id="tbl_enquiry_table" class="table table-fixed table-primary dataTable">
            <thead>
                <tr>
                    <th  style="width:4%">No</th>
                    <th style="width:15%">Product <?php //echo $no_of_decimals; ?></th>
                    <th style="width:25%">Description</th>
                    <th style="width:15%" >Serial No</th>
                    <th style="width:9%">Picked Qty</th>
                    <th style="width:6%" >Unit</th>
                    <th style="width:8%">Rate</th>
                    <th style="width:8%">Value</th>
                    <!-- <th>Warehouse</th> -->

                </tr>
            </thead>
            <tbody>
                <?php
                $m = 0;
                $totalValue = 0;

                foreach ($model_receipt_items as $i => $modelitems) {
                    $modelStockLedger = StockLedger::model()->find(array('condition' => 't.header_id = ' . $id . ' AND (transaction_from="INVENTORY_GOODS_RECEIPT" OR transaction_from="GOODS_RECEIPT") AND product_id=' . $modelitems->product_id));
                    $lineValue = $modelitems->rate * $modelitems->picked_qty;
                    $totalValue += $lineValue;
                    ?>
                    <tr>
                        <td><?php echo $i + 1; ?></td>
                        <td><?php echo $modelitems->product_name; ?></td>
                        <td><?php echo $modelitems->description; ?></td>
                        <td><?php echo $modelStockLedger->serial_no; ?></td>
                        <td class="text-right"><?php echo $modelitems->picked_qty; ?></td>
                        <td><?php echo $modelitems->unit_det->symbol; ?></td>
                        <td class="text-right">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($modelitems->rate, ""); ?>

                        </td>
                        <td class="text-right"><?php
                        $value = $modelitems->rate * $modelitems->picked_qty;
                        echo Yii::app()->numberFormatter->formatCurrency($value, ""); ?></td>
                    </tr>


                    <?php
                    $m = $i + 1;
                }
                ?>
                <tr style="font-weight: bold;">
                    <td colspan="7" class="text-right">Total</td>
                    <td class="text-right">
                        <?php echo Yii::app()->numberFormatter->formatCurrency($totalValue, ""); ?>
                    </td>
                    <!-- <td></td> -->
                </tr>
            </tbody>
        </table>

        <?php // }   ?>
    </div>
    <br>
    <?php /*if ($model_receipt->remarks != '') { ?>
        <div class="box" style="width: 100%">
            <h5>Remarks</h5>
            <div class="h12sub-details">
                <?php echo nl2br($model_receipt->remarks); ?>
            </div>
        </div>
    <?php }*/
    if ($model_receipt->notes != '') {
        ?>
        <div class="box" style="width: 100%">
            <h5>Notes</h5>
            <div class="h12sub-details">
                <?php echo nl2br($model_receipt->notes); ?>
            </div>
        </div>
    <?php }
   /* if ($model_receipt->terms_and_conditions != '') {
        ?>
        <div class="box" style="width: 100%">
            <h5>Terms and Conditions</h5>
            <div class="h12sub-details">
                <?php echo nl2br($model_receipt->terms_and_conditions); ?>
            </div>
        </div>
    <?php }*/
    if ($model_receipt->reference != '') {
        ?>
        <div class="box" style="width: 100%;font-size: 10px;">
            <h5>Reference</h5>
            <div class="h12sub-details">
                <?php echo nl2br($model_receipt->reference); ?>
            </div>
        </div>
    <?php } ?>
    <br>
    <?php $this->renderPartial("//common/footer"); ?>


</body>

</html>