<!DOCTYPE html>
<html>
<?php
$crm_login_company_id = Yii::app()->user->master_user_company_id;
$privillage_modal = new MasCompanySettings();
$privillage_condition = 'crm_company_id=' . $crm_login_company_id;
$privillage_count = $privillage_modal->count(array('condition' => $privillage_condition));
$privillage_settings_module = $privillage_modal->find();
$master_permission = $privillage_settings_module->permissions;
$master_permission_array = json_decode($master_permission, true);
?>

<head>
    <title>Production Order</title>
</head>

<body>
    <div style=" padding:34px;">   
    <?php
    $model = ProductionOrder::model()->findByPk($id);
    ?>
    <div class="">
        <?php $this->renderPartial("//common/header"); ?>
        <div class="col-4">
            <div class="input-block">
                <?php
                $year = date('y');
                // $formattedId = "RAM{$year}-PRO $model->id";
                $formattedId = $model->id;
                ?>
                <b><?php echo $formattedId; ?></b>
            </div>
            <br>
            <small><b>Part Number</b> : <?php echo $model->product->part_number; ?></small>
            <br>
            <small><b>Description</b> : <?php echo $model->description; ?></small>
        </div>

        <div class="col-4">
            <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 14px;">
                <?php echo "PRODUCTION ORDER"; ?>
            </div>
        </div>
        <div class="col-4" style="color:#101010;">
            <table class="table" style="width:100%">

                <tr>
                    <td>PO. Date</td>
                    <td>
                        <?php echo date('d/m/Y', STRTOTIME($model->productionorder_date)); ?>
                    </td>
                </tr>
                <tr>
                    <td>End Date</td>
                    <td>
                        <?php echo date('d/m/Y', STRTOTIME($model->end_date)); ?>
                    </td>
                </tr>
                <tr>
                    <td>Quantity</td>
                    <!-- <td>
                        <?php //echo number_format($model->quantity,0); ?>
                    </td> -->
                    <td><?php echo (int)$model->quantity; ?></td>
                </tr>
                <tr>
                    <td>Unit</td>
                    <td>
                        <?php echo $model->unitdetails->name; ?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <br>
    <div class="col-md-12">


        <table id="" class="table">
            <thead>
                <tr>
                    <th class="text-center bc-tl">No</th>
                    <th class="text-center">Part No</th>
                    <th class="text-center">Description</th>
                    <th class="text-center">Qty</th>
                    <th class="text-center">Unit</th>
                    <th class="text-center">Rate</th>
                    <th class="text-center">Amount</th>

                </tr>
            </thead>
            <tbody>

                <?php
                $m = 1;
                $condition .= '1=1';
                $condition .= ' AND t.production_order_id ="' . $id . '"';
                $total = 0;
                $model_items = ProductionOrderItem::model()->findAll(array('condition' => $condition));
                foreach ($model_items as $i => $model_items) {

                    ?>
                    <tr>
                        <td>
                            <?php echo $m++; ?>
                        </td>
                        <td>
                            <?php echo $model_items->product_name; ?>
                        </td>
                        <td>
                            <?php echo $model_items->description; ?>
                        </td>

                        <!-- <td class="text-right">
                            <?php
                            //echo number_format($model_items->quantity,0);
                            //echo number_format(,2); ?>
                        </td> -->
                        <td class="text-right"><?php echo (int)$model_items->quantity; ?></td>
                        <td>
                            <?php echo $model_items->unitdetails_mes->name; ?>
                        </td>
                        <td class="text-right">
                            <?php
                            $rate = Store::model()->findBypk($model_items->product_id)->rate;
                            echo number_format($rate, 2); ?>
                        </td>
                        <td class="text-right">
                            <?php
                            $total_cost = $model_items->quantity * $rate;
                            echo number_format($total_cost, 2);
                            $total += $total_cost;
                            ?>
                        </td>
                    </tr>

                    <?php

                } ?>

                <tr>
                    <td colspan="6"><b>Total Cost</b></td>
                    <td class="text-right"><b><?php echo number_format($total, 2); ?></b>
                    </td>
                </tr>


            </tbody>
        </table>

        <br />

        <?php
        $modelGoodsIssueItem = InventoryGoodsIssueItem::model()->with('inventorygoodsissue')->findAll(array('condition' => 'reference_id=' . $id));
        $modelGoodsReceiptItem = InventoryGoodsReceiptItem::model()->with('inventorygoodsreceipt')->findAll(array('condition' => 'reference_id=' . $id));

        /*echo '<pre>';
        print_r($modelGoodsIssueItem);*/

        /*echo '<pre>';
        print_r($modelGoodsReceiptItem);exit;*/

        ?>
        <div class="col-12 h5" style="margin-top: 0;margin-bottom: 0;text-align: left;font-size: 14px;">
            <b><?php echo "Goods Receipt"; ?></b>
        </div>
        <br />
        <table id="" class="table">
            <thead>
                <tr>
                    <th class="text-center bc-tl">No</th>
                    <th class="text-center bc-tl">Receipt#</th>
                    <th class="text-center">Part No</th>
                    <th class="text-center">Description</th>
                    <th class="text-center">Qty</th>
                    <th class="text-center">Unit</th>
                    <th class="text-center">Rate</th>
                    <th class="text-center">Amount</th>

                </tr>
            </thead>
            <tbody>
                <?php
                $gr = 1;
                $total_goods_receipt = 0;
                foreach ($modelGoodsReceiptItem as $eachReceiptItem) {

                    $receipt_rate = ($eachReceiptItem->picked_qty * $eachReceiptItem->rate);

                    $total_goods_receipt += $receipt_rate;
                    ?>
                    <tr>
                        <td><?php echo $gr; ?></td>
                        <td><?php echo $eachReceiptItem->inventory_goods_receipt_id; ?></td>
                        <td><?php echo $eachReceiptItem->product_name; ?></td>
                        <td><?php echo $eachReceiptItem->description; ?></td>
                        <td class="text-right"><?php echo number_format($eachReceiptItem->picked_qty,0); ?></td>
                        <td><?php echo $eachReceiptItem->unitdetails->name; ?></td>
                        <td class="text-right"><?php echo number_format($eachReceiptItem->rate, 2); ?></td>
                        <td class="text-right"><?php echo number_format($receipt_rate, 2); ?></td>
                    </tr>
                    <?php
                    $gr++;


                }
                ?>
                <tr>
                    <td colspan="7"><b>Total Cost</b></td>
                    <td class="text-right"><b><?php echo number_format($total_goods_receipt, 2); ?></b>
                    </td>
                </tr>
            </tbody>


        </table>

        <br />

        <div class="h5" style="margin-top: 0;margin-bottom: 0;text-align: left;font-size: 14px;">
            <b><?php echo "Goods Issue"; ?></b>
        </div>
        <br />
        <table id="" class="table">
            <thead>
                <tr>
                    <th class="text-center bc-tl">No</th>
                    <th class="text-center bc-tl">Issue#</th>
                    <th class="text-center">Part No</th>
                    <th class="text-center">Description</th>
                    <th class="text-center">Qty</th>
                    <th class="text-center">Unit</th>
                    <th class="text-center">Rate</th>
                    <th class="text-center">Amount</th>

                </tr>
            </thead>
            <tbody>
                <?php
                $gi = 1;
                $total_goods_issue = 0;
                foreach ($modelGoodsIssueItem as $eachIssueItem) {

                    $goods_issue_rate = ($eachIssueItem->picked_qty * $eachIssueItem->rate);

                    $total_goods_issue += $goods_issue_rate;
                    ?>
                    <tr>
                        <td><?php echo $gi; ?></td>
                        <td><?php echo $eachIssueItem->inventory_goods_issue_id; ?></td>
                        <td><?php echo $eachIssueItem->product_name; ?></td>
                        <td><?php echo $eachIssueItem->description; ?></td>
                        <td class="text-right"><?php echo number_format($eachIssueItem->picked_qty,0); ?></td>
                        <td><?php echo $eachIssueItem->uom->name; ?></td>
                        <td class="text-right"><?php echo number_format($eachIssueItem->rate, 2); ?></td>
                        <td class="text-right"><?php echo number_format($goods_issue_rate, 2); ?></td>
                    </tr>
                    <?php
                    $gi++;


                }
                ?>
                <tr>
                    <td colspan="7"><b>Total Cost</b></td>
                    <td class="text-right"><b><?php echo number_format($total_goods_issue, 2); ?></b>
                    </td>
                </tr>
            </tbody>


        </table>

    </div>
     <?php $this->renderPartial("//common/footer");?>

<!--     <htmlpagefooter name="myfooter">

        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
            <?php
            date_default_timezone_set("Asia/Dubai");
            echo date('d/m/Y') . " " . date("h:i:sa"); ?>
        </div>


        <div
            style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
            <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter> -->
          </div>
</body>

</html>