<!DOCTYPE html>
<html>
<head>
    <title>Service Report</title>
</head>
<body>
<div style="padding:34px;">
    <?php $this->renderPartial("//common/header"); ?>

    <div class="row">
        <div class="col-4">
            <div class="input-block">
                <b><?php
                    $vehicleType = '';
                    if ($model->vehicle) {
                        $vehicleType = $model->vehicle->vehicle_make . ' ' . $model->vehicle->vehicle_model;
                    }
                    echo !empty($vehicleType) ? $vehicleType : '-';
                    ?></b>
            </div>
            <br>
        </div>

        <div class="col-4">
            <div class="h3" style="margin:0;text-align:center;font-size:14px;">
                <?php echo "SERVICE REPORT"; ?>
            </div>
        </div>

        <div class="col-4">
            <table class="table" style="width:100%">
                <tr>
                    <td>Planned Date</td>
                    <td><?php echo !empty($model->planned_date) && $model->planned_date != '0000-00-00 00:00:00'
                    ? date('d/m/Y h:i A', strtotime($model->planned_date))
                    : '-'; ?>
                    </td>
                </tr>
                <tr>
                    <td>Garage</td>
                    <td><?php echo $model->garage_name; ?></td>
                </tr>
                <tr>
                    <td>Odometer</td>
                    <td><?php echo $model->odometer_reading; ?></td>
                </tr>
                <tr>
                    <td>Service Status</td>
                    <td>
                        <?php 
                        $statuses = MasVehicleServiceStatus::getServiceStatuses();
                        echo (!empty($model->service_status) && isset($statuses[$model->service_status])) 
                            ? $statuses[$model->service_status] 
                            : '-';
                        ?>
                    </td>
                </tr>

                <tr>
    <td>Scheduled Date</td>
    <td>
        <?php echo !empty($model->sheduled_date_time) && $model->sheduled_date_time != '0000-00-00 00:00:00'
            ? date('d/m/Y h:i A', strtotime($model->sheduled_date_time))
            : '-'; ?>
    </td>
</tr>
                <tr>
                    <td>Estimated Cost</td>
                    <td><?php echo number_format($model->estimated_cost, 2); ?></td>
                </tr>
            </table>
        </div>
    </div>

    <br>

    <!-- Service Details -->
    <div class="col-md-12">
        <table class="table" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center" style="width:50px;">Sl. No</th>
                    <th class="text-center">Maintenance Type</th>
                    <th class="text-center">Service Notes</th>
                    <th class="text-center">Cost</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $i = 1; 
                $total = 0;
                foreach ($model_details as $item) { 
                    $total += $item->service_cost;
                ?>
                    <tr>
                        <td class="text-center"><?php echo $i++; ?></td>
                        <td>
                            <?php 
                            $types = MasMaintainance::getMaintainanceTypes();
                            echo (!empty($item->maintainance_master_id) && isset($types[$item->maintainance_master_id])) 
                                ? $types[$item->maintainance_master_id] 
                                : '-';
                            ?>
                        </td>
                        <td><?php echo $item->service_notes; ?></td>
                        <td class="text-right"><?php echo number_format($item->service_cost, 2); ?></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="3" style="text-align:right;font-weight:bold;">Total</td>
                    <td class="text-right" style="font-weight:bold;">
                        <?php echo number_format($total, 2); ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <?php $this->renderPartial("//common/footer"); ?>
</div>
</body>
</html>
