<!DOCTYPE html>
<html>
    <head>
        <title>Order List</title>
        <style>
            .table_box {
                border-collapse:separate!important;
                margin-top: 10px;
                padding: 10px;
                font-size:16px!important;
                border: 1px solid #0066ff;
                border-radius:6px;
            }
        </style>
    </head>

    <body>
        <div class="">
            <?php $this->renderPartial("//common/header"); ?>
            <div class="col-4">
                <br>
                <?php
                $model = Order::model()->findByPk($id);
                ?>
                <div class="input-block">
                    <b><?php echo $id; ?></b>
                </div>
                <b><?php echo strtoupper($model->customer->customer_name); ?></b><br>
                <?php if ($model->billing_address != '') { ?>
                    <small><?php echo strtoupper(nl2br($model->billing_address)); ?></small><br>
                <?php } ?>
                <?php if ($model->customer->customer_phone_no != '') { ?>
                    <small>Phone : <?php echo strtoupper($model->customer->customer_phone_no); ?></small><br>
                <?php } ?>
                <?php if ($model->customercontact->person_name != '') { ?>
                    <br><small>Kind Attn:</small>
                    <small><b><?php echo strtoupper($model->customercontact->person_name); ?></b></small><br>
                <?php } ?>
            </div>
            <div class="col-4">
                <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;font-size: 14px;">
                    <?php echo "ORDER"; ?>
                </div>
            </div>
            <div class="col-4" style="color:#101010;">
                <br>
                <table class="table" style="width:100%">
                    <tr>
                        <?php
                        $modelOrder = Order::model()->findByPk($id);
                        $model_lead = Lead::model()->find(array('condition' => 'file_id="' . $modelOrder->file_id . '"'));
                        ?>
                        <td class="bc-tl">File ID</td>
                        <td>
                            <?php echo $modelOrder->file_id; ?>
                        </td>
                    </tr>
                   
                    <tr>
                        <td>Customer ID</td>
                        <td>
                            <?php echo $modelOrder->customer_id; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Customer TRN#</td>
                        <td>
                            <?php echo $modelOrder->customer->customer_trn_no; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Order Date</td>
                        <td>
                            <?php echo date('d/m/Y', STRTOTIME($modelOrder->order_date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Delivery Date</td>
                        <td>
                            <?php echo date('d/m/Y', STRTOTIME($modelOrder->delivery_date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>LPO</td>
                        <td>
                            <?php echo $model->lpo; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Payment Terms</td>
                        <td>
                            <?php echo $modelOrder->paymentTerm->payment_terms; ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width:40%">Inco Terms</td>
                        <td>
                            <?php echo $modelOrder->incoterm->inco_name; ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <?php echo $model->leadowner->first_name . ' ' . $model->leadowner->last_name . ' , ' . $model->leadowner->phno; ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <br>
        <div class="col-md-12">
            <table id="" class="table">
                <thead>
                    <tr>
                        <th class="text-center bc-tl">No</th>
                        <th class="text-center" style="width:15%">Part No</th>
                        <th class="text-center" style="width:30%">Description</th>
                        <?php
                        $colspqn = "8";
                        if (isset($master_permission_array['inventory_image_show_order'])) {
                            $colspqn = $colspqn + 1;
                            ?>
                            <th class="text-center">Image</th>
                        <?php } ?>
                        <th class="text-center">Qty</th>
                        <?php
                        if ($bonus_quantity == "Y") {
                            $colspqn = $colspqn + 1;
                            ?>
                            <th class="text-center">Bonus Qty</th>
                        <?php } ?>
                        <th class="text-center">Unit</th>
                        <!--<th>Sys Rate</th>-->
                        <!--<th >Disc.</th>-->
                        <th class="text-center">Rate</th>
                        <th class="text-center">Total</th>
                        <!-- <th class="text-center">Tax(%)</th> -->
                        <th class="text-center" style="width:10%">Tax Amt</th>
                        <th class="text-center bc-tr">Net Amt</th>
                    </tr>
                </thead>
                <tbody>

                    <?php
                    $m = 1;
                    $condition .= '1=1';
                    $condition .= ' AND t.order_id ="' . $id . '"';
                    $total = 0;

                    $total_cbm = 0;
                    $total_weight = 0;
                    $invoice = OrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
                    foreach ($invoice as $i => $invoice) {

                        /* if($invoice->product->inventory_type == '2'){
                          ?>
                          <tr style="background: red;">
                          <td colspan=<?php echo $colspqn; ?>><?php echo $invoice->description;?></td>
                          </tr>

                          <?php
                          }
                          else */if ($invoice->product->inventory_item_type == 3) {
                            ?>
                            <tr style="background-color: #d0f5c5; color: white;"><td colspan="<?= $colspqn + 1 ?>"><b><?php echo $invoice->description; ?></b></td></tr>
                            <?php
                        } else {
                            ?>
                            <tr>
                                <td>
                                    <?php echo $m; ?>
                                </td>
                                <td>
                                    <?php echo $invoice->product->part_number; ?>
                                </td>
                                <td>
                                    <?php echo nl2br($invoice->description); ?>
                                </td>
                                <?php if (isset($master_permission_array['inventory_image_show_order'])) { ?>
                                    <td>
                                        <?php if ($invoice->product->item_image != '') { ?>
                                            <img src="<?php echo Yii::app()->baseUrl . '/uploads/inventoryimages/' . $invoice->product->item_image; ?>">
                                        <?php } ?>
                                    </td>
                                <?php } ?>
                                <td class="text-right">
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($invoice->quantity, " "); ?>
                                </td>
                                <?php if ($bonus_quantity == "Y") { ?>
                                    <td class="text-right">
                                        <?php echo Yii::app()->numberFormatter->formatCurrency($invoice->bonus_qty, " "); ?>
                                    </td>
                                <?php } ?>
                                <td>
                                    <?php echo $invoice->orderunit->name; ?>
                                </td>
        <!--                                <td class="text-right">
                                <?php //echo Yii::app()->numberFormatter->formatCurrency($invoice->rate, " "); ?>
                                </td>
                                <td class="text-right">
                                <?php //echo Yii::app()->numberFormatter->formatCurrency($invoice->deduction_amount, " "); ?>
                                </td>-->
                                <?php
                                // $rate=($invoice->amount+$invoice->addition_amount)/$invoice->quantity;
                                $after_discount = $invoice->rate - $invoice->deduction_amount;
                                ?>
                                <td class="text-right">
                                    <?php
                                    echo Yii::app()->numberFormatter->formatCurrency($after_discount, " ");
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    $total_after_discount = $after_discount * $invoice->quantity;
                                    echo Yii::app()->numberFormatter->formatCurrency($total_after_discount, " ");
                                    ?>
                                </td>

                                                                                                 <!-- <td class="text-right"> -->
                                <!--// $invoice->tax_vat_amount.' ('.$invoice->tax_vat_percentage.'%)' -->
                                <?php // $invoice->tax_vat_percentage.'%'  ?>
                                <!-- </td> -->
                                <td class="text-right">
                                    <?php
                                    $taxamount = $invoice->tax_vat_amount;
                                    echo $taxamount;
                                    ?>
                                </td>

                                <td class="text-right">
                                    <?php
                                    $net_amount = $invoice->net_amount + $invoice->tax_vat_amount;
                                    echo Yii::app()->numberFormatter->formatCurrency($net_amount, " ");
                                    ?>

                                </td>
                            </tr>

                            <?php
                            if ($invoice->orderunit->name == 'Carton') {

                                $item_cbm = $invoice->product->cubic_meter;
                                $item_weight = $invoice->product->weight;
                                $total_cbm += ($invoice->quantity * $item_cbm);
                                $total_weight += ($invoice->quantity * $item_weight);
                            }
                            $m = $m + 1;
                            $total += $invoice->net_amount;
                        }
                    }
                    ?>
                    <?php if ($modelOrder->total_tax_amount > 0) : ?>
                        <tr>
                            <td class="text-right" colspan=<?php echo $colspqn; ?>><b>Total</b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b></td>
                        </tr>
                        <tr>
                            <td class="text-right" colspan=<?php echo $colspqn; ?>><b>VAT</b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($modelOrder->total_tax_amount, " "); ?></b></td>
                        </tr>
                    <?php endif; ?>

                    <?php
                    $Addition = OrderAddition::model()->findAll(array('condition' => 'order_id=' . $modelOrder->id . ' AND calculated_value>0'));
                    $Dedution = OrderDeduction::model()->findAll(array('condition' => 'order_id=' . $modelOrder->id . ' AND calculated_value>0'));
                    if (!empty($Addition)) {
                        foreach ($Addition as $eachAddition) {
                            ?>
                            <tr>
                                <?php
                                $total += $eachAddition->calculated_value;
                                ?>
                                <td class="text-right" colspan=<?php echo $colspqn; ?>>
                                    <?php
                                    echo MasFooterItems::getFooterItemName($eachAddition->particular);
                                    ?>
                                </td>
                                <td class="text-right">+
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($eachAddition->calculated_value, " "); ?>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                    if (!empty($Dedution)) {
                        foreach ($Dedution as $eachDed) {
                            ?>
                            <tr>
                                <?php
                                $total -= $eachDed->calculated_value;
                                ?>
                                <td class="text-right" colspan=<?php echo $colspqn; ?>>
                                    <?php
                                    echo MasFooterItems::getFooterItemName($eachDed->particular);
                                    ?>
                                </td>
                                <td class="text-right">-
                                    <?php echo Yii::app()->numberFormatter->formatCurrency($eachDed->calculated_value, " "); ?>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                    ?>
                    <tr>
                        <td class="text-right total bc-bl" colspan=<?php echo $colspqn; ?>><b>Grand Total</b></td>
                        <!--<td></td>-->
                        <?php $total += $modelOrder->total_tax_amount; ?>
                        <td class="text-right total bc-br"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan=<?php echo $colspqn + 1; ?>>
                            <b>
                                <?php
                                $fcurrency = new MasCurrency();
                                ?>
                                <?php
                                if ($total > 0) {
                                    echo $fcurrency->number_to_currency(number_format(($total), 2, '.', ''), $modelOrder->currency_id);
                                } else {
                                    echo "FOC(Free Of Cost)";
                                }
                                ?>
                            </b>
                        </td>
                    </tr>

                </tbody>
            </table>

        </div>
        <!--
        <div class="box" style="width:100%">
                <h5>Please ensure that all items are quoted in Carton</h5>
                <div class="h5sub-details" style="font-size: 10px;">Total CBM : <b><?php //echo $total_cbm;         ?> </b>CBM</div>
                <div class="h5sub-details" style="font-size: 10px;">Total Weight : <b><?php //echo $total_weight;         ?> </b>KG</div>

        </div>-->

        <?php
        if ($modelOrder->terms_and_conditions != '') {
            ?>
            <div class="box" style="width:100%">    <h5>Terms and Conditions</h5>
                <div class="h5sub-details" style="font-size: 10px;">
                    <?php echo nl2br($modelOrder->terms_and_conditions); ?>
                </div>
            </div>
            <?php
        }

        if ($modelOrder->notes != '') {
            ?>
            <div class="box" style="width:100%">    <h5>Notes</h5>
                <div class="h5sub-details" style="font-size: 10px;">
                    <?php echo nl2br($modelOrder->notes); ?>
                </div>
            </div>
        <?php } ?>
        
        <?php $this->renderPartial("//common/footer", array('company_id' => $company_id)); ?>



    </body>

</html>
