<!DOCTYPE html>
<html>

<head>
    <title>Service Agreement</title>
    <style>
        /* ---------------- GLOBAL STYLES ---------------- */
        body {
            
            font-size: 13px;
            color: #000;
            margin: 0;
            padding: 0;
            line-height: 1.5;
        }

        @page {
            margin: 2cm 1.8cm 2.5cm 1.8cm;
        }

        /* ---------------- HEADER ---------------- */
        .header {
            width: 100%;
            text-align: left;
            padding-bottom: 10px;
            border-bottom: 2px solid #36761b;
        }

        .header img {
            height: 80px;
            width: auto;
        }

        /* ---------------- TITLE ---------------- */
        .doc-title {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            letter-spacing: 1px;
            color: #000;
            text-transform: uppercase;
            margin: 10px 0 15px 0;
        }

        /* ---------------- TABLE STYLING ---------------- */
        table {
            border-collapse: collapse;
            width: 100%;
            font-size: 13px;
            margin-top: 8px;
        }

        th, td {
            border: 1px solid #000;
            padding: 6px 8px;
        }

        th {
            background-color: #36761b;
            text-align: left;
            font-weight: bold;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #fafafa;
        }

        /* ---------------- SECTION HEADERS ---------------- */
        h4 {
            font-size: 14px;
            color: #36761b;
            text-decoration: none;
            margin-bottom: 4px;
            margin-top: 15px;
        }

        ol, ul {
            padding-left: 20px;
            margin-top: 5px;
            margin-bottom: 10px;
        }

        li {
            padding: 4px 0;
            text-align: justify;
        }

        p {
            margin-bottom: 8px;
            text-align: justify;
        }

        /* ---------------- SIGNATURE BLOCK ---------------- */
        .signature-block {
            width: 100%;
            display: flex;
            margin-top: 40px;
        }

        .signature-block div {
            width: 50%;
            padding: 0 10px;
        }

        .signature-left {
            text-align: left;
        }

        .signature-right {
            text-align: right;
        }

        .signature-line {
            display: block;
            margin: 8px 0;
            border-bottom: 1px dotted #000;
            width: 80%;
        }

        /* ---------------- FOOTER ---------------- */
        htmlpagefooter {
            width: 100%;
        }

    /*    .footer {
            border-top: 1px dotted #000;
            font-size: 11px;
            text-align: center;
            padding-top: 8px;
            background-color: #eef7ff;
            margin-top: 20px;
        }

        .footer b {
            display: block;
        }

        .page-number {
            text-align: center;
            margin-top: 5px;
        }*/

        /* ---------------- PRINT ---------------- */
        @media print {
            body {
                color: #000;
            }

            .header img {
                max-height: 70px;
            }

    

            a {
                color: #000;
                text-decoration: none;
            }
        }
          .signature-block {
        width: 100%;
        display: flex;
        justify-content: space-between;
        margin-top: 50px;
    }

    .signature-side {
        width: 48%;
        font-size: 13px;
        line-height: 1.6;
    }

    .signature-side p {
        margin: 5px 0;
    }

    .signature-line {
        display: block;
        width: 90%;
        height: 1px;
        border-bottom: 1px dotted #000;
        margin: 30px 0 10px 0; /* Adjust spacing between signature lines */
    }

    .signature-label {
        font-style: italic;
        color: #333;
    }

    .signature-side.right {
        text-align: right;
    }

    /* Ensure print clarity */
    @media print {
        .signature-line {
            border-bottom: 1px solid #000;
        }
    }
       .contract-summary {
        width: 100%;
        border: 1px solid #36761b;
        border-radius: 6px;
        background-color: #f8fbff;
        padding: 12px 18px;
        margin: 15px 0 20px 0;
        font-size: 13px;
    }
    .contract-details th
    {
        background-color: #e8fdec;
        color: #36761b;
    }

    .contract-summary h5 {
        text-align: left;
        font-size: 14px;
        font-weight: bold;
        color: #36761b;
        text-transform: uppercase;
        margin-bottom: 10px;
        border-bottom: 1px solid #c6d9ff;
        padding-bottom: 5px;
    }

    .contract-summary ul {
        list-style-type: none;
        padding: 0;
        margin: 0;
    }

    .contract-summary li {
        padding: 6px 0;
        border-bottom: 1px dotted #36761b;
    }

    .contract-summary li:last-child {
        border-bottom: none;
    }

    .contract-summary b {
        color: #000;
    }

    @media print {
        .contract-summary {
            border: 1px solid #000;
            background: none;
        }
    }
    </style>
</head>

<body>
    <?php
    $modelOrder = Order::model()->findByPk($id);
    $logo_name = isset(Yii::app()->user->pdf_company_logo) ? Yii::app()->user->pdf_company_logo : "pdf_logo.png";
    ?>

    <div class="header">
        <img src="images/logo/<?php echo $logo_name ?>" alt="Company Logo" style="width: 20%;">
    </div>

    <div class="doc-title">
        <?php echo 'SERVICE AGREEMENT'; ?>
    </div>

    <div class="content">

        <p>AGREEMENT NO – <b>CRL/CA/<?php echo $modelOrder->id; ?></b></p>
        <p>THIS AGREEMENT IS DATED <b><?php echo date('d/m/Y', strtotime($modelOrder->order_date)); ?></b>
            <?php if ($modelOrder->id > 0) { ?> from the Quotation : <b><?php echo $modelOrder->id; ?></b><?php } ?>
        </p>

        <p>BETWEEN <b>__________</b>, a company incorporated in the United Arab Emirates (UAE) and whose principal address is <b>__________</b> (referred to as the “Company”)<br><br>
            AND<br><br>
            <b><?php echo strtoupper($modelOrder->customer->customer_name); ?></b>, a company incorporated in the United Arab Emirates (UAE) and whose principal address is <b><?php echo $modelOrder->billing_address; ?></b> (referred to as the “Client”).<br><br>
            WHEREAS, The Company has entered into an Agreement (“Service Agreement”) with The Client to provide Scent Diffuser Equipment Service including installation of Scent Diffuser Equipment at the locations of the Client’s premises.
        </p>

        <p><b>Now therefore it is agreed as follows:</b></p>

        <h4>1. DEFINITIONS</h4>
        <ol>
            <li>“Equipment” means Scent Diffuser Machine known as the oil diffuser required to produce scent smell in the area where the machine is installed.</li>
            <li>“Commencement Date” means the date on which this Agreement is duly signed and executed by the Parties.</li>
        </ol>

        <h4>2. TERMS OF ENGAGEMENT</h4>
        <ol>
            <li>The Client shall submit copies of Trade License, Tax Registration Certificate, and authorized signatory details to the Company, and update any changes on time.</li>
            <li>This Agreement takes effect from the Commencement Date and continues until completion of the project unless terminated earlier.</li>
            <li>The Company agrees to rent equipment to the client for the rental period and the Client agrees to pay the rental fee as per the pricelist and conditions herein.</li>
            <li>The Company will install the complete system in presence of the Client’s authorized representative, who will acknowledge the installation.</li>
            <li>The Client shall ensure no damage occurs to the equipment and compensate the Company for any damage or loss during the contract period.</li>
            <li>The Client shall select fragrance oil from the Company’s samples and request any change at least one month in advance.</li>
            <li>Installation, removal, service, repair, or modification of the equipment shall be done only by the Company unless written consent is given otherwise.</li>
        </ol>

        <h4>3. BILLING AND PAYMENTS</h4>
        <ol>
            <li>The Company will submit invoices monthly, and the Client shall settle payments via cash, bank transfer, or cheque within the agreed period.</li>
            <li>Changes in credit terms require a new credit application with supporting documents.</li>
        </ol>

        <h4>4. DISPUTE RESOLUTION</h4>
        <ol>
            <li>Any dispute shall first be resolved amicably. If unresolved within 15 days of written notice, the dispute shall be referred to DUBAI COURTS.</li>
        </ol>

        <h4>5. TERMINATION OF CONTRACT</h4>
        <ol>
            <li>Either party may terminate this agreement with 30 days’ written notice.</li>
            <li>The Client shall pay all dues and return all equipment upon termination.</li>
        </ol>

        <h4>6. EQUIPMENT, CONTRACT PERIOD, RENTAL & PAYMENT TERMS</h4>

        <table>
            <tr>
                <th>Sl</th>
                <th>Machine</th>
                <th>Quantity</th>
                <th>Amount</th>
                <th>Total AED (VAT Excl.)</th>
            </tr>
            <?php
            $m = 1;
            $condition .= 'order_id ="' . $id . '"';
            $grand_total = 0;
            $modelOrderOrderItem = OrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            foreach ($modelOrderOrderItem as $i => $eachItem) {
                $rate = ($eachItem->amount + $eachItem->addition_amount) / $eachItem->quantity;
            ?>
                <tr>
                    <td><?php echo $m; ?></td>
                    <td><?php echo nl2br($eachItem->description); ?></td>
                    <td style="text-align:right;"><?php echo $eachItem->quantity; ?></td>
                    <td style="text-align:right;"><?php echo Yii::app()->numberFormatter->formatCurrency($rate, " "); ?></td>
                    <td style="text-align:right;"><?php echo Yii::app()->numberFormatter->formatCurrency(($rate * $eachItem->quantity), " "); ?></td>
                </tr>
            <?php
                $m++;
                $grand_total += ($rate * $eachItem->quantity);
            } ?>
        </table>

   <div class="contract-summary">
    <h5>Contract Summary</h5>
<table class="contract-details">
    <tr>
        <th>Contract Period:</th>
        <td>
            <?php echo date('d/m/Y', strtotime($modelOrder->contract_start_date)); ?>
            &nbsp;to&nbsp;
            <b><?php echo date('d/m/Y', strtotime($modelOrder->contract_end_date)); ?></b>
        </td>
    </tr>
    <tr>
        <th>Total Monthly Rental (AED):</th>
        <td>
            <b><?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " "); ?></b>
            &nbsp;<span>(VAT Exclusive)</span>
        </td>
    </tr>
    <tr>
        <th>Payment Terms:</th>
        <td><b><?php echo $modelOrder->paymentTerm->paymentTerm; ?></b></td>
    </tr>
</table>
</div>

<p>Executed as an agreement:</p>
<div style="width:100%;display: flex;">
    <div style="width:50%;float: left;">

        <p>For &nbsp;<?php echo strtoupper($modelOrder->customer->customer_name);?>   </p>   
        <p>.....................................................   </p>
        <p>(Signature & Company Stamp)   </p>   
        <p>.....................................................<br>Name & Position in the company   </p>                                           
    </div>

    <div style="width:50%;float: right;">

        <p style="text-align:right;margin-right: 60px;">For   Coral Concepts LLC  </p>  
        <p style="text-align:right;">.....................................................    </p>
         <p style="text-align:right;margin-right: 20px;">(Signature & Company Stamp)                                                                                                  </p>
         <p style="text-align:right;">.....................................................<br>Name & Position in the company    </p>
   
    </div>
</div> 
    </div>

    <br>
    <htmlpagefooter name="myfooter">
        <div style="text-align:center;width:100%;font-size:10px">
            <?php /*
date_default_timezone_set("Asia/Dubai");
echo date('d/m/Y') . " " . date("h:i:sa");*/
            ?>
        </div>
        <div
            style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
            <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />


    <!-- <style type="text/css">
    div { page-break-inside:auto;
          page-break-inside:avoid; 
          page-break-after:auto;

    }

</style> -->
</body>
</html>
