<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Invoice</title>

    <?php
    // function numberToWords($num) {
//     $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
//     return strtoupper($f->format($num));
// }
    function numberToWords($amount)
    {
        $formatter = new NumberFormatter("en", NumberFormatter::SPELLOUT);

        $amount = number_format($amount, 2, '.', '');
        list($integer, $decimal) = explode('.', $amount);

        $integerWords = strtoupper($formatter->format((int) $integer));

        $result = '' . $integerWords . '';

        if ((int) $decimal > 0) {
            $decimalWords = strtoupper($formatter->format((int) $decimal));
            $result .= ' AND ' . $decimalWords . ' FILS';
        }

        return $result . '';
    }


    if (isset(Yii::app()->user->master_user_company_id) && (int) Yii::app()->user->master_user_company_id > 0) {
        $company_id = Yii::app()->user->master_user_company_id;
    }


    $mpdf->use_kwt = true;

    $modelInvoice = Invoice::model()->findByPk($id);

    $modelMasInvoiceType = MasInvoiceType::model()->findByPk($modelInvoice->invoice_type);

    $margintop = "10 cm";
    if (strlen($modelInvoice->customer->customer_name) > 25) {
        $margintop = "11 cm";
    }

    $SQL = "SELECT SUM(deduction_amount) FROM erp_invoice_item WHERE invoice_id=" . (int) $id;
    $total_discount = (float) Yii::app()->db->createCommand($SQL)->queryScalar();
    ?>
    <style>
        body {

            margin: 0;
            padding: 0;
        }

        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0 5px 0;
            border-bottom: 5px solid #000;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo img {
            height: 60px;
        }

        .logo-text {
            font-size: 22px;
            font-weight: bold;
            line-height: 1.2;
        }

        .logo-subtext {
            font-size: 14px;
            letter-spacing: 1px;
        }

        .invoice-title {
            text-align: right;
            margin-bottom: 0px;
        }

        .invoice-title h2 {
            font-size: 20px;
            margin: 0;
            font-weight: bold;
            margin-bottom: 0px;
            margin-top: 10px;
        }

        .invoice-title p {
            font-size: 20px;
            margin: 0;
            margin-top: 5px;
        }

        .invoice-box {
            max-width: 900px;
            margin: auto;

            line-height: 20px;
            font-size: 11px;
        }

        .invoice-box table {
            width: 100%;
            border-collapse: collapse;
        }

        .invoice-box table td {
            padding: 4px 0px;
            vertical-align: top;
        }

        h2 {
            margin-bottom: 0;
            font-size: 15px;
            font-weight: 600;
        }

        .small-text {
            font-size: 13px;
            color: #555;
        }

        .top-section {
            display: flex;
            justify-content: space-between;
        }

        table th {
            background: #c0c0c0 !important;
            color: black !important;
        }

        table.details td {
            padding: 3px 0px;
            font-size: 11px;
        }

        .table-header {
            background: #c0c0c0;
            font-weight: bold;
            border-top: 1px solid #bbb;
            border-bottom: 1px solid #bbb;
            text-align: center;
            color: black;
        }

        .item-table td,
        .item-table th {
            border-bottom: 1px solid #ddd;
            padding: 8px;
            font-size: 15px;
        }

        .right-align {
            text-align: right;
        }

        .total-box {
            margin-top: 15px;
        }

        .total-box table td {
            padding: 3px 0px;
        }

        hr {
            border: 0;
            border-top: 1px solid #ccc;
            margin: 15px 0;
        }

        .remarks {
            font-size: 11px;
            color: #444;
        }

        .tax-details {

            margin-top: 10px;
            padding-top: 8px;
        }

        .footer {
            margin-top: 15px;
            font-size: 11px;
        }

        .bold {
            font-weight: bold;
        }

        .details-table td {

            border: none;
        }
    </style>
    <?php
    if (isset(Yii::app()->user->pdf_company_logo)) {
        $logo_name = Yii::app()->user->pdf_company_logo;
    } else {
        $logo_name = "logo.png";
    }
    $modelInvoice = Invoice::model()->findByPk($id);

    $warehouse_id = $modelInvoice->warehouse_id;

    $modelCompanySettings = new MasCompanySettings();
    $modelCompanySettings = $modelCompanySettings->find(array('condition' => 'crm_company_id=' . (int) Yii::app()->user->master_user_company_id));
    if (!empty($modelCompanySettings->print_template_logo)) {
        $pdf_logo = $modelCompanySettings->print_template_logo;
    } else {
        $pdf_logo = Yii::app()->user->company_logo;
    }
    ?>
</head>

<body>

    <div class="invoice-header">
        <div class="logo" style="width: 20%;float: left;">
            <img src="<?php echo Yii::app()->baseUrl . '/uploads/logo/' . $pdf_logo; ?>" class="logo">
        </div>

        <div class="invoice-title" style="width: 80%;float: right;">
            <h2>TAX INVOICE</h2>
            <p>فاتورة ضريبية</p>
        </div>
    </div>

    <div class="invoice-box">
        <div class="top-section">
            <div style="width:48%;float:left;">
                <?php
                $invoice_type = $modelInvoice->invoice_type;
                $invoice_no = $modelInvoice->invoice_no;
                $invoice_type_name = "";
                if ((int) $invoice_type > 0) {
                    $modelInvoiceType = new MasInvoiceType();
                    $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);
                    $inv_code = $arr_invoice_type_details->inv_code;

                    //  $invoice_no = $inv_code . '-' . $invoice_no;
                    $invoice_type_name = $arr_invoice_type_details->inv_name;
                }
                ?>
                <p><strong>Customer :</strong> <?php echo ($modelInvoice->customer->customer_name); ?></p>
                <?php if ($modelInvoice->customer->customer_address != '') { ?>
                    <p><strong><?php echo strtoupper(nl2br($modelInvoice->customer->customer_address)); ?></strong></p>
                <?php } ?>
                <p style="border-bottom:2px dotted grey;"></p>
                <p><strong>BILL TO :</strong><br>
                    <?php echo strtoupper(nl2br($modelInvoice->customer->shippingdetails->street_address)); ?>
                </p>
                <?php
                $modelInvoice = Invoice::model()->findByPk($id);
                $model_lead = Lead::model()->find(array('condition' => 'file_id="' . $modelInvoice->file_id . '"'));
                ?>
                <table class="details-table" style=" font-size: 11px;">

                    <tr>
                        <td><strong>TRN-CUSTOMER </strong></td>
                        <td>: </td>
                        <td><?php echo $modelInvoice->customer->customer_trn_no; ?></td>
                    </tr>
                    <tr>
                        <td><strong>YOUR REFERENCE</strong></td>
                        <td>:</td>
                        <td><?php echo $modelInvoice->reference; ?></td>

                    </tr>
                    <tr>
                        <td><strong>SALES PERSON </strong></td>
                        <td>:</td>
                        <td><?php echo strtoupper($modelInvoice->contact->person_name); ?></td>
                    </tr>
                </table>
                <p style="border-bottom:2px dotted grey;"></p>
            </div>
            <div style="width:48%;float:right;">
                <p><strong>TRN :</strong> <?php echo $modelInvoice->customer->customer_trn_no; ?></p>
                <p style="border-bottom:2px dotted grey;"></p>


                <table class="doc-table" style="width:100%; border-collapse:collapse;font-size: 11px;">
                    <tr>
                        <td>DOCUMENT DATE
                            <strong><?php echo date('d/m/Y', STRTOTIME($modelInvoice->invoice_date)); ?></strong>
                        </td>
                        <!-- <td>DUE DATE<strong> </strong></td> -->
                        <td>TAX INVOICE NO <strong><?php echo $modelInvoice->invoice_no; ?></strong></td>
                    </tr>
                </table>
                <p style="border-bottom:2px dotted grey;"></p>

                <p><strong>SHIP TO :</strong><br>
                    <?php echo strtoupper(nl2br($modelInvoice->customer->customer_address)); ?></p>
                <?php
                if ($modelInvoice->payment_terms_id != 0) {
                    ?>
                    <p><strong>PAYMENT TERM :</strong> <?php echo nl2br($modelInvoice->paymentTerm->payment_terms); ?></p>
                <?php } ?>
                <p style="border-bottom:2px solid  black;"></p>
                <p><strong>CURRENCY :</strong>
                    <?php
                    $modelCurrency = new MasCurrency();
                    $modelCurrency = $modelCurrency->getCurrencyDetails($modelInvoice->currency_id);
                    echo $modelCurrency->currency_code;
                    if ($modelCurrency->currency_code != "AED") {
                        echo "/" . $modelInvoice->exchange_rate;
                    }
                    ?>
                </p>
                <p class="remarks"><strong>REMARKS :</strong> <?php echo $modelInvoice->remarks; ?></p>
            </div>
        </div>


        <table class="item-table" cellspacing="0">
            <tr class="table-header">

                <td style="width: 40px;">No</td>

                <?php if ($print_type != 5 && $print_type != 6) { ?>
                    <td style="width: 100px;">Part No</td>
                <?php } ?>

                <?php if (in_array($print_type, [1, 4, 5, 6, 7])) { ?>
                    <td style="width: 270px;">Description</td>
                <?php } ?>

                <?php if (
                    isset($master_permission_array['inventory_image_show_invoice'])
                    || in_array($print_type, [6, 7])
                ) { ?>
                    <td class="text-center" style="width: 100px;">Image</td>
                <?php } ?>

                <td class="right-align" style="width: 60px;">Qty

                    <?php /*if ($bonus_quantity == "Y") { ?>
<td class="right-align" style="width: 70px;">Bonus Qty</td>
<?php }*/ ?>

                    <!--<td class="right-align" style="width: 70px;">Unit-->
                </td>
                <td class="right-align" style="width: 90px;">Rate</td>
                <td class="right-align" style="width: 110px;">Total</td>
                <td class="right-align" style="width: 110px;">Tax Amt</td>

                <?php if (in_array($print_type, [1, 2, 5, 6, 7])) { ?>
                    <td class="right-align" style="width: 100px;">Discount</td>
                <?php } ?>

                <td class="right-align" style="width: 120px;">Net Amt</td>

            </tr>


            <tr>
                <?php
                $m = 1;
                $condition .= '1=1 AND t.invoice_id ="' . $id . '"';
                $total = $total_vat = $total_cbm = $total_weight = $discount = 0;

                $modelInvoiceItem = InvoiceItem::model()->findAll(['condition' => $condition, 'order' => 'id ASC']);
                foreach ($modelInvoiceItem as $eachItem) {
                    echo '<tr>';
                    echo '<td>' . $m . '</td>';

                    if ($print_type != 5 && $print_type != 6) {
                        echo '<td>' . $eachItem->product->part_number . '</td>';
                    }

                    if ($print_type == 4 || $print_type == 5 || $print_type == 6 || $print_type == 7 || $print_type == 1) {
                        if ($modelInvoice->sales_inv_type == "service")
                            echo '<td>' . nl2br($eachItem->description_2) . '</td>';
                        else
                            echo '<td>' . nl2br($eachItem->description) . '</td>';
                    }

                    if (isset($master_permission_array['inventory_image_show_invoice']) || $print_type == 6 || $print_type == 7) {
                        echo '<td>';
                        if (!empty($eachItem->product->item_image)) {
                            echo '<img src="' . Yii::app()->baseUrl . '/uploads/inventoryimages/' . $eachItem->product->item_image . '" style="max-width:100px;height:auto;">';
                        }
                        echo '</td>';
                    }

                    echo '<td class="text-right">' . (int) $eachItem->quantity . ' ';

                    /* if ($bonus_quantity == "Y") {
                         echo '<td class="text-right">' . (int)$eachItem->bonus_qty . '</td>';
                     }*/

                    echo ' ' . $eachItem->invoiceunit->name . '</td>';
                    echo '<td class="text-right">' . number_format($eachItem->rate, 2) . '</td>';
                    echo '<td class="text-right">' . number_format($eachItem->rate * $eachItem->quantity, 2) . '</td>';
                    echo '<td class="text-right">' . number_format($eachItem->tax_vat_amount, 2) . '</td>';

                    if ($print_type == 2 || $print_type == 7 || $print_type == 1 || $print_type == 6 || $print_type == 5) {
                        echo '<td class="text-right">' . number_format($eachItem->deduction_amount, 2) . '</td>';
                    }

                    $net_amount = $eachItem->net_amount + $eachItem->tax_vat_amount;
                    echo '<td class="text-right">' . number_format($net_amount, 2) . '</td>';
                    echo '</tr>';

                    $m++;
                    $total += $eachItem->net_amount;
                    $total_vat += $eachItem->tax_vat_amount;
                    $discount += $eachItem->deduction_amount;


                    $tax_percent = (float) $eachItem->tax_vat_amount;
                    if (!isset($tax_summary[$tax_percent])) {
                        $tax_summary[$tax_percent] = [
                            'taxable' => 0,
                            'tax' => 0,
                            'gross' => 0
                        ];
                    }
                    $tax_summary[$tax_percent]['taxable'] += $eachItem->net_amount;
                    $tax_summary[$tax_percent]['percentage'] += $eachItem->tax_vat_percentage;
                    $tax_summary[$tax_percent]['tax'] += $eachItem->tax_vat_amount;
                    $tax_summary[$tax_percent]['gross'] += $eachItem->net_amount + $eachItem->tax_vat_amount;
                }

                // Dynamic colspan calculation for totals
                $colCount = 1; // No column
                
                if ($print_type != 5 && $print_type != 6)
                    $colCount++; // Part No
                if (in_array($print_type, [4, 5, 6, 7, 1, 5]))
                    $colCount++; // Description
                if (isset($master_permission_array['inventory_image_show_invoice']) || in_array($print_type, [6, 7]))
                    $colCount++; // Image
                
                $colCount++; // Qty
                if ($bonus_quantity == "Y")
                    $colCount++; // Bonus Qty
                
                $colCount += 4; // Unit, Rate, Total, Tax Amt
                
                if (in_array($print_type, [2, 7, 6, 1, 5]))
                    $colCount++; // Discount
                $colCount++; // Net Amt
                


                ?>




            </tr>
        </table>

        <div class="tax-details" style="width:45%;float: left;">
            <h3 style="font-size:13px;margin-bottom:6px;">TAX DETAILS</h3>
            <table style="font-size:11px;">
                <tr class="table-header">
                    <td>Tax %</td>
                    <td class="right-align">Taxable Amt</td>
                    <td class="right-align">Tax</td>
                    <td class="right-align">Gross</td>
                </tr>
                <?php
                if (!empty($tax_summary)) {
                    foreach ($tax_summary as $percent => $data) {
                        echo '<tr>';
                        echo '<td >' . number_format($data['percentage'], 2) . '</td>';
                        echo '<td class="right-align">' . number_format($data['taxable'], 2) . '</td>';
                        echo '<td class="right-align">' . number_format($data['tax'], 2) . '</td>';
                        echo '<td class="right-align">' . number_format($data['gross'], 2) . '</td>';
                        echo '</tr>';
                    }
                } else {
                    echo '<tr><td colspan="4" style="text-align:center;">No tax data available</td></tr>';
                }
                ?>
            </table>
        </div>

        <div class="total-box" style="width:45%;float: right; font-size: 11px;">
            <table style="width:100%; font-size:11px; border-collapse:collapse;">
                <tr>
                    <td style="border-bottom:1px solid black; padding:6px 0px;"><strong>INVOICE SUBTOTAL</strong></td>
                    <td style="border-bottom:1px solid black; padding:6px 0px;">:</td>
                    <td style="border-bottom:1px solid black; padding:6px 0px;width: 20%;">AED</td>
                    <td style="border-bottom:1px solid black; padding:6px 0px; text-align:right;">
                        <?= number_format($total, 2) ?>
                    </td>
                </tr>
                <?php if (in_array($print_type, [2, 7, 6, 1, 5])): ?>
                    <tr>
                        <td style="border-bottom:1px solid black; padding:6px 0px;"><strong>TOTAL DISCOUNT</strong></td>
                        <td style="border-bottom:1px solid black; padding:6px 0px;">:</td>
                        <td style="border-bottom:1px solid black; padding:6px 0px;">AED</td>
                        <td style="border-bottom:1px solid black; padding:6px 0px; text-align:right;">
                            <?= number_format($discount, 2) ?>
                        </td>
                    </tr>
                <?php endif; ?>
                <tr>
                    <td style="border-bottom:1px solid black; padding:6px 0px;"><strong>TOTAL TAX AMOUNT</strong></td>
                    <td style="border-bottom:1px solid black; padding:6px 0px;">:</td>
                    <td style="border-bottom:1px solid black; padding:6px 0px;">AED</td>
                    <td style="border-bottom:1px solid black; padding:6px 0px; text-align:right;">
                        <?= number_format($total_vat, 2) ?>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom:1px solid black; padding:6px 0px;"><strong>TOTAL AMOUNT</strong></td>
                    <td style="border-bottom:1px solid black; padding:6px 0px;">:</td>
                    <td style="border-bottom:1px solid black; padding:6px 0px;">AED</td>
                    <td style="border-bottom:1px solid black; padding:6px 0px; text-align:right;">
                        <strong><?= number_format($total + $total_vat, 2) ?></strong>
                    </td>
                </tr>
            </table>


        </div>

        <div style="width:100%;">
            <table style="width:100%; font-size:11px; border-collapse:collapse; margin-top:6px;">
                <tr>
                    <td style="padding:6px 0px; vertical-align:top; width:30%;"><strong>TAX IN WORDS </strong></td>
                    <td width="1%">:</td>
                    <td style="padding:6px 0px;"><?= $modelInvoice->currency->currency_code ?>
                        <?= numberToWords($total_vat) ?> ONLY
                    </td>

                    <?php
                    /* foreach ($tax_summary as $percent => $data) {
                    ?>
                    <td style="padding:6px 0px;"><?=$modelInvoice->currency->currency_code?> <?= numberToWords($data['tax'])?> ONLY</td>
                    <?php }*/ ?>
                </tr>
                <tr>
                    <td style="padding:6px 0px; vertical-align:top;"><strong>AMOUNT IN WORDS </strong></td>
                    <td width="1%">:</td>
                    <td style="padding:6px 0px;"><?= $modelInvoice->currency->currency_code ?>
                        <?= numberToWords($total + $total_vat) ?> ONLY
                    </td>
                </tr>
            </table>
        </div>

        <p style="border-bottom:2px solid  black;"></p>

        <div style="width:100%;margin-top: 20px;">

            <!-- Acknowledgment & Note -->
            <div style="width:72%;float: left;">
                <p style="font-size:11px; margin:0;">
                    I / We hereby read, understood and comply the same received.<br>
                    Authorised signatory with rubber stamp (Customer’s).
                </p>
                <?php if ($modelInvoice->terms_and_conditions != '') {
                    ?>
                    <p style="font-size:10px; margin:8px 0 4px 0;">
                        <strong>Important Note:</strong> <?php echo nl2br($modelInvoice->terms_and_conditions); ?>
                    </p>
                <?php } ?>
            </div>
            <div style="width:28%;float: right;">
                <!-- Signature -->
                <p style="text-align:right; font-size:11px; margin-top:10px;">
                    For <strong>CORAL CONCEPTS L.L.C</strong><br>
                    <strong>Authorised Signatory</strong>
                </p>
            </div>

        </div>

        <!-- Footer Section -->
        <table style="width:100%; font-size:11px; border-collapse:collapse;padding-left: 0px;">
            <tr>
                <!-- Left Column: Company Info -->
                <td style="width:56%; vertical-align:top; padding-right:0px;">
                    <table style="width:100%; font-size:11px; border-collapse:collapse;">
                        <tr>
                            <td style="width:30%; font-weight:bold;">COMPANY NAME:</td>
                            <td><strong>CORAL CONCEPTS L.L.C</strong></td>
                        </tr>
                        <tr>
                            <td style="font-weight:bold;">ADDRESS:</td>
                            <td>AL QUOZ IND 4, WAREHOUSE 5 11, P.O.BOX:186887, Dubai-U.A.E</td>
                        </tr>
                        <tr>
                            <td style="font-weight:bold;">WEBSITE:</td>
                            <td><a href="https://www.coralaroma.com/" target="_blank">https://www.coralaroma.com/</a>
                            </td>
                        </tr>
                        <tr>
                            <td style="font-weight:bold;">PHONE:</td>
                            <td>+971 4 252 9777</td>
                        </tr>
                        <tr>
                            <td style="font-weight:bold;">E-MAIL:</td>
                            <td>info@coralaroma.com</td>
                        </tr>
                    </table>
                </td>



                <!-- Right Column: Bank Info -->
                <td style="width:42%; vertical-align:top;">

                    <?php $model = OwnerBankDetails::model()->find(array('condition' => 'currency_id=' . $modelInvoice->currency_id));
                    if (empty($model))
                        $model = OwnerBankDetails::model()->find(array('condition' => 'currency_id=23'));
                    if (!empty($model)) {
                        ?>
                        <table
                            style="width:100%; border:1px solid #000; padding:6px 10px; font-size:11px; border-collapse:collapse;">
                            <tr>
                                <td style="font-weight:bold; padding:6px 10px;">BANK NAME:</td>
                                <td><?php echo $model->bank->bank_name ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight:bold; padding:6px 10px;">ACCOUNT NO:</td>
                                <td><?php echo $model->bank_ac_no; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight:bold;padding:6px 10px;">SWIFT/BIC CODE:</td>
                                <td><?php echo $model->bank_swift; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight:bold;padding:6px 10px;">IBAN:</td>
                                <td><?php echo $model->bank_iban; ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        <?php } ?>




    </div>

    </div>
    <htmlpagefooter name="myfooter">

        <div class="col-12" style="text-align:center;font-size: 11px;">

            <p class="footer-text">

                <i><?php //echo $modelComapnyDetails->footer_autogenerated; ?>
                    Printed from Bluesky ERP on

                    <?php
                    date_default_timezone_set("Asia/Dubai");
                    echo date('d/m/Y') . " at " . date("h:i:s:a");
                    ?></i>
        </div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>

</html>