<html>

<head>
    <title>External Transfer Receipt</title>
</head>
<style>
    .w-100 {
        width: 100% !important;
    }
</style>

<body>
    <div class="container" style="width: 100%; font-size: 11px; padding: 30px;">
        <?php $this->renderPartial('//common/header'); ?>

        <?php $model = InventoryIndirectTransfer::model()->findByPk($id); ?>

        <div class="row" style="margin-top: 10px;">
            <div class="col-4">
                <div class="input-block">
                    <b><?php echo $id; ?></b>
                </div>
            </div>
            <div class="col-4">
                <div class="h3" style="margin: 0; text-align: center; font-size: 14px;">
                    <?php
                    $label = '';
                    if (isset($frm)) {
                        $frm = strtolower($frm);
                        if ($frm === 'in') {
                            $label = 'TRANSFER IN';
                        } elseif ($frm === 'out') {
                            $label = 'TRANSFER OUT';
                        } elseif ($frm === 'transit') {
                            $label = 'IN TRANSIT';
                        }
                    }
                    echo strtoupper($label);
                    ?>
                </div>
            </div>
            <div class="col-4" style="color: #101010;">
                <table class="table" style="width:100%;">
                    <tr>
                        <td>Transfer Date</td>
                        <td><?php echo date('d/m/Y', strtotime($model->transfer_date)); ?></td>
                    </tr>
                    <tr>
                        <td>From Warehouse</td>
                        <td><?php echo $model->warehouseFrom->warehouse_name; ?></td>
                    </tr>
                    <tr>
                        <td>Destination</td>
                        <td><?php echo $model->warehouseTo->warehouse_name; ?></td>
                    </tr>
                    <tr>
                        <td>Customer</td>
                        <td><?php echo $model->customer_name; ?></td>
                    </tr>
                    <?php if ($model->reference != '') {
                        ?>
                        <tr>
                            <td>Reference</td>
                            <td> <?php echo nl2br($model->reference); ?></td>
                        </tr><?php } ?>
                </table>
            </div>
        </div>
    </div>
    <br>
    <div class="col-md-12">
        <table id="" class="table">
            <thead>
                <tr>
                    <th class="text-left">No</th>
                    <th class="text-left">Item</th>
                    <th class="text-left">Item Description</th>
                    <th class="text-left">Transfer</th>
                    <?php if ($frm == 'in'): ?>
                        <th class="text-left">Received</th>
                        <th class="text-left">Missing</th>
                        <th class="text-left">Damaged</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>

                <?php
                $m = 1;
                $condition .= '1=1';
                $condition .= ' AND t.indirect_transfer_id ="' . $id . '"';
                $model_Items = InventoryIndirectTransferItem::model()->findAll(array('condition' => $condition));
                foreach ($model_Items as $i => $each_Item) {
                    $header_id = $id;

                    $sl_no = '';
                    if ($each_Item->stock->have_serial_no == 'Y') {
                        $modelStockLedger = StockLedger::model()->findAll(array('condition' => 'header_id IN (' . $header_id . ') AND product_id=' . $each_Item->item_id . ' AND (transaction_type="INDIRECT_TRANSFER_OUT" OR transaction_type="INDIRECT_TRANSFER_IN")'));
                        if (!empty($modelStockLedger)) {
                            foreach ($modelStockLedger as $each) {
                                $productlocatin_id = $each->product_location_id;
                                $eachsl_no = ProductLocationDetails::getSerialNo($productlocatin_id);
                                if ($sl_no == '') {
                                    $sl_no = $eachsl_no;
                                } else {
                                    $sl_no .= ' , ' . $eachsl_no;
                                }
                            }
                        }
                    }
                    $batch_no = "";
                    if ($each_Item->stock->have_expiry_date == 'Y') {
                        $model = StockLedger::model()->findAll(array('condition' => 'header_id IN (' . $header_id . ') AND product_id=' . $each_Item->item_id . ' AND (transaction_type="INDIRECT_TRANSFER_OUT" OR transaction_type="INDIRECT_TRANSFER_IN")'));
                        if (!empty($model)) {
                            foreach ($model as $each) {
                                $productlocatin_id = $each->product_location_id;
                                $eachbatch_no = ProductLocationDetails::getBatchNoWithExpDate($productlocatin_id);
                                if ($batch_no == '') {
                                    $batch_no = $eachbatch_no;
                                } else {
                                    $batch_no .= ' , ' . $eachbatch_no;
                                }
                            }
                        }
                    }

                    ?>
                    <tr>
                        <td>
                            <?php echo $m; ?>
                        </td>
                        <td>
                            <?php echo $each_Item->item_name; ?>
                        </td>
                        <td>
                            <?php echo $each_Item->item_description; ?>
                            <?php if (!empty($sl_no)) { ?>
                                <br />
                                Serial No:<?php echo $sl_no; ?>
                            <?php } ?>
                            <?php if (!empty($batch_no)) { ?>
                                <br />
                                Batch No:<?php echo $batch_no; ?>
                            <?php } ?>
                        </td>

                        <td class="text-right">
                            <?php echo number_format($each_Item->transfer_qty, 0); ?>
                        </td>
                        <?php if ($frm == 'in'): ?>
                            <td class="text-right">
                                <?php echo number_format($each_Item->transferred_qty, 0); ?>
                            </td>
                            <td class="text-right">
                                <?php echo number_format($each_Item->missing_qty, 0); ?>
                            </td>
                            <td class="text-right">
                                <?php echo number_format($each_Item->damaged_qty, 0); ?>
                            </td>
                        <?php endif; ?>

                    </tr>

                    <?php $m++;


                }
                ?>


            </tbody>
        </table>
        <br>
        <?php if ($model->indirect_transfer_description != '') {
            ?>
            <div class="box w-100">
                <h5>Description</h5>
                <div class="h5sub-details">
                    <?php echo nl2br($model->indirect_transfer_description); ?>
                </div>
            </div>
        <?php } ?>


    </div>
    <?php $this->renderPartial("//common/footer"); ?>
</body>

</html>