<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
    ?>
<script type="text/javascript">
$(document).ready(function() {

    var table_id ="#tbl_packing_list";
    var table = $(table_id).DataTable({
        scrollY         : "380px",
        pageLength      : 50,
		processing: true,
	            "columnDefs": [
	                {
	                   "targets": [5],
	                   "visible": false,
	                },
	            ],
            
        ajax: {
            url: "<?php echo Yii::app()->createUrl('packaging/GetList');?>",
            type: "POST",
            cache : false,
        },
        serverSide:     true,
        fixedColumns:   true,
		processing: true,
        fixedHeader: {
            headerOffset: $("header.main").outerHeight()
        },
        "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
     		$(nRow).addClass("context-menu");
 		},
 		"fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
     
	     	$("#tbl_packing_list tbody").mousedown(function (e) {   
	         $(this).contextMenu({
	             selector: ".context-menu",
	            callback: function(key, options) {
	         		var action_id = key;
					var data = table.row( this ).data();
					var id=data[0];
					var part_number = data[1];
					var status = data[5];
					if(action_id == "convert"){
						loadPopupModal("packaging/create&id="+id,"Convert - "+id ,"xl");
					}/* 
					else if(action_id == "print" && status=="GI"){
						window.open($('#liveSite').val()+"/index.php?r=issues/PrintPDF&id="+id,"_blank")
					} */
	
					
	     		},
	             items: {
	            	 <?php //if(isset(Yii::app()->user->havePermissionOn['mov_issue_view']) ||  Yii::app()->user->authorised_user == 1){ ?>
	                 		"convert": {name: "Convert", icon: "fa-retweet"},
	                 <?php //} ?>
	                 <?php //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mov_issue_view"])){ ?>
	                 		//"print": {name: "Print", icon: "fa-print"},
	                 <?php //} ?>
	             }
	         }
	         );
	     });     
	 }
    } );
    $(".dataTables_scrollFoot").hide();
});
</script>    
    <section class="panel">
        <header class="panel-heading clearfix panel-theame"> 
            <i class="fa fa fa-area-chart"></i> Packaging
            <div class="pull-right"> 
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_packing_list">
                    <thead>
                         <tr>
                            <th>Receipt No</th>
                            <th>Prd.No</th>
                            <th>Receipt Date</th>
                            <th>Customer</th>
                            <th>File#</th>
                            <th>Order#</th>
                            <th></th>
		                  </tr>
                        <!--tr>
                            <th>No</th>
                            <th>File#</th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Status</th>
                        </tr-->
                    </thead>
                </table>
            </div>
        </div>
    </section>
