<?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'sitedetail-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
?>
<ul class="clearfix form-ul material">
    <li class="col-sm-3">
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php echo $form->textField($model, 'site_name', array('class' => 'tooltipster', 'data-label' => 'Site Name')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'site_contact_detail', array('class' => 'tooltipster', 'data-label' => 'Contact')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'site_timing', array('class' => 'tooltipster', 'data-label' => 'Site Timing')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'site_supervisor', array('class' => 'tooltipster', 'data-label' => "Supervisor",'title' => 'Supervisor')); ?>
    </li>
</ul>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="site_detail_close"  data-dismiss="modal">Close</button>
    <?php
        echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('order/savesitedetails'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {  
                    if(data.status=="success"){  
                        t8.success("Site Detail Saved!","Success");  
                        $("#site_detail_close").click();
                        reloadTable("#tble_order"); 
                    } else { 
                        $.each(data, function(key, val) {
                            t8.error(""+val+""); 
                        }); 
                    } 
            }',
            'beforeSend' => 'function(){
                $(".toast8-error").hide(); 
                var site_name=$("#Order_site_name").val();
                var site_contact_detail=$("#Order_site_contact_detail").val();
                var site_timing=$("#Order_site_timing").val();
                var site_supervisor=$("#Order_site_supervisor").val();
                if(site_name=="" && site_contact_detail=="" && site_timing=="" && site_supervisor==""){
                    t8.error("Enter atleast one field"); 
                    return false;
                }else{
                    $(".toast8-error").hide(); 
                    $("#loader").show();
                    $("#sitedetail-form .sitedetail-save-btn").prop("disabled", true);
                    $("#sitedetail-form .sitedetail-save-btn").addClass("btn_loading").removeClass("btn-theme");

                }                                
            }',
            'complete' => 'function(){
                $("#loader").hide();
                $("#sitedetail-form .sitedetail-save-btn").prop("disabled", false);
                $("#sitedetail-form .sitedetail-save-btn").addClass("btn-theme").removeClass("btn_loading"); 
            }'
        ), array('id' => 'save_site' . rand(), 'class' => 'sitedetail-save-btn btn btn-theme'));
?>
</div>  
<?php $this->endWidget(); ?>