<?php
if (empty($id)) {
    echo "Not found";
    die();
}
$orderModel = Order::model()->findByPk($id);
$customerModel = Customer::model()->findByPk($orderModel->customer_id);
?>

<div class="popup_inner_element">
    <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
        <li class="active">
            <a href="#tab-snapshot" data-toggle="tab">
                Snapshot
            </a>
        </li>
        <li>
            <a href="#tab-machine" data-toggle="tab">
                Machine
            </a>
        </li>
        <li>
            <a href="#tab-oil" data-toggle="tab">
                Oil
            </a>
        </li>
        <li>
            <a href="#tab-job-sheet" data-toggle="tab">
                Job Sheet
            </a>
        </li>
        <li>
            <a href="#tab-time" data-toggle="tab">
                Time
            </a>
        </li>
        <li>
            <a href="#tab-invoice" data-toggle="tab">
                Invoice
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="tab-snapshot">
            <?php
            $this->renderPartial('service_summary_snapshot', [
                'customerModel' => $customerModel,
                'orderModel' => $orderModel
                    ]
            );
            ?>
        </div>
        <div class="tab-pane" id="tab-machine">
            <?php
            $this->renderPartial('service_summary_machine', [
                'customerModel' => $customerModel,
                'orderModel' => $orderModel
                    ]
            );
            ?>
        </div>
        <div class="tab-pane" id="tab-oil">
            <?php
            $this->renderPartial('service_summary_oil', [
                'customerModel' => $customerModel,
                'orderModel' => $orderModel
                    ]
            );
            ?>
        </div>
        <div class="tab-pane" id="tab-job-sheet">
            <?php
            $this->renderPartial('service_summary_jobsheet', [
                'customerModel' => $customerModel,
                'orderModel' => $orderModel
                    ]
            );
            ?>
        </div>
        <div class="tab-pane" id="tab-time">
            <?php
            $this->renderPartial('service_summary_time', [
                'customerModel' => $customerModel,
                'orderModel' => $orderModel
                    ]
            );
            ?>
        </div>
        <div class="tab-pane" id="tab-invoice">
            <?php
            $this->renderPartial('service_summary_invoice', [
                'customerModel' => $customerModel,
                'orderModel' => $orderModel
                    ]
            );
            ?>
        </div>
    </div>
</div>