<?php

/**
 * Last Modified by Jobin
 */
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$total_vat = 0;
$model_settings = new MasCompanySettings();
$crm_login_company_id = Yii::app()->user->master_user_company_id;
$model_settings = $model_settings->find(array('condition' => 'crm_company_id=' . $crm_login_company_id));
$allow_change = $model_settings->allow_change_description;
$bonus_quantity = $model_settings->bonus_quantity;
echo CHtml::hiddenField('allow_change', $allow_change);
echo CHtml::hiddenField('bonus_quantity', $bonus_quantity);

$is_sales_man = User::isSalesman();
echo CHtml::hiddenField('is_sales_man', $is_sales_man);
$selling_price_flag = 0;
if (isset(Yii::app()->user->havePermissionOn['edit_selling_price'])) {
    $selling_price_flag = 1;
}
?>
<input type="hidden" id="hid_edit_selling_price" name="hid_edit_selling_price" value="<?php echo $selling_price_flag; ?>" />
<!--div id="stockhelper" style='position: absolute;display:none;' ></div-->
<div id="div_service_item_details">
    <ul class="clearfix form-ul material">
        <li class="col-sm-3">
            <?php if ($model->customer_id > 0) {
                $customer = $model->customer->customer_name;
            } else {
                $customer = $modelQuotes->customer->customer_name;
            } ?>
            <?php

            echo $form->textField($model, 'customer_name', array('class' => 'text-bold', 'data-label' => "Customer <span style='color:red'>*</span>", 'title' => 'Please select customer', 'onKeyup' => 'js:autoCompleteOrderCustomers(this.id,"Order");', 'value' => $customer));


            ?>
            <?php echo $form->hiddenField($model, 'customer_id', array('value' => $modelQuotes->customer_id)); ?>
            <?php echo $form->hiddenField($model, 'tender_file_id'); ?>
            <?php echo $form->error($model, 'customer_id'); ?>
            <?php $model->shipping_by = MasShipping::getDefault(); ?>
            <?php echo $form->hiddenField($model, 'shipping_by'); ?>
            <?php $model->currency = Yii::app()->user->company_base_currency;
            echo $form->hiddenField($model, 'currency'); ?>
            <?php $model->exchange_rate = 1;
            echo $form->hiddenField($model, 'file_title');
            echo $form->hiddenField($model, 'exchange_rate');
            $model->sales_group = 1;
            echo $form->hiddenField($model, 'sales_group');
            $model->lead_owner_id = Yii::app()->user->id;
            echo $form->hiddenField($model, 'lead_owner_id'); ?>
        </li>
        <div id="div_contact">
            <li class="col-sm-3">
                <?php
                if ($model->customer_id > 0) {
                    $customer_id = $model->customer_id;
                } else {
                    $customer_id = $model_lead->customer_id;
                }
                if ($model->contact_id > 0) {
                    $contact_name = $model->customercontact->person_name;
                    echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($customer_id), array('options' => array($model->contact_id => array('selected' => true)), 'readonly' => true, 'data-label' => 'Contact <span style="color:red">*</span>'));
                } else {
                    echo $form->dropDownList($model, 'contact_id', CustomerContact::getCustomerContacts($model_lead->customer_id), array('data-label' => 'Contact Person', 'prompt' => 'Select lead owner',));
                }
                ?>
            </li>
        </div>
        <li class="col-sm-3">

            <div id="order_paymentterm_div">
                <?php $term = $modelQuotes->payment_terms;

                $payment_terms = '';
                if ($model->payment_terms > 0) {
                    $payment_terms = $model->payment_terms;
                } else {
                    $payment_terms = $modelQuotes->payment_terms;
                }

                $arr_payment_term_details = MasPaymentTerm::model()->findByPk($payment_terms);
                $payment_terms_name = $arr_payment_term_details->payment_terms;
                ?>
                <?php
                if (((int) Yii::app()->user->havePermissionOn["other_customer_finance_view"])) {
                    echo $form->dropDownList($model, 'payment_terms', MasPaymentTerm::getPaymentTerms(), array('data-label' => 'Payment Terms <span style="color:red">*</span>', 'prompt' => '--Select--', 'options' => array($term => array('selected' => true))));
                } else {
                    echo CHtml::textField('payment_terms_name', $payment_terms_name, array('class' => 'text-bold', 'data-label' => 'Payment Terms <span style="color:red">*</span>', 'readonly' => true));
                    echo $form->hiddenField($model, 'payment_terms', array('value' => $payment_terms));
                }

                ?>
                <?php echo $form->error($model, 'payment_terms'); ?>
            </div>

        </li>

    </ul>
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="order_item_table">
            <tr>
                <th width="4%">No</th>
                <th width="15%">Product</th>
                <th width="32%">Description</th>
                <th width="8%">Qty</th>
                <th width="12%">Unit</th>
                <th>Rate</th>
                <th>Discount</th>
                <th>Net/Item</th>
                <!--<th>Amount</th> -->
                <th>Tax(%)</th>
                <!--<th class="bg-success text-center">+/-</th>           
                <th class="bg-danger text-center">Discount</th> -->
                <th>Net Amount</th>
                <th class="text-center">

                    <a class="btn btn-xs btn-theme" href="javascript:void(0);" onclick="addTableRow($('#order_item_table'));"><i class="fa fa-plus"></i></a>

                </th>
            </tr>
            <?php
            $m = 1;
            foreach ($modelOrderItems as $i => $modelOrderItems) {
                $status = false;
                if ($modelOrderItems->checked == 1) {
                    $status = true;
                }
                $checkbox_disabled = false;
                if ($modelOrderItems->convert_to_delivery_note == "Y") {
                    $checkbox_disabled = true;
                }
                if ($model->file->is_approved == 'Y' && $model->id > 0) {
                    $checkbox_disabled = true;
                }
                $product_inventory_type = "";
                if ($modelOrderItems->product_id == 999999) {
                    $product_name = 'memo';
                    $disabled = true;
                    $modelOrderItems->unit = '';
                    $rateDisabled = true;
                } else {
                    $product_name = $modelOrderItems->product->part_number;
                    $disabled = false;
                    $product_inventory_type = $modelOrderItems->product->inventory_item_type;
                    $rateDisabled = false;
                }

                if ((int) $modelOrderItems->product_id > 0) {
                    $modelSalesPriceGroup = new SalesPriceGroup();
                    $arr_price_details = $modelSalesPriceGroup->find(array('condition' => 'product_id=' . $modelOrderItems->product_id));


                    /* if(is_countable($arr_price_details) && count($arr_price_details)>0){
                            $rateDisabled=true;
                        }*/

                    if (is_array($arr_price_details) || $arr_price_details instanceof Countable) {
                        $rateDisabled = true;
                    }
                }



                if ($modelOrderItems->id > 0 && $modelOrderItems->expected_delivery_date != '' && $modelOrderItems->expected_delivery_date != '0000-00-00') {
                    $modelOrderItems->expected_delivery_date = date("d/m/Y", strtotime($modelOrderItems->expected_delivery_date));
                } else {
                    $modelOrderItems->expected_delivery_date = '';
                }
                if ($product_inventory_type != 4) {
            ?>
                    <tr>
                        <td><label><?php echo ($i + 1); ?></label>
                            <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]alternate_id", array('value' => $i + 1)); ?></td>
                        <!--<td>
                        <?php //echo $form->textField($modelOrderItems, "[" . $i . "]alternate_id", array('class' => 'qty go cell-center', 'onkeypress' => 'return isNumberKey(event)')); 
                        ?>
                    </td>-->
                        <td>
                            <div class="info-block" id="quotes-helper-new-<?php echo $i; ?>">
                                <?php
                                echo $form->textField($modelOrderItems, "[" . $i . "]product_name", array(
                                    'class' => 'form-control go', 'placeholder' => 'Type & Select',
                                    'onKeyup' => 'js:autoCompleteOrderProduct(this.id,"order");', 'value' => $product_name, 'title' => 'Select product'
                                ));
                                ?>
                                <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]id"); ?>
                                <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]product_id"); ?>
                                <?php echo $form->error($modelOrderItems, "[" . $i . "]product_id"); ?>
                                <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]inventory_type", array('value' => $product_inventory_type)); ?>
                                <?php //echo CHtml::hiddenField('product[' . $i . '][inventorytype]', $product_inventory_type); 
                                ?>
                                <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]expected_delivery_date"); ?>
                                <div class="info-btn" onclick="$('.info-table').hide();loadTable(this.id);" id="OrderItem_<?php echo $i; ?>_helper" title="Previous Orders"><i class="fa fa-info-circle" aria-hidden="true"></i></div>
                                <div class="info-table" id="OrderItem_<?php echo $i; ?>_mini_table">
                                    <span class="info-table-close" onclick="$('.info-table').hide()">
                                        <i class="fa fa-times-circle" aria-hidden="true"></i>
                                    </span>
                                    <div class="temp_div" id="data_of_<?php echo $i; ?>">

                                    </div>
                                </div>
                        </td>
                        <td>
                            <div id="div_description">

                                <?php
                                if ($allow_change == "N" || $is_sales_man == 'Y') {
                                    echo $form->textArea($modelOrderItems, "[" . $i . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here', 'readonly' => true));
                                } else {
                                    echo $form->textArea($modelOrderItems, "[" . $i . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                                }

                                ?>
                                <?php echo $form->error($modelOrderItems, "[" . $i . "]description"); ?>
                            </div>
                        </td>
                        <td><?php
                            $modelOrderItems->quantity = number_format($modelOrderItems->quantity);
                            echo $form->textField($modelOrderItems, "[" . $i . "]quantity", array('class' => 'qty go text-right', 'onkeypress' => 'return isNumberKey(event,this.value)', 'onkeyup' => 'calculateorderValue($("#order_item_table"));', 'readonly' => $disabled)); ?>
                            <?php echo $form->error($modelOrderItems, "[" . $i . "]quantity"); ?>
                        </td>
                        <?php if ($bonus_quantity == "Y") { ?>
                            <td>
                                <?php echo $form->textField($modelOrderItems, "[" . $i . "]bonus_qty", array('class' => 'qty go text-right', 'onkeypress' => 'return isPositiveInteger(event)', 'onkeydown' => 'isNumberKey(event,this.value)', 'readonly' => $disabled)); ?>
                                <?php echo $form->error($modelOrderItems, "[" . $i . "]bonus_qty"); ?>
                            </td>
                        <?php } ?>
                        <td id="unit_<?php echo $i; ?>">
                            <?php
                            ($modelOrderItems->product_id > 0) ? $data = UnitOfMeasurement::getUnits($modelOrderItems->product_id) : $data = array();
                            ?>
                            <?php echo $form->dropdownlist($modelOrderItems, "[" . $i . "]unit_id", $data, array('class' => 'qty go', 'onchange' => 'checkUnit(this.id);')); ?>

                        </td>
                        <td>
                            <?php
                            if ($selling_price_flag == 0) {
                                $rateDisabled = 'readonly';
                            }
                            echo $form->textField($modelOrderItems, "[" . $i . "]rate", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isNumberKey(event,this.value)'/*, 'onblur' => 'checkSaleRate(this.id);'*/, 'onkeyup' => 'calculateorderValue($("#order_item_table"));', 'readonly' => $rateDisabled)); ?>
                        </td>
                        <td>
                            <?php echo $form->textField($modelOrderItems, "[" . $i . "]deduction_amount", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isNumberKey(event,this.value)'/*, 'onblur' => 'checkSaleRate(this.id);'*/, 'onkeyup' => 'calculateorderValue($("#order_item_table"));', 'readonly' => $rateDisabled)); ?>
                        </td>
                        <td>
                            <?php


                           // $modelOrderItems->netrate = $modelOrderItems->rate - $modelOrderItems->deduction_amount;


                            echo $form->textField($modelOrderItems, "[" . $i . "]netrate", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isNumberKey(event,this.value)'/*, 'onblur' => 'checkSaleRate(this.id);'*/, 'onkeyup' => 'calculateorderValue($("#order_item_table"));', 'readonly' => $rateDisabled)); ?>
                            <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]actual_rate"); ?>
                            <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]actual_cost_rate"); ?>
                        </td>
                        <input type="hidden" id="check_tax_vat_percentage_<?php echo $i; ?>" value="<?php echo $modelOrderItems->product->tax->percentage; ?>">
                        <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]amount");
                        if ($modelOrderItems->product_id > 0) {
                            $modelOrderItems->tax_vat_percentage = $modelOrderItems->product->tax->percentage;
                            $modelOrderItems->tax_vat_amount = ($modelOrderItems->net_amount * $modelOrderItems->product->tax->percentage) / 100;
                            $model->total_tax_amount += $modelOrderItems->tax_vat_amount;
                        }
                        //echo $form->hiddenField($modelOrderItems, "[" . $i . "]tax_vat_percentage"); 
                        //echo $form->hiddenField($modelOrderItems, "[" . $i . "]tax_vat_amount");
                        echo $form->hiddenField($modelOrderItems, "[" . $i . "]addition_percentage", array('value' => '0.00'));
                        echo $form->hiddenField($modelOrderItems, "[" . $i . "]addition_amount", array('value' => '0.00'));
                        echo $form->hiddenField($modelOrderItems, "[" . $i . "]deduction_percentage", array('value' => '0.00'));
                        //echo $form->hiddenField($modelOrderItems, "[" . $i . "]deduction_amount",array('value'=>'0.00'));

                        /*<td>
                        <?php echo $form->textField($modelOrderItems, "[" . $i . "]amount", array('class' => 'amt go text-right', 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true)); ?>                    
                               
                    </td>  
                                 
                    <!--<td class="bg-success nw">
                        <?php echo $form->textField($modelOrderItems, "[" . $i . "]addition_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateorderValue($("#order_item_table"));', 'disabled' => $disabled)); ?>                    
                        <?php  ?>                    
                        <?php echo $form->textField($modelOrderItems, "[" . $i . "]addition_amount", array('class' => 'txt-6 go exception text-right additions', 'readonly' => true)); ?>                   
                        <?php  ?>                             
                    </td>-->                
                    <td class="bg-danger nw">

                        <?php echo $form->textField($modelOrderItems, "[" . $i . "]deduction_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateorderValue($("#order_item_table"));', 'disabled' => $disabled)); ?>                    
                        <?php echo $form->textField($modelOrderItems, "[" . $i . "]deduction_amount", array('class' => 'txt-6 go exception text-right deductions', 'readonly' => true)); ?>                    
                        <?php echo $form->error($modelOrderItems, "[" . $i . "]deduction_amount"); ?>                

                    </td>*/ ?>
                        <td>
                            <?php
                            if ($modelOrderItems->product_id > 0) {
                                $modelOrderItems->tax_vat_percentage = $modelOrderItems->product->tax->percentage;
                                $modelOrderItems->tax_vat_amount = ($modelOrderItems->net_amount * $modelOrderItems->product->tax->percentage) / 100;
                                //$modelOrderItems->tax_vat_amount = ($modelOrderItems->netrate * $modelOrderItems->product->tax->percentage) / 100;
                                $model->total_tax_amount += $modelOrderItems->tax_vat_amount;
                            }

                            //$modelOrderItems->net_amount= $modelOrderItems->netrate * $modelOrderItems->quantity;
                            ?>
                            <?php echo $form->textField($modelOrderItems, "[" . $i . "]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => true)); ?>
                            <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]tax_vat_amount"); ?>



                        </td>
                        <td>

                            <?php echo $form->textField($modelOrderItems, "[" . $i . "]net_amount", array('class' => 'amt go text-right', 'readonly' => true)); ?>
                            <?php echo $form->error($modelOrderItems, "[" . $i . "]net_amount"); ?>
                            <?php
                            $total += $modelOrderItems->net_amount;
                            $total_vat += $modelOrderItems->tax_vat_amount;
                            ?>
                        </td>
                        <td class="text-center nw" width="1%">
                            <?php echo CHtml::link('<i class="fa fa-arrow-up"></i>', 'javascript:void(0);', array('class' => 'up btn btn-primary btn-xs', 'title' => 'Move to Up')); ?>
                            <?php echo CHtml::link('<i class="fa fa-arrow-down"></i>', 'javascript:void(0);', array('class' => 'down btn btn-primary btn-xs', 'title' => 'Move to Down')); ?>
                            <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger ', 'onclick' => 'removeTableitem($(\'#order_item_table\'),this)', 'title' => 'Remove this item')); ?>

                        </td>
                    </tr>
            <?php
                    $m++;
                }
            } ?>
        </table>

        <table class="table table-hover table-bordered table-nexted order_total">
            <tr class="bg-total">
                <td width="70%" class="text-right table_total_title">
                    <h2>Total</h2>
                </td>
                <td width="30%" class="text-right table_total">
                    <h2 class="total" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></h2>
                </td>
            </tr>
        </table>

        <?php $grand_total = $total; ?>
        <!--<table id="order_final_add_table" class="table table-hover  table-nexted">        
            <?php /*foreach ($modelOrderAdditions as $i => $eachadd):
                ?>            
                <tr>               
                    <td class="text-right td-in-6">
                        Additions                    
                       
                    </td>   

                    <td>
                        <?php echo $form->dropDownList($eachadd, "[" . $i . "]particular", MasFooterItems::getSaleAdditions(), array('disabled' => true,'prompt' => 'Select', 'class' => 'form-control', 'style' => 'width:150px')); ?> 
                    </td>
                    <td>
                        <?php echo $form->textField($eachadd, "[" . $i . "]particular_value", array('disabled' => true,'onkeyup' => 'calculateorderValue($("#order_item_table"));', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'value_rate go text-right', 'placeholder' => '0.00')); ?>                    
                    </td>
                    <td>
                        <?php echo $form->textField($eachadd, "[" . $i . "]calculated_value", array('readonly' => true, 'class' => 'value_rate additions_value go text-right')); ?>                    
                    </td>
                    <td width="0">                    
                        <?php //echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger', 'onclick' => 'removeExtrasRow($("#order_final_add_table"), this)')); ?>                    
                    </td>                
                    <?php $grand_total += $eachadd->calculated_value; ?>            
                </tr>       
            <?php endforeach; ?>   
        </table>    

        <table id="order_final_ded_table" class="table table-hover table-nexted">        



            <?php foreach ($modelOrderDeductions as $i => $eachded):
                ?>           

                <tr>                
                    <td class="text-right td-in-6">

                        Deductions               

                        

                    </td>

                    <td>

                        <?php // echo $form->textField($eachded, "[" . $i . "]particular", array('class' => 'go particular', 'placeholder' => 'Particulars'));  ?>                    
                        <?php echo $form->dropDownList($eachded, "[" . $i . "]particular", MasFooterItems::getSaleDeductions(), array('disabled' => true,'prompt' => 'Select', 'class' => 'form-control', 'style' => 'width:150px')); ?>     
                    </td>

                    <td>

                        <?php echo $form->textField($eachded, "[" . $i . "]particular_value", array('disabled' => true,'onkeyup' => 'calculateorderValue($("#order_item_table"),this.id);', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'value_rate go text-right', 'placeholder' => '0.00')); ?>                    

                    </td>

                    <td>

                        <?php echo $form->textField($eachded, "[" . $i . "]calculated_value", array('readonly' => true, 'class' => 'value_rate deductions_value go text-right')); ?>                                    

                    </td>    

                    <td width="0">

                        <?php //echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger', 'onclick' => 'removeExtrasRow($("#order_final_ded_table"), this)')); ?>                    

                    </td>      

                    <?php $grand_total -= $eachded->calculated_value; ?>            



                </tr>        



            <?php endforeach; */ ?>    



        </table>  -->
        <table class="table table-hover table-bordered table-nexted order_grand_total">


            <tr class="summary_tr bg-total">
                <td width="70%" class="text-right table_total_title">
                    <h2>VAT</h2>
                </td>
                <td width="30%" class="text-right table_total">
                    <h2 class="vat" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_vat, " ");
                                                        $grand_total += $total_vat; ?></h2>
                </td>
            </tr>



            <!--<tr class="summary_tr total_val">-->
            <!--    <td class="text-right table_total_title" width="70%">-->
            <!--        <h1>VAT</h1></td>-->
            <!--    <td width="30%" class="text-right table_total">-->
            <!--        <h1 class="vat_total_val cell-right">-->
            <?php
            //   echo Yii::app()->numberFormatter->formatCurrency($total_vat, " ");
            // $grand_total += $total_vat;
            ?>
            <!--        </h1>-->
            <!--    </td>-->
            <!--</tr>-->

            <tr class="summary_tr bg-total">

                <td width="70%" class="text-right table_total_title">

                    <h1>Grand Total</h1>
                </td>

                <td width="30%" class="text-right table_total">

                    <h1 class="grandtotal" class="text-right">

                        <?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " "); ?>

                    </h1>
                </td>

            </tr>

        </table>

    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();




$cs->registerScript("autoCompleteOrderCustomers", "
    function autoCompleteOrderCustomers(field_id,frm){ 

       
       

        var url = '" . Yii::app()->createUrl('customer/GetcustomerDetails') . "'+'&frm='+frm; 
        $('#'+field_id).autocomplete({ 
            minLength : 1, 
            source : function (request, response) { 
                autoCompleteSource(request, response,url) 
            }, 
            focus : function( event, ui ) { $(this).val((ui.item.label)); return false; }, 
            select : function( event, ui ) {
                event.preventDefault(); trigger_target_id = $(event.target).attr('id'); 
                var customer_id=ui.item.value;
                $('#Order_customer_name').val(ui.item.customername); 
                var currency=ui.item.currency; 
                var currency_id=ui.item.currency_id; 
                var exchange_rate =ui.item.exchangerate; 
                var payment_term = ui.item.payment_term; 
                var lead_owner_id = ui.item.contact_id;
                var payment_terms_name = ui.item.other;
                /*$('#Order_lead_owner_id').multiselect('select',lead_owner_id);*/
                jQuery.ajax({ 
                    'data' :{'id':customer_id,'currency_id':currency_id}, 
                    'dataType' : 'json', 'type':'post', 
                    'url': '" . Yii::app()->createUrl('order/getCustomerContactdetails') . "',
                    'success': function(data) { 
                        $('#div_contact').html(data.dt); 
                        $('#Order_billing_address').val(data.adds).addClass('filled'); 
                        $('#Order_customer_id').val(customer_id); 
                        /*$('#Order_currency').multiselect('select', currency_id); */
                        
                        if($('#flag_finance_view').val()==1){
                              $('#Order_payment_terms').multiselect('select', payment_term); 
                        }
                        else{
                              $('#Order_payment_terms').val(payment_term);   
                              $('#payment_terms_name').val(payment_terms_name);  
                              $('#payment_terms_name').addClass('filled');    
                        }
                        $('#Order_exchange_rate').val(exchange_rate); 
                        $('#Order_exchange_rate').addClass('filled'); 
                    } 
                });
                
                //clearQuotationTableData();
            } 
        }) 
    
    }", CClientScript::POS_HEAD);
$cs->registerScript('InsertNewRow', 'function InsertNewRow(table_id,rowid)
        {
        //    var current_row = $(this).closest("table").children("tr:last");
    
    
         var jQtable=table_id;
        $(".quotation-helper,.purchase-helper,.stock-helper").each(function(){ 
        $(this).hide(); 
        $(this).find("table").remove();
        });
        
                formIdStarter   =   jQtable.attr("id").split(/_(.+)?/)[0];
                lastId = jQtable.find("tr:last input:first").attr("id");
                
                thenum = lastId.match(/\d+/g);
                newId = Number(thenum) + 1;
                
                newrow= jQtable.find("tr:last").clone();
                newrow.find("label:first").html(newId+1);
                newrow.find("input,textarea,checkbox,select,.errorMessage").each(function() {
                    this.id= this.id.replace(/\d+/,newId);
                   if(!$(this).is(":checkbox"))
                        this.value  = "";
                    else
                        $(this).prop("checked", false);
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   "display:none;";});
                jQtable.append(newrow);
                //auto_complete2(formIdStarter,newId);
                //$.colorbox.resize();
                
                var current_row = $("#"+rowid).parents("tr:last");
                
                lastrow=newId;
                
                
                lastId = $("#"+rowid).closest("tr").find("input[type=text]").attr("id");
                
                thenum = lastId.match(/\d+/g);
                
                
                thenum=parseInt(thenum);
                
                
                lastrow=parseInt(lastrow);
                diff=lastrow-thenum;
                
                
                for(j=thenum;j<lastrow;j++)
                {
                if(j==thenum)
                {
                    
                row_need_to_replace    =   current_row.next();
                }
                else {
                    
                row_need_to_replace    =   row_need_to_replace.next();
                }
                }
                last_replace=row_need_to_replace;
                for(j=lastrow;j>thenum;j--)
                {
                if(j==thenum)
                {
                    
                row_need_to_replace    =   current_row.next();
                
                if(current_row.find("input,textarea").length>0)
                {
                     
                var i=0;
                row_need_to_replace.find(":input").each(function(){
                input_need_to_replace=current_row.find(":input :eq("+i+")");
                temp   =   input_need_to_replace.val();
                input_need_to_replace.val($(this).val());
                $(this).val(temp);
                this_readonly=$(this).is(\'[readonly]\')
                input_need_to_replace_readonly=input_need_to_replace.is(\'[readonly]\');
                $(this).attr(\'readonly\',input_need_to_replace_readonly);
                input_need_to_replace.attr(\'readonly\',this_readonly);
                i++;
            });
        }
                }
                else {
                    
                if(j==lastrow)
                {
                    
                pre=last_replace;
                row_need_to_replace    =   last_replace.prev();
                }
                else {
                    
                pre=row_need_to_replace;
                row_need_to_replace    =   row_need_to_replace.prev();
                }
                if(pre.find("input,textarea").length>0)
        {
            
            var i=0;
                row_need_to_replace.find(":input").each(function(){
                input_need_to_replace=pre.find(":input :eq("+i+")");
                temp   =   input_need_to_replace.val();
                input_need_to_replace.val($(this).val());
                $(this).val(temp);
                this_readonly=$(this).is(\'[readonly]\')
                input_need_to_replace_readonly=input_need_to_replace.is(\'[readonly]\');
                $(this).attr(\'readonly\',input_need_to_replace_readonly);
                input_need_to_replace.attr(\'readonly\',this_readonly);
                i++;
            });
        }
                }
                }

        }', CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteOrderProduct", "function autoCompleteOrderProduct(field_id,frm)
    {
        var customer_id =$('#Order_customer_id').val();
        var sales_group =$('#Order_sales_group').val();
        if(customer_id==''){
            t8.error('Please select a customer'); 
            return false;
        }
        else{ 
            var allow_change =$('#allow_change').val();
            var arr_fields= field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field  = arr_fields[1];
            var all_str  = $('#'+field_id).val();

            if(all_str == 'memo'){
                $('#OrderItem_'+row_field+'_quantity').attr( 'readonly', true );
                $('#OrderItem_'+row_field+'_rate').attr( 'readonly', true );
                $('#OrderItem_'+row_field+'_unit').attr( 'readonly', true );
                $('#OrderItem_'+row_field+'_addition_percentage').attr( 'readonly', true );
                $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', true );
                $('#OrderItem_'+row_field+'_description').attr( 'readonly', false );
                $('#OrderItem_'+row_field+'_description').val('');
                $('#OrderItem_'+row_field+'_quantity').val('');
                $('#OrderItem_'+row_field+'_unit').val('');
                $('#OrderItem_'+row_field+'_addition_percentage').val('');
                $('#OrderItem_'+row_field+'_deduction_percentage').val('');
                $('#OrderItem_'+row_field+'_addition_amount').val('');
                $('#OrderItem_'+row_field+'_deduction_amount').val('');
                $('#OrderItem_'+row_field+'_product_id').val('');

            }else{

                $('#OrderItem_'+row_field+'_quantity').attr( 'readonly', false );
                if($('#hid_edit_selling_price').val()==1){
                    $('#OrderItem_'+row_field+'_rate').attr( 'readonly', false );
                }
                else{
                    $('#OrderItem_'+row_field+'_rate').attr( 'readonly', true );
                }
                $('#OrderItem_'+row_field+'_unit').attr( 'readonly', false );
                $('#OrderItem_'+row_field+'_addition_percentage').attr( 'readonly', false );
                $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', false );
                $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', false );
            }
            var url = '" . Yii::app()->createUrl('quotation/GetProducts') . "'+'&customer_id='+customer_id+'&frm='+frm;
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response,url) },
                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
                select          : function( event, ui ) {
                    event.preventDefault();
                    trigger_target_id  	=   $(event.target).attr('id');
                    var product_id=ui.item.value; 	
                    var desc=ui.item.description; 
                    var unit_id=ui.item.unit_id;  
                    var unit_name=ui.item.unit_name;                    
                    var tot_quantity=ui.item.total_qty;
                    var default_hour=ui.item.default_hour;
                      var item_type = ui.item.other;  
                      var salesgp_type=ui.item.serialno;
                      $('#salesgp_type').val(salesgp_type);
                    var tax_percentage = 0;
                    if(ui.item.tax_code!=null)
                     tax_percentage = ui.item.tax_code;
                       // tax_percentage = ui.item.tax_code.percentage;
                    $('#OrderItem_'+row_field+'_description').val(desc);
                    $('#OrderItem_'+row_field+'_unit').val(unit_name); 
                    $('#OrderItem_'+row_field+'_product_name').val(ui.item.part_number); 
                    $('#OrderItem_'+row_field+'_unit_id').val(unit_id);  
                    $('#OrderItem_'+row_field+'_product_id').val(product_id);
                    $('#OrderItem_'+row_field+'_quantity').val(1);
                     $('#OrderItem_'+row_field+'_rate').val(ui.item.selling_price);
                    $('#OrderItem_'+row_field+'_actual_cost_rate').val(ui.item.selling_price);
                    $('#OrderItem_'+row_field+'_actual_rate').val(ui.item.selling_price);
                    //$('#OrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                    //alert(item_type);
                    if(item_type==4){//dummy item
                        $('#OrderItem_'+row_field+'_description').attr('readonly',false);
                    }
                    else{
                        if($('#is_sales_man').val()=='Y'){
                            $('#OrderItem_'+row_field+'_description').attr('readonly',true);
                        }
                        else{
                            $('#OrderItem_'+row_field+'_description').attr('readonly',false);
                        }
                    }
                    
                    
                    // $('#OrderItem_'+row_field+'_quantity').focus();
                    
                    addTableRow($('#order_item_table'));
                    var item_type = ui.item.other;
                    $('#OrderItem_'+row_field+'_inventory_type').val(item_type); 
                    if(product_id > 0){
                    
                    var actual_selling_price = $('#OrderItem_'+row_field+'_actual_cost_rate').val();
                    
                        jQuery.ajax({
                           'type': 'post',
                           'dataType': 'json',
                           'url': '" . Yii::app()->createUrl('order/getunitdrop') . "',
                           'data': {'row_field' : row_field, 'product_id' : product_id,'selling_price':actual_selling_price},
                           'cache': false,
                           'success': function(data) {
                               $('#unit_'+row_field).html(data.drop);
                              
                                //$('#OrderItem_'+row_field+'_rate').val((ui.item.selling_price) * data.factor);
                                 $('#OrderItem_'+row_field+'_rate').val(data.selling_price);
                                 checkUnit('#OrderItem_'+row_field+'_unit_id');
                               return false;
                           }
                        });
                        var exchange_rate = $('#Order_exchange_rate').val();
                        calculateorderValue($('#order_item_table'));
                        /*jQuery.ajax({
                           'type': 'post',
                           'dataType': 'json',
                           'url': '" . Yii::app()->createUrl('quotation/getalldetailsforproduct') . "',
                           'data': {'product_id' : product_id,'customer_id':customer_id},
                           'cache': false,
                           'success': function(data) {
                           //alert(data.price);
                           //alert(row_field);
                                var item_price=data.price;
                                if(exchange_rate > 0){
                                item_price = (item_price / exchange_rate).toFixed(3);
                               }
                               // $('#OrderItem_'+row_field+'_rate').val(item_price);
                                if(item_price>0){
                                     $('#OrderItem_'+row_field+'_rate').attr( 'readonly', true );  
                                }
                               calculateorderValue($('#order_item_table'));
                               return false;
                            }
                        });*/
                    }                     
                    var Order_invoice_type_id  = $('#Order_invoice_type').val(); 
                    if(ui.item.label == 'memo'){                                    
                        $('#OrderItem_'+row_field+'_quantity').attr( 'readonly', true );
                        $('#OrderItem_'+row_field+'_rate').attr( 'readonly', true );
                        $('#OrderItem_'+row_field+'_unit').attr( 'readonly', true );
                        $('#OrderItem_'+row_field+'_addition_percentage').attr( 'readonly', true );
                        $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', true );
                        $('#OrderItem_'+row_field+'_description').attr( 'readonly', false );
                        $('#OrderItem_'+row_field+'_description').val('');
                        $('#OrderItem_'+row_field+'_quantity').val('');
                        $('#OrderItem_'+row_field+'_amount').val('');                                    
                        $('#OrderItem_'+row_field+'_unit').val('');
                        $('#OrderItem_'+row_field+'_addition_percentage').val('');
                        $('#OrderItem_'+row_field+'_deduction_percentage').val('');
                        $('#OrderItem_'+row_field+'_addition_amount').val('');
                        $('#OrderItem_'+row_field+'_deduction_amount').val('');
                        $('#OrderItem_'+row_field+'_product_id').val('');
                    }
                    if(Order_invoice_type_id>0){

                        jQuery.ajax({
                            'dataType' : 'json',
                            'type'  : 'post',
                            'data'  : 'id='+Order_invoice_type_id,
                            'url'  : $('#liveSite').val()+'index.php?r=masinvoicetype/getInvoiceTypeTax',
                            'cache': false,
                            'success':function(data){

                                if(data.status=='success'){ 
                                    if(item_type == '2'){  // itemtype = 2 means service items
                                        $('#OrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                $('#check_tax_vat_percentage_'+row_field).val(tax_percentage);
                                        calculateorderValue($('#order_item_table'));
                                    }
                                    else{
                                        if(data.tax == 'Y'){
                                                $('#OrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                $('#check_tax_vat_percentage_'+row_field).val(tax_percentage); 
                                            }
                                        else{
                                            $('#OrderItem_'+row_field+'_tax_vat_percentage').val(0);
                                                $('#check_tax_vat_percentage_'+row_field).val(tax_percentage); 
                                        }
                                        calculateorderValue($('#order_item_table'));
                                    }
                                }
                            }
                        });
                    }
                }
            })
        }
    }", CClientScript::POS_HEAD);
$cs->registerScript("checkorderitem", " function checkorderitem(field_id) {
        $('.checkBoxClass').prop('checked',false);
        $('#'+field_id).prop('checked',true);
            calculateorderValue($('#order_item_table'),field_id);        
    }", CClientScript::POS_HEAD);



$cs->registerScript("calculateorderValue", " function calculateorderValue(jQtable,frm) {
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var count,qty,rate,amount,net_amount,discount,costrate,deduction_percentage,deduction_percentage_amount,tot_after_discount;
    var total   =   0;
    var grand_total =   0;
    var vat_total = 0;
    jQtable.find('tr:gt(0)').each(function() {
        net_amount = 0;  discount = 0;tot_after_discount=0;
        costrate = $(this).find('[id $=_costrate]').val();
        rate = $(this).find('[id $=_rate]').val();
        //net_per_item = rate*105/100;

        qty =   $(this).find('[id $=_quantity]').val();
        var tax =  $(this).find('[id $=_tax_vat_percentage]').val();
        var tax_amount  = 0;
        discount                =   $(this).find('[id $=_deduction_amount]').val();
      
        deduction_percentage    =   $(this).find('[id $=_deduction_percentage]').val();
        if(deduction_percentage!=undefined){
            deduction_percentage   =   deduction_percentage.replace(/%/,'');
            var deduction_percentage_amount = Number(deduction_percentage/100)*rate*qty;
        }
        tot_after_discount=((Number(rate)*Number(qty)) - Number(discount) -Number(deduction_percentage_amount));
        if(Number(qty)> 0)
        net_amount              =tot_after_discount*(100/(100+Number(tax)))/Number(qty);
        else
        net_amount              = 0;
        net_per_item            = net_amount;
        net_amount              =   (Number(net_amount)*Number(qty)).toFixed(2);
        /*if(discount!=undefined){
            count = discount.match(/%/g);
            discount   =   discount.replace(/%/,'');
            var value = Number(discount)/100;
        }
        if(isNumber(discount))
            discount  =  (count!==null && count.length>0) ? (Number(net_amount)*value) : discount;*/

        //net_amount -= discount;
        total   =   Number(total)+Number(net_amount);
        $(this).find('[id $=_amount]').val(net_amount);
        $(this).find('[id $=_deduction_amount]').val(discount);
       
        //if(frm!='rev'){
            $(this).find('[id $=_netrate]').val(Number(net_per_item).toFixed(2));
        //}
        if(net_amount > 0){
            if(tax > 0){
                 tax_amount = Number(tot_after_discount)*(Number(tax)/(100+Number(tax)));
            }else{
                 tax_amount = 0;
            }
            $(this).find('[id $=_tax_vat_amount]').val(Number(tax_amount).toFixed(2));
            grand_total += tax_amount;
            vat_total +=tax_amount;
            //alert(tax_amount);
        } 
    });
    other_additions    = 0;
    other_deductions =0;
    grand_total +=   (Number(total)   +   Number(other_additions));
    grand_total -=  Number(other_deductions);
    $('.total').html(Number(total).toFixed(2));
    $('.grandtotal').html(Number(grand_total).toFixed(2));
    $('.vat').html(Number(vat_total).toFixed(2));
}", CClientScript::POS_HEAD);



$cs->registerScript("calculateorderValue1", " function calculateorderValue1(jQtable,frm) {
        formIdStarter =   jQtable.attr('id').split(/_(.+)?/)[0];
        var count,qty,rate,amount,add_ded,discount,net,count_hash,discountamt;

        var other_additions = 0;
        var other_deductions = 0;
        var total = 0;
        var grand_total =   0;
        var total_vat_amount	= 0;     var vat_total = 0;

        var vat_percentage  = $('#Order_vat_percentage').val();
        var cnt=0;
        jQtable.find('tr:gt(0)').each(function() {
            var row_id=$(this).find('[id $=_rate]').attr('id').split('_')[1];
            net = 0;
            qty =   $(this).find('[id $=_quantity]').val();
            if(qty==undefined)
            qty=0;
            rate =   $(this).find('[id $=_rate]').val();
            if(rate==undefined)
            rate=0;
            
            add_ded  =   $(this).find('[id $=_addition_percentage]').val();
            discountamt  =   $(this).find('[id $=_deduction_amount]').val();
            
            if(isNaN(Number(discountamt)))
            discountamt=0;
        var tax =  $(this).find('[id $=_tax_vat_percentage]').val();

                    discount                =   $(this).find('[id $=_deduction_amount]').val();
        deduction_percentage    =   $(this).find('[id $=_deduction_percentage]').val();
            if(deduction_percentage!=undefined){
                        deduction_percentage   =   deduction_percentage.replace(/%/,'');
                        var deduction_percentage_amount = Number(deduction_percentage/100)*rate*qty;
            }
            
            //amount  =   (Number(qty)*Number(rate)).toFixed(2);
            
            tot_after_discount=((Number(rate)*Number(qty)) - Number(discount) -Number(deduction_percentage_amount));

              if(Number(qty)> 0){
                   net_amount              =tot_after_discount*(100/(100+Number(tax)))/Number(qty);
              }else{
                    net_amount              = 0;
              }
          

        net_amount              =tot_after_discount*(100/(100+Number(tax)))/Number(qty);

        net_per_item            = net_amount;

        net_amount              =   (Number(net_amount)*Number(qty)).toFixed(2);

            net_rate = Number(rate) - Number(discountamt);
            
            
            if(add_ded === '-' || add_ded === '*'){
                add_ded = '';
            }
            if(add_ded!=undefined)
            {
                count = add_ded.match(/%/g);
                count_hash=add_ded.match(/#/g);
                add_ded   =   add_ded.replace(/#/,'');
                add_ded   =   add_ded.replace(/%/,'');              
                var value = Number(add_ded)/100;
            }else{
                add_ded=0;
            }                   
            if(isNumber(add_ded)){
                add_ded  =   (count!==null && count.length>0) ? (amount*value) : add_ded;
                add_ded  =   (count_hash!==null && count_hash.length>0) ? (Number(add_ded)*qty) : add_ded;
            }else{
                add_ded=0;
            }
   

            //net =   (Number(net)+Number(amount)).toFixed(2);
            
            net =   (Number(net_rate) * Number(qty)).toFixed(2);
            
            //alert(net);

            // if(net != 0){

            //     total   =   Number(total)+Number(net);

            // }

            // else{

            //     total   =   Number(total);

            // }

                    total   =   Number(total)+Number(net_amount);



            $('#OrderItem_'+row_id+'_amount').val(Number(net).toFixed(2));

                    if($(this).find('[id $=_tax_vat_percentage]').length > 0)
                    {
                     tax_percentage = $(this).find('[id $=_tax_vat_percentage]').val();
                         var  tax_amount = (net * tax_percentage) / 100;
                                     $(this).find('[id $=_tax_vat_amount]').val(Number(tax_amount).toFixed(2));

                         total_vat_amount+=tax_amount;
                    }

            $(this).find('[id $=_addition_amount]').val(Number(add_ded).toFixed(2));
            
            //$(this).find('[id $=_deduction_amount]').val(Number(discountamt).toFixed(2));
            
            $(this).find('[id $=_net_amount]').val(Number(net_amount).toFixed(2));
            
            

            
           // $(this).find('[id $=_netrate]').val(Number(net_rate).toFixed(2));
                        $(this).find('[id $=_netrate]').val(Number(net_per_item).toFixed(2));

            //}
            

            vat_total +=tax_amount;
        
        
        
        
             cnt++;
        });
        other_additions    = 0.00;
        other_deductions   = 0.00;


            grand_total =   Number(total)   +   Number(other_additions);

            grand_total -=  Number(other_deductions);



                    if($('.'+formIdStarter+'_grand_total .vat_total_val').length > 0){
                    $('.'+formIdStarter+'_grand_total .vat_total_val').text(Number(total_vat_amount).toFixed(2));
                    grand_total = parseFloat(grand_total) + parseFloat(total_vat_amount);
            }



            /* if(other_deductions > total && frm!=''){
                $('#'+frm).val('');
                calculateorderValue(jQtable,frm);
            }else{*/
                $('.'+formIdStarter+'_total .total').html(Number(total).toFixed(2));
                $('.'+formIdStarter+'_grand_total .grandtotal').text(Number(grand_total).toFixed(2));
                     $('.vat_total_val').html(Number(vat_total).toFixed(2));

                $('#grnd_total_id').val(Number(grand_total).toFixed(2));
            //}
            return false;
    }", CClientScript::POS_HEAD);
$cs->registerScript("removeTableitem", " function removeTableitem(jQtable,evt) {

        formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];

        var num_rows    =   jQtable.find('tr:gt(0)').length;

        if(num_rows>1){

            var tr  =   $(evt).parent().parent();

            if(isRowEmpty(tr)) {

                amount = $(evt).parents('tr').find('[id$=\"_amount\"]').val();

                total =   $('.'+formIdStarter+'_total .total').text();

                total =   (Number(total)-Number(amount)).toFixed(2);

                $('.'+formIdStarter+'_total .total').text(total);

                gd_total =   $('.'+formIdStarter+'_grand_total .grandtotal').text();

                gd_total =   (Number(gd_total)-Number(amount)).toFixed(2);

                $('.'+formIdStarter+'_grand_total .grandtotal').text(gd_total);

                $(evt).parents('tr').remove();

                var i=0;

                jQtable.find('tr:gt(0)').each(function() { 
                    $(this).find('input,select,textarea,.errorMessage').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        new_id   =   old_id.replace(/\d+/,i);
                        $(this).attr('id',new_id);
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        } 
                    });
                    $(this).find('td:first label').html(++i); 
                });
            }
            calculateorderValue($('#order_item_table'));
        } else alert('Atleast one item needed here'); 
    }", CClientScript::POS_HEAD);

$cs->registerScript("showstockdetails", "function showstockdetails(evt,field_id) {
        var arr_fields= field_id.split('_');
        var row_field=arr_fields[1];
        var id=$('#OrderItem_'+row_field+'_product_id').val(); 
        jQuery.ajax({
            'type': 'post',
//            'dataType': 'json',
            'url': '" . Yii::app()->createUrl('inventory/GetAvaibaleQty') . "',
            'data': {'id':id}  ,
            'cache': false,
            'success': function(data) {             
                $('#stockhelper').show();
                $('#stockhelper').html(data);                
            }
        });
                    
              
    };", CClientScript::POS_HEAD);
$cs->registerScript("loadTable", "function loadTable(field_id){
                var arr_field_id = field_id.split('_');
                var row_id   =  arr_field_id[1];
                var product_id = $('#OrderItem_'+row_id+'_product_id').val();
                var customer_id = $('#Order_customer_id').val();
                var order_id = $('#Order_id').val();
                $('.temp_div').empty();
                if(customer_id > 0 && product_id > 0){
                         jQuery.ajax({
                            'data' :{'customer_id':customer_id,'product_id':product_id,'order_id' : order_id},
                            'dataType' : 'json',
                            'type':'post',
                            'url': '" . Yii::app()->createUrl('order/GetItemHistory') . "',
                            'success': function(data) {
                                      $('#data_of_'+row_id).html(data.table);
                                       $('#OrderItem_'+row_id+'_mini_table').show();
                            }
                        });
                }else{
                        if(customer_id == ''){
                            t8.error('Choose a Customer!');
                        }
                        if(product_id == ''){
                             t8.error('Choose an Item!');
                        }
                         $('#OrderItem_'+row_id+'_mini_table').hide();
                         $('.temp_div').empty();
                }
      };", CClientScript::POS_HEAD);
$cs->registerScript("checkSaleRate", " function checkSaleRate(id) {
    var rate,costrate,formIdStarter;
    row_id   =   id.split('_')[1];
    selling_price = $('#OrderItem_'+row_id+'_rate').val();
    actual_selling_price = $('#OrderItem_'+row_id+'_actual_cost_rate').val();
      if($('#hid_edit_selling_price').val()==0 && Number(selling_price)<Number(actual_selling_price)){
        t8.error('Please enter Unit Price greater than or equal to '+actual_selling_price);
        $('#OrderItem_'+row_id+'_rate').val(actual_selling_price);
    }
    //calculateDirectInvoiceValue($('#direct_invoice_item_table'));
 }", CClientScript::POS_HEAD);
$cs->registerScript("checkUnit", "function checkUnit(field_id){
     var arr_fields= field_id.split('_');
        var row_field=arr_fields[1];
        var product_id=$('#OrderItem_'+row_field+'_product_id').val(); 
          var unit = $('#OrderItem_'+row_field+'_unit_id').val();
    var actual_selling_price = $('#OrderItem_'+row_field+'_actual_cost_rate').val();
    var customer_id=$('#Order_customer_id').val();
  
    jQuery.ajax({
        'type': 'post',
        'dataType': 'json',
       'url': '" . Yii::app()->createUrl('order/GetunitRate') . "',
        'data': {'product_id' : product_id,'unit' : unit,'selling_price' : actual_selling_price,'customer_id':customer_id},
        'cache': false,
        'success': function(data) {
       
        //$('#OrderItem_'+row_field+'_rate').val((actual_selling_price) * data.factor);
        $('#OrderItem_'+row_field+'_rate').val(data.selling_price);
     calculateorderValue($('#order_item_table'),field_id);        
    return false;
      
        }
      
   });
    
 }", CClientScript::POS_HEAD);
?>



<!--<script>
    $(function () {

        var exp_date = $("#Order_delivery_date").val().split("/");
        var current_2 = new Date(exp_date[2], exp_date[1] - 1, exp_date[0]);
        $('#OrderItem_0_expected_delivery_date').datetimepicker({
            minDate: current_2,
            format: 'DD/MM/YYYY'
        });
        $("#Order_delivery_date").on("dp.change", function (e) {

            var d = new Date(e.date);
            var duedate = new Date(d);
            duedate.setDate(d.getDate() + 0);
            var month = String(duedate.getMonth() + 1);
            var day = String(duedate.getDate());
            const year = String(duedate.getFullYear());
            if (month.length < 2)
                month = '0' + month;
            if (day.length < 2)
                day = '0' + day;

            var final = `${day} / ${month} / ${year}`;
            //$('#Contract_contract_date_to').val(final);
            var i = 0;
            for (i = 0; i < 50; i++) {
                try {
                    $('#OrderItem_' + i + '_expected_delivery_date').val(final);
                } catch (e) {
                }
            }

        });

    });

</script>-->


<style type="text/css">
    body table .desc,
    body table .desc.go {
        min-width: 170px;
    }
</style>

<script>
    $(document).bind("keydown", function(event) {

        var allclass = $(event.target).attr("class");
        var substring = 'en-text-area';
        var id = $(event.target).attr("id");

        if (allclass.indexOf(substring) !== -1) {

            try {
                if (event.which == 13) {
                    document.getElementById(id).value = document.getElementById(id).value;
                }
            } catch (e) {}
        } else if (event.keyCode == 13) {
            return false;
        }
    });
    //code added by mereena 14/02/2020 for product location tooltip
    $(document).ready(function() {

        $('.stockhover').popover({
            title: '<b>Available Qty</b>',
            html: true,
            placement: 'right',
            trigger: 'hover',
            content: popoverContent
        });


    });

    function popoverContent() {
        var content = '';
        var element = $(this);
        var id = element.attr("id");
        content = "";
        var arr_fields = id.split('_');
        var row_field = arr_fields[1];
        var id = $('#OrderItem_' + row_field + '_product_id').val();
        jQuery.ajax({
            'type': 'post',
            'url': "<?php echo Yii::app()->createUrl('inventory/GetAvaibaleQty') ?>",
            'data': {
                'id': id
            },
            'cache': false,
            'async': false,
            'success': function(retdata) {
                content = retdata;
            }
        });

        return content;
    }
    //end
</script>