<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$total_qty = 0;

?>
<?php
$months = array(
    '1' => 'January',
    '2' => 'Februvary',
    '3' => 'March',
    '4' => 'April',
    '5' => 'May',
    '6' => 'June',
    '7' => 'July',
    '8' => 'August',
    '9' => 'September',
    '10' => 'October',
    '11' => 'November',
    '12' => 'December'
);
?>

<div id="div_contract_item_details">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="contract_item_table">
            <tr class="header-row">
                <th>#</th>
                <th>Contract Month</th> <!-- NEW COLUMN -->
                <th>Product Name</th>
                <th>Description</th>
                <th>Quantity</th>
                <th>Unit</th>

                <th class="text-center">
                    <a class="btn btn-xs btn-theme" href="javascript:void(0);"
                        onclick="addContractItemRow($('#contract_item_table'));"><i class="fa fa-plus"></i></a>
                </th>

            </tr>
            <?php foreach ($modelOrderContractItem as $i => $item): ?>
                <tr id="row_<?php echo $i; ?>">
                    <td><?php echo ($i + 1); ?></td>
                    <td>
                        <?php
                        echo CHtml::dropDownList(
                            "OrderContractItem[$i][contract_month]",
                            $item->contract_month ?? '',
                            $months,
                            ['class' => 'form-control input-sm', 'prompt' => 'Select Month', 'style' => 'width:100%;']
                        );
                        ?>
                    </td>
                    <td>
                        <?php echo CHtml::textField("OrderContractItem[$i][part_number]", $item->part_number ?? '', [
                            'class' => 'form-control input-sm',
                            'placeholder' => 'Type product name',
                            'onkeyup' => 'autoCompleteProductContactOrder(this.id)',
                            'id' => "OrderContractItem_{$i}_part_number",
                        ]); ?>
                        <?php echo CHtml::hiddenField("OrderContractItem[$i][product_id]", $item->product_id ?? '', ['id' => "OrderContractItem_{$i}_product_id"]); ?>
                    </td>

                    <td>
                        <?php echo CHtml::textArea("OrderContractItem[$i][description]", $item->description ?? '', [
                            'class' => 'form-control input-sm',
                            'placeholder' => 'Item Description',
                            'rows' => 1,
                        ]); ?>
                    </td>

                    <td>
                        <?php echo CHtml::textField("OrderContractItem[$i][quantity]", number_format($item->quantity ?? 0, 2, '.', ''), [
                            'class' => 'form-control input-sm text-right qty',
                            'onkeyup' => 'recalculateTotalQty();',
                            'onkeypress' => 'return isPositiveNumber(event)',
                            'style' => 'width: 100%;'
                        ]); ?>
                    </td>
                    <td>
                        <?php echo CHtml::dropDownList(
                            "OrderContractItem[$i][unit_id]",
                            $item->unit_id ?? '',
                            CHtml::listData(Unit::model()->findAll(), 'id', 'unit_name'),
                            ['class' => 'form-control input-sm']
                        ); ?>
                    </td>

                    <td class="text-center nw">
                        <a class="btn btn-xs btn-danger" href="javascript:void(0);" onclick="removeContractItemRow(this)">
                            <i class="fa fa-times"></i>
                        </a>
                    </td>
                </tr>
                <?php
                $total_qty += $item->quantity;
            endforeach; ?>
        </table>

        <!-- Total Quantity -->
        <table class="table table-hover table-bordered table-nexted orders_total">
            <tr class="bg-total">
                <td colspan="4" class="text-right table_total_title">
                    <h2>Total Quantity</h2>
                </td>
                <td width="40%" class="text-right table_total">
                    <h2 id="total_qty"><?php echo number_format($total_qty, 2); ?></h2>
                </td>
                <td></td>
            </tr>
        </table>
    </div>
</div>

<script>
    function recalculateTotalQty() {
        let total = 0;
        $('#contract_item_table tr').each(function () {
            let qty = parseFloat($(this).find('.qty').val()) || 0;
            total += qty;
        });
        $('#total_qty').text(total.toFixed(2));
    }

    function removeContractItemRow(row) {
        $(row).closest('tr').remove();
        recalculateTotalQty();
    }

    function addContractItemRow(table) {
        let rowCount = table.find('tr').length - 1;
        let newRow = table.find('tr:eq(1)').clone();

        newRow.find('input, select, textarea').each(function () {
            let name = $(this).attr('name');
            if (name) {
                let newName = name.replace(/\[\d+\]/, '[' + rowCount + ']');
                $(this)
                    .attr('name', newName)
                    .attr('id', newName
                        .replace(/\[|\]/g, '_')   // replace brackets with underscores
                        .replace(/_+/g, '_')      // remove double underscores
                        .replace(/_$/, '')        // remove trailing underscore
                    );

                if ($(this).is('input, textarea')) $(this).val('');
                if ($(this).is('select')) $(this).prop('selectedIndex', 0);
            }
        });

        table.append(newRow);
    }


</script>
<script>
    function autoCompleteProductContactOrder(field_id, frm) {
        var customer_id = $('#orders_customer_id').val();
        var hid_frm = $('#hid_frm').val();

        if (customer_id == '') {
            t8.error('Please select a customer');
            return false;
        }

        var arr_fields = field_id.split('_');
        var model_name = arr_fields[0];
        var row_field = arr_fields[1];
        console.log('row_field : ' + row_field);

        var all_str = $('#' + field_id).val();

        if (all_str.toLowerCase() == 'memo') {
            // Reset and readonly all fields
            $('#OrderContractItem_' + row_field + '_part_number').val('');
            $('#OrderContractItem_' + row_field + '_description').val('');
            $('#OrderContractItem_' + row_field + '_unit_id').val('');
            $('#OrderContractItem_' + row_field + '_unit').val('');
            $('#OrderContractItem_' + row_field + '_quantity').val('');
            $('#OrderContractItem_' + row_field + '_product_id').val('');
        } else {
            // Make fields editable
            $('#OrderContractItem_' + row_field + '_quantity').attr('readonly', false);
            $('#OrderContractItem_' + row_field + '_unit').attr('readonly', false);

            var url = '<?php echo Yii::app()->createUrl("quotation/GetProductsDetails"); ?>'
                + '&customer_id=' + customer_id
                + '&hid_frm=' + hid_frm;

            // Initialize autocomplete only once
            var $field = $('#' + field_id);
            if (!$field.data('ui-autocomplete')) {
                $field.autocomplete({
                    minLength: 1,
                    source: function (request, response) {
                        $.ajax({
                            url: url,
                            dataType: 'json',
                            data: { term: request.term },
                            success: function (data) {
                                response(data);
                            }
                        });
                    },
                    focus: function (event, ui) {
                        event.preventDefault();
                    },
                    select: function (event, ui) {
                        event.preventDefault();

                        var product_id = ui.item.value;
                        var part_number = ui.item.part_number;
                        var description = ui.item.description;
                        var unit_id = ui.item.unit_id;
                        var unit_name = ui.item.unit_name;
                        var total_qty = ui.item.total_qty || 1;

                        // Fill the fields
                        $('#OrderContractItem_' + row_field + '_part_number').val(part_number);
                        $('#OrderContractItem_' + row_field + '_description').val(description);
                        $('#OrderContractItem_' + row_field + '_unit_id').val(unit_id);
                        $('#OrderContractItem_' + row_field + '_unit').val(unit_name);
                        $('#OrderContractItem_' + row_field + '_quantity').val(total_qty);
                        $('#OrderContractItem_' + row_field + '_product_id').val(product_id);

                        // Focus quantity for quick editing
                        $('#OrderContractItem_' + row_field + '_quantity').focus();

                        // Optional: additional AJAX to get more details per product
                        $.ajax({
                            type: 'post',
                            dataType: 'json',
                            url: '<?php echo Yii::app()->createUrl("quotation/getunitdrop"); ?>',
                            data: { 'row_field': row_field, 'product_id': product_id, 'unit_id': unit_id },
                            success: function (data) {
                                $('#unit_' + row_field).html(data.drop);
                                $('#OrderContractItem_' + row_field + '_quantity').val(data.default_qty || 1);
                            }
                        });
                    }
                });
            }
        }
    }


</script>