<?php
/**
 * Last Modified by Jobin
 */
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<input type="hidden" id="hid_edit_selling_price" name="hid_edit_selling_price" value="<?php echo $selling_price_flag; ?>" />
<div id="div_service_item_details">

    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="order_components_table">
            <tr>
                <th width="4%">No</th>
                <th width="15%">Product</th>
                <th width="32%">Description</th>
                <th width="8%">Qty</th>
                <th width="12%">Unit</th>                
                <th class="text-center">
                    <a class="btn btn-xs btn-theme" href="javascript:void(0);" onclick="addTableRow($('#order_components_table'));"><i class="fa fa-plus"></i></a>
                </th>
            </tr>
            <?php
            $m = 1;
            foreach ($modelOrderComponents as $i => $eachOrderComponent) {


                $product_inventory_type = "";
                if ($eachOrderComponent->product_id == 999999) {
                    $product_name = 'memo';
                    $disabled = true;
                    $eachOrderComponent->unit_id = '';
                    
                } else {
                    $product_name = $eachOrderComponent->product->part_number;
                    $disabled = false;
                    $product_inventory_type = $eachOrderComponent->product->inventory_item_type;
                }
                if ($product_inventory_type != 4) {
                    ?>
                    <tr>
                        <td><label><?php echo ($i + 1); ?></label></td>

                        <td>
                            <div class="info-block" id="quotes-helper-new-<?php echo $i; ?>">
                                <?php
                                echo $form->textField($eachOrderComponent, "[" . $i . "]product_name", array(
                                    'class' => 'form-control go', 'placeholder' => 'Type & Select',
                                    'onKeyup' => 'js:autoCompleteOrderComponentProduct(this.id,"order");', 'value' => $product_name, 'title' => 'Select product'
                                ));
                                ?>
                                <?php echo $form->hiddenField($eachOrderComponent, "[" . $i . "]id"); ?>
                                <?php echo $form->hiddenField($eachOrderComponent, "[" . $i . "]product_id"); ?>
                                <?php echo $form->hiddenField($eachOrderComponent, "[" . $i . "]inventory_type", array('value' => $product_inventory_type)); ?>
                                <?php //echo CHtml::hiddenField('product[' . $i . '][inventorytype]', $product_inventory_type); 
                                ?>

                        </td>
                        <td>
                            <div id="div_description">
                                <?php echo $form->textArea($eachOrderComponent, "[" . $i . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here')); ?>

                            </div>
                        </td>
                        <td><?php
                            $eachOrderComponent->quantity = number_format($eachOrderComponent->quantity);
                            echo $form->textField($eachOrderComponent, "[" . $i . "]quantity", array('class' => 'qty go text-right', 'onkeypress' => 'return isNumberKey(event,this.value)', 'readonly' => $disabled));
                            ?>
                        </td>
                        <td id="compunit_<?php echo $i; ?>">
                            <?php
                            ($eachOrderComponent->product_id > 0) ? $data = UnitOfMeasurement::getUnits($eachOrderComponent->product_id) : $data = array();
                            ?>
                            <?php echo $form->dropdownlist($eachOrderComponent, "[" . $i . "]unit_id", $data, array('class' => 'qty go', 'onchange' => 'checkUnit(this.id);')); ?>
                            <?php echo $form->hiddenField($eachOrderComponent, "[" . $i . "]actual_cost_rate"); ?>
                        </td>
                        <td class="text-center nw" width="1%">
                            <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger ', 'onclick' => 'removeTableComponents($(\'#order_components_table\'),this)', 'title' => 'Remove this item')); ?>
                        </td>
                    </tr>
                    <?php
                    $m++;
                }
            }
            ?>
        </table>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteOrderComponentProduct", "function autoCompleteOrderComponentProduct(field_id,frm)
    {
        var customer_id =$('#Order_customer_id').val();
        if(customer_id==''){
            t8.error('Please select a customer'); 
            return false;
        }
        else{ 
            var allow_change =$('#allow_change').val();
            var arr_fields= field_id.split('_');
            var model_name   = arr_fields[0];
            var row_field  = arr_fields[1];
            var all_str  = $('#'+field_id).val();

            if(all_str == 'memo'){
                $('#OrderComponents_'+row_field+'_quantity').attr( 'readonly', true );
                $('#OrderComponents_'+row_field+'_unit').attr( 'readonly', true );
                $('#OrderComponents_'+row_field+'_description').attr( 'readonly', false );
                $('#OrderComponents_'+row_field+'_description').val('');
                $('#OrderComponents_'+row_field+'_quantity').val('');
                $('#OrderComponents_'+row_field+'_unit').val('');
                $('#OrderComponents_'+row_field+'_product_id').val('');

            }else{

                $('#OrderComponents_'+row_field+'_quantity').attr( 'readonly', false );
                $('#OrderComponents_'+row_field+'_unit_id').attr( 'readonly', false );
            }
            var url = '" . Yii::app()->createUrl('quotation/GetProducts') . "'+'&customer_id='+customer_id+'&frm='+frm;
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response,url) },
                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
                select          : function( event, ui ) {
                    event.preventDefault();
                    trigger_target_id  	=   $(event.target).attr('id');
                    var product_id=ui.item.value; 	
                    var desc=ui.item.description; 
                    var unit_id=ui.item.unit_id;  
                    var unit_name=ui.item.unit_name;  
                    $('#OrderComponents_'+row_field+'_description').val(desc);
                    $('#OrderComponents_'+row_field+'_unit').val(unit_name); 
                    $('#OrderComponents_'+row_field+'_product_name').val(ui.item.part_number); 
                    $('#OrderComponents_'+row_field+'_unit_id').val(unit_id);  
                    $('#OrderComponents_'+row_field+'_product_id').val(product_id);
                    $('#OrderComponents_'+row_field+'_quantity').val(1);
                    $('#OrderComponents_'+row_field+'_actual_cost_rate').val(ui.item.selling_price);
                    addTableRow($('#order_components_table'));
                    var item_type = ui.item.other;
                    $('#OrderComponents_'+row_field+'_inventory_type').val(item_type); 
                    if(product_id > 0){                    
                        jQuery.ajax({
                           'type': 'post',
                           'dataType': 'json',
                           'url': '" . Yii::app()->createUrl('order/getcomponentunitdrop') . "',
                           'data': {'row_field' : row_field, 'product_id' : product_id},
                           'cache': false,
                           'success': function(data) {
                               $('#compunit_'+row_field).html(data.drop);
                               return false;
                            }
                        });                        
                    }                     
                    var Order_invoice_type_id  = $('#Order_invoice_type').val(); 
                    if(ui.item.label == 'memo'){                                    
                        $('#OrderComponents_'+row_field+'_quantity').attr( 'readonly', true );
                        $('#OrderComponents_'+row_field+'_unit').attr( 'readonly', true );
                        $('#OrderComponents_'+row_field+'_description').attr( 'readonly', false );
                        $('#OrderComponents_'+row_field+'_description').val('');
                        $('#OrderComponents_'+row_field+'_quantity').val('');                              
                        $('#OrderComponents_'+row_field+'_unit').val('');
                        $('#OrderComponents_'+row_field+'_product_id').val('');
                    }                    
                }
            })
        }
    }", CClientScript::POS_HEAD);

$cs->registerScript("removeTableComponents", " function removeTableComponents(jQtable,evt) {

        formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
        var num_rows    =   jQtable.find('tr:gt(0)').length;
        if(num_rows>1){
            var tr  =   $(evt).parent().parent();
            if(isRowEmpty(tr)) {
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() { 
                    $(this).find('input,select,textarea,.errorMessage').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        new_id   =   old_id.replace(/\d+/,i);
                        $(this).attr('id',new_id);
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        } 
                    });
                    $(this).find('td:first label').html(++i); 
                });
            }
        } else alert('Atleast one item needed here'); 
    }", CClientScript::POS_HEAD);

?>

<style type="text/css">
    body table .desc,
    body table .desc.go {
        min-width: 170px;
    }
</style>

