<?php

$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;
$cs = Yii::app()->getClientScript();

$cs->registerScript("deleteDocument", "function deleteDocument(id){
    var r = confirm('Are you sure to delete this Document?');
    
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id ,
              'url'  : $('#liveSite').val()+'index.php?r=order/deleteDocument',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    alert('Error while Deleting');
                }else {
                    alert('Document Deleted SuccessFully!');
                    reloadTable('#tbl_document_details');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs->registerScript("loadDocs", '
    $(document).ready(function() {

        var table_id ="#tbl_document_details";
        var file_id =$("#hid_file_id_2").val();
        var table = $(table_id).DataTable({

             scrollY         : "250px",

             paging:false,

            ajax: {
                url: "' . Yii::app()->createUrl('order/GetDocumentList') . '",
                type: "POST",
                data:{"file_id":file_id},
                cache : false,

            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );

        $(".dataTables_scrollFoot").hide();

    });', CClientScript::POS_HEAD);


?>
<?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_document_upload"])) { ?>
    <div class="row">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo CHtml::hiddenField('Document[id]', $modelDocument->id, array('class' => 'go'));
                echo CHtml::label('Document', 'Document');
                $allowedExtensions = array("png", "jpg", "jpeg", "gif", "pdf", "doc", "docx", "xls", "xlsx");
                //$allowedExtensions = array("png", "jpg", "jpeg", "gif", "pdf");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl('lead/UploadDocumentLead', array('folder' => 'uploads/documents')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => 2 * 1024 * 1024,
                        'onStart' => "js:function(){}",
                        'class' => 'pull-right ',
                        'onComplete' => "js:function(id, fileName, responseJSON){ 
                   if(responseJSON.success == true){
                        $('.qq-upload-failed-text').text('Success');
                    }
                    else{
                       $('.qq-upload-failed-text').text('Failed');
                    }
                $('.icon_images').append('<div class=\"each_image\"><input type=\"hidden\" value=\"'+responseJSON.filename+'\" name=\"Icon[file]\" /></div>');"
                            . "}",
                    )
                ));
                ?>


                <div class="icon_images">
                    <?php if ($modelDocument->document_name != '') {

                        $images = explode(',', $modelDocument->document_name);
                        ?>

                        <div class="car_image">
                            <?php
                            for ($i = 0; $i < count($images); $i++) { ?>
                                <input type="hidden" name=Icon[file]" value="<?php echo $images[$i]; ?>">
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            </li>
        </ul>
    </div>
<?php } ?>
<div class="custom-data-table">

    <table class="table table-hover table-bordered personal-task" id="tbl_document_details">
        <thead>
            <tr>
                <th>No.</th>
                <th>Document Title</th>
                <th>By</th>
                <th>Date</th>
                <th>Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>No.</th>
                <th>Document Title</th>
                <th>By</th>
                <th>Date</th>
                <th>Action</th>
            </tr>
        </tfoot>
    </table>
</div>