<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'convert-production-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false
));
?>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$model_settings = MasCompanySettings::model()->findByAttributes([
    'crm_company_id' => Yii::app()->user->master_user_company_id
]);

$allow_change = $model_settings ? $model_settings->allow_change_description : 'Y';

?>
<?php echo CHtml::hiddenField('allow_change', $allow_change, ['class' => 'global-hidden']); ?>
<?php echo CHtml::hiddenField('order_id', $order_id, ['class' => 'global-hidden']); ?>
<?php echo CHtml::hiddenField('customer_id', $customer_id, ['class' => 'global-hidden']); ?>
<div id="div_service_item_details">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="order_item_table">
            <thead>
                <tr>
                    <th class="text-center" style="width:121px;">No</th>
                    <th style="width:121px;">Product</th>
                    <th>Description</th>
                    <th class="text-right">Qty</th>
                    <th>Unit</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($modelOrderItems as $i => $item): ?>
                    <?php
                    $product_inventory_type = '';
                    $item->expected_delivery_date = $item->id > 0
                        ? date("d/m/Y", strtotime($item->expected_delivery_date))
                        : date("d/m/Y");

                    if ($item->product_id == 999999) {
                        $product_name = 'memo';
                        $disabled = true;
                        $item->unit = '';
                    } else {
                        $product_name = $item->product->part_number;
                        $disabled = false;
                        $product_inventory_type = $item->product->inventory_item_type;
                    }

                    $units = $item->product_id > 0 ? UnitOfMeasurement::getUnits($item->product_id) : array();
                    ?>
                    <tr>
                        <td class="text-center">

                            <label for="<?php echo 'checkbox_' . $i; ?>"><?php echo ($i + 1); ?></label>
                            <?php
                            // checkbox name with array syntax so you get an array in POST
                            echo CHtml::checkBox("selectedItems[]", false, [
                                'class' => 'item-checkbox',
                                'value' => $item->product_id,
                                'id' => 'checkbox_' . $i,
                                'style' => 'margin: 4px 0px 0px 8px;'
                            ]);
                            ?>
                        </td>

                        <td>
                            <?php echo $form->textField($item, "[$i]product_name", array(
                                'class' => 'form-control',
                                'placeholder' => 'Type & Select',
                                'onKeyup' => 'js:autoCompleteProduct(this.id,"order");',
                                'value' => $product_name,
                                'style' => 'width: 120px',
                                'title' => 'Select product',
                                'readonly' => 'readonly'
                            )); ?>

                            <?php echo $form->hiddenField($item, "[$i]product_id"); ?>
                            <?php echo $form->hiddenField($item, "[$i]quotes_item_id"); ?>
                            <?php echo $form->error($item, "[$i]product_id"); ?>
                            <?php echo CHtml::hiddenField("product[$i][inventorytype]", $product_inventory_type); ?>
                        </td>

                        <td>
                            <div id="div_description">
                                <?php
                                $descOptions = array(
                                    'class' => 'tooltipster desc desc2 go en-text-area',
                                    'title' => 'Add Description here',
                                    'readonly' => 'readonly'
                                );

                                if ($allow_change == "N" && $item->product_id != 999999) {
                                    $descOptions['readonly'] = true;
                                }

                                echo $form->textArea($item, "[$i]description", $descOptions);
                                echo $form->error($item, "[$i]description");
                                ?>
                            </div>
                        </td>

                        <td>
                            <?php
                            $item->quantity = number_format($item->quantity, 0, '.', '');
                            echo $form->textField($item, "[$i]quantity", array(
                                'class' => 'qty go text-right',
                                'onkeypress' => 'return isNumberKey(event)',
                                'readonly' => 'readonly'
                            )); ?>
                            <?php echo $form->error($item, "[$i]quantity"); ?>
                        </td>
                        <td>
                            <?php
                            $unitId = $item->unit_id;
                            $unitName = isset($units[$unitId]) ? $units[$unitId] : '';

                            echo $form->textField($item, "[$i]unit_name", array(
                                'class' => 'qty go',
                                'readonly' => 'readonly',
                                'value' => $unitName,
                            ));
                            ?>
                            
                            <?php echo CHtml::activeHiddenField($item, "[$i]unit_id"); ?>
                        </td>



                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="modal-footer">

    <button type="button" class="btn btn-danger" id="qtn_close" data-dismiss="modal">Close</button>
    <button type="button" id="submit-btn" class="btn btn-theme">Push to Production</button>

</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id,frm)
{
    var customer_id =$('#customer_id').val();
    if(customer_id==''){
            t8.error('Please select a customer'); 
            return false;
        }else{ 
    var arr_fields= field_id.split('_');
    var model_name   = arr_fields[0];
    var row_field  = arr_fields[1];
    var all_str  = $('#'+field_id).val();

    if(all_str == 'memo'){
        $('#OrderItem_'+row_field+'_quantity').attr( 'readonly', true );
        $('#OrderItem_'+row_field+'_rate').attr( 'readonly', true );
        $('#OrderItem_'+row_field+'_unit').attr( 'readonly', true );
        $('#OrderItem_'+row_field+'_addition_percentage').attr( 'readonly', true );
        $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', true );
        $('#OrderItem_'+row_field+'_description').attr( 'readonly', false );
        $('#OrderItem_'+row_field+'_description').val('');
        $('#OrderItem_'+row_field+'_quantity').val('');
        $('#OrderItem_'+row_field+'_unit').val('');
        $('#OrderItem_'+row_field+'_addition_percentage').val('');
        $('#OrderItem_'+row_field+'_deduction_percentage').val('');
        $('#OrderItem_'+row_field+'_addition_amount').val('');
        $('#OrderItem_'+row_field+'_deduction_amount').val('');
        $('#OrderItem_'+row_field+'_product_id').val('');

    }else{

        $('#OrderItem_'+row_field+'_quantity').attr( 'readonly', false );
        $('#OrderItem_'+row_field+'_rate').attr( 'readonly', false );
        $('#OrderItem_'+row_field+'_unit').attr( 'readonly', false );
        $('#OrderItem_'+row_field+'_addition_percentage').attr( 'readonly', false );
        $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', false );
        $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', false );
        }

        var url = '" . Yii::app()->createUrl('quotation/GetProducts') . "'+'&frm='+frm;
        $('#'+field_id).autocomplete({

            minLength   : 1,

            source      : function (request, response) { autoCompleteSource(request, response,url) },

            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

            select          : function( event, ui ) {
                event.preventDefault();
                trigger_target_id  	=   $(event.target).attr('id');
                var product_id=ui.item.value; 	
                var desc=ui.item.description; 
                var unit_id=ui.item.unit_id;  
                var unit_name=ui.item.unit_name;
                var tax_percentage = 0;
                //alert(ui.item.tax_code);
                if(ui.item.tax_code!=null)
                    tax_percentage = ui.item.tax_code;
                $('#OrderItem_'+row_field+'_description').val(desc);
                $('#OrderItem_'+row_field+'_unit').val(unit_name); 
                $('#OrderItem_'+row_field+'_product_name').val(ui.item.part_number); 
                $('#OrderItem_'+row_field+'_unit_id').val(unit_id);  
                $('#OrderItem_'+row_field+'_product_id').val(product_id); 
                                
                var item_type = ui.item.other;

                $('#product_'+row_field+'_inventorytype').val(item_type); 


                if(product_id > 0){
                    jQuery.ajax({
                       'type': 'post',
                       'dataType': 'json',
                       'url': '" . Yii::app()->createUrl('order/getunitdrop') . "',
                       'data': {'row_field' : row_field, 'product_id' : product_id},
                       'cache': false,
                       'success': function(data) {
                           $('#unit_'+row_field).html(data.drop);
                           return false;
                       }
                   });
                   var exchange_rate = $('#Order_exchange_rate').val();
                   jQuery.ajax({
                       'type': 'post',
                       'dataType': 'json',
                       'url': '" . Yii::app()->createUrl('quotation/getalldetailsforproduct') . "',
                       'data': {'product_id' : product_id,'customer_id':customer_id},
                       'cache': false,
                       'success': function(data) {
                       //alert(data.price);
                       //alert(row_field);
                            var item_price=data.price;
                            var bonus_qty=data.bonus_qty;
                            if(exchange_rate > 0){
                            item_price = (item_price / exchange_rate).toFixed(3);
                           }
                            $('#OrderItem_'+row_field+'_rate').val(item_price);
                            if(item_price>0){
                                 $('#OrderItem_'+row_field+'_rate').attr( 'readonly', true );  
                            }
                            $('#OrderItem_'+row_field+'_bonus_qty').val(bonus_qty);
                           calculateorderValue($('#order_item_table'));
                           return false;
                       }
                   });


                }
                                
                                
                var Order_invoice_type_id  = $('#Order_invoice_type_id').val(); 
                if(ui.item.label == 'memo'){                                    
                    $('#OrderItem_'+row_field+'_quantity').attr( 'readonly', true );
                    $('#OrderItem_'+row_field+'_rate').attr( 'readonly', true );
                    $('#OrderItem_'+row_field+'_unit').attr( 'readonly', true );
                    $('#OrderItem_'+row_field+'_addition_percentage').attr( 'readonly', true );
                    $('#OrderItem_'+row_field+'_deduction_percentage').attr( 'readonly', true );
                    $('#OrderItem_'+row_field+'_description').attr( 'readonly', false );
                    $('#OrderItem_'+row_field+'_description').val('');
                    $('#OrderItem_'+row_field+'_quantity').val('');
                    $('#OrderItem_'+row_field+'_amount').val('');                                    
                    $('#OrderItem_'+row_field+'_unit').val('');
                    $('#OrderItem_'+row_field+'_addition_percentage').val('');
                    $('#OrderItem_'+row_field+'_deduction_percentage').val('');
                    $('#OrderItem_'+row_field+'_addition_amount').val('');
                    $('#OrderItem_'+row_field+'_deduction_amount').val('');

                    $('#OrderItem_'+row_field+'_product_id').val('');

                }
                if(Order_invoice_type_id>0){

                        jQuery.ajax({
                                'dataType' : 'json',
                              'type'  : 'post',
                              'data'  : 'id='+Order_invoice_type_id,
                              'url'  : $('#liveSite').val()+'index.php?r=masinvoicetype/getInvoiceTypeTax',
                              'cache': false,
                              'success':function(data){

                                if(data.status=='success'){ 
                                    if(item_type == '2'){  // itemtype = 2 means service items
                                        $('#OrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                $('#check_tax_vat_percentage_'+row_field).val(tax_percentage);
                                        calculateorderValue($('#order_item_table'));
                                    }
                                    else{
                                        if(data.tax == 'Y'){
                                                $('#OrderItem_'+row_field+'_tax_vat_percentage').val(tax_percentage);
                                                $('#check_tax_vat_percentage_'+row_field).val(tax_percentage); 
                                            }
                                        else{
                                            $('#OrderItem_'+row_field+'_tax_vat_percentage').val(0);
                                                $('#check_tax_vat_percentage_'+row_field).val(tax_percentage); 
                                        }
                                        calculateorderValue($('#order_item_table'));
                                    }

                                }
                               }
                            });

                    }
		
                                
                                
                                 
                                 

                            }

			})


}
		}", CClientScript::POS_HEAD);
?>
<?php $this->endWidget(); ?>
<script>
    $(document).ready(function () {
        $('#submit-btn').on('click', function (e) {
            e.preventDefault();

            const checkedBoxes = $('.item-checkbox:checked');
            if (checkedBoxes.length === 0) {
                t8.error('Please select at least one item.');
                return;
            }

            // Serialize only hidden inputs outside rows marked with 'global-hidden'
            const globalHidden = $('#convert-production-form').find('input.global-hidden[type=hidden]').serialize();

            let dataParts = [];

            checkedBoxes.each(function () {
                const tr = $(this).closest('tr');
                // exclude checkboxes and disabled inputs and global-hidden fields
                const rowElements = tr.find('input, select, textarea').filter(function () {
                    return !this.disabled &&
                        this.type !== 'checkbox' &&
                        !$(this).hasClass('global-hidden');
                });
                const rowData = rowElements.serialize();
                if (rowData) dataParts.push(rowData);
            });

            const data = globalHidden + '&' + dataParts.join('&');

            $.ajax({
                url: '<?php echo $this->createUrl("assembly/production/orderConvertion"); ?>',
                type: 'POST',
                data: data,
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        t8.success('Selected rows pushed successfully!');
                        location.href="index.php?r=assembly/production/order_index";
                    } else {
                        t8.error('Submission failed: ' + (response.message || 'Unknown error'));
                    }
                },
                error: function () {
                    t8.error('An error occurred during submission.');
                }
            });
        });
    });



</script>