<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'order-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    )); ?>
    <div class="tab-content">
        <div class="tab-pane active" id="tab1">            
            <?php echo $form->hiddenField($model, 'id'); ?>
            <input type="hidden" name="level" id="level" value="<?php echo $level; ?>">
            <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
            <ul class="clearfix form-ul material">
                <li class="col-sm-3">
                    <?php
                    if ($model->customer_id > 0) {
                        $customer = $model->customer->customer_name;
                    } else {
                        $customer = $modelQuotes->customer->customer_name;
                    }
                    echo $form->textField($model, 'customer_name', array('class' => 'text-bold', 'data-label' => "Customer <span style='color:red'>*</span>", 'title' => 'Please select customer', 'readonly' => true, 'value' => $customer)); ?>
                    <?php echo $form->hiddenField($model, 'customer_id', array('value' => $modelQuotes->customer_id)); ?>
                </li>
                <li class="col-sm-3" id="p_div">
                    <div id="div_payment_term">
                        <?php echo $form->dropDownList($model, 'payment_terms_id', MasPaymentTerm::getPaymentTerms(), array('class' => '', 'title' => 'Select Payment Terms', 'data-label' => 'Payment Terms <span style="color:red;">*</span> ')); ?>
                    </div>
                </li>
                <li class="col-sm-3">
                    <?php
                    $date_picker_class = 'datepicker';
                    if ($model->id > 0) {
                        $model_deliverynote_exist = DeliveryNote::model()->find(array('condition' => 'order_id="' . $model->id . '"'));
                        if ($model_deliverynote_exist->id > 0) {
                            $date_picker_class = '';
                        }
                    }
                    if ($model->order_date != '') {
                        $order_date = date("d/m/Y", strtotime($model->order_date));
                    } else {
                        $order_date = date("d/m/Y");
                    }
                    ?>
                    <?php echo $form->textField($model, 'order_date', array('class' => '' . $date_picker_class . '', 'data-label' => 'Order Date', 'value' => $order_date, 'onkeypress' => 'return false;')); ?>
                    <?php echo $form->error($model, 'order_date'); ?>
                </li>
                <li class="col-sm-3">
                    <?php
                    if ($model->delivery_date != '') {
                        $delivery_date = date("d/m/Y", strtotime($model->delivery_date));
                    } else {
                        $delivery_date = date("d/m/Y", strtotime("+3 days"));
                    }
                    ?>
                    <?php echo $form->textField($model, 'delivery_date', array('class' => '' . $date_picker_class . '', 'data-label' => 'Delivery Date', 'value' => $delivery_date, 'onkeypress' => 'return false;')); ?>
                    <?php echo $form->error($model, 'delivery_date'); ?>
                </li>
                <?php if ((int) Yii::app()->user->haveLevelPermissionOn['master_level_permission_currency'] > 0 || Yii::app()->user->authorised_user == 1) { ?>
                    <?php if (isset(Yii::app()->user->havePermissionOn['currency_add']) || Yii::app()->user->authorised_user == 1) { ?>
                        <li class="col-sm-3">
                            <?php $currency = $modelQuotes->currency_id; ?>

                            <div id="order_currency_div">
                                <?php

                                if ((int) $model->currency_id <= 0) {
                                    $model->currency_id = Yii::app()->user->company_base_currency;
                                }

                                // echo $form->dropDownList($model, 'currency_id', MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'onChange' => 'getExchangeRate(this.id)', 'value' => $modelQuotes->currencyname->currency, 'prompt' => '--Select--')); 
                                echo $form->dropDownList($model, 'currency_id', MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency ', 'data-label' => 'Currency <span style="color:red">*</span>', 'onChange' => 'getExchangeRate(this.id)', 'prompt' => '--Select--')); ?>
                            </div>
                        </li>
                        <li class="col-sm-3">
                            <?php
                            if ((Yii::app()->user->company_base_currency == $model->currency_id || (int) $model->id == 0) && (float) $model->exchange_rate <= 0) {
                                $model->exchange_rate = 1;
                                echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'data-label' => 'Exchange Rate <span style="color:red">*</span>', 'readonly' => true));
                            } else {
                                echo $form->textField($model, 'exchange_rate', array('class' => 'tooltipster', 'title' => 'Exchange Rate', 'data-label' => 'Exchange Rate <span style="color:red">*</span>'));
                            }
                            ?>
                        </li>
                    <?php }
                    $model->currency_id = MasCurrency::base_currency_id();
                    echo $form->hiddenField($model, 'currency_id');
                    $model->exchange_rate = MasCurrency::base_exchange_rate();
                    echo $form->hiddenField($model, 'exchange_rate');
                    ?>
                <?php } else {
                    $model->currency_id = MasCurrency::base_currency_id();
                    echo $form->hiddenField($model, 'currency_id');
                    $model->exchange_rate = MasCurrency::base_exchange_rate();
                    echo $form->hiddenField($model, 'exchange_rate');
                }
                ?>
                <li class="col-sm-6">
                    <?php echo $form->textArea($model, 'notes', array(
                        'class' => 'tooltipster',
                        'title' => 'Notes',
                        'value' => '',
                        'data-label' => 'Notes',
                    )); ?>
                </li>
                <li class="col-sm-3">Total Amount 
                    <?php foreach($modelOrderItems as $i => $modelOrderItems):
                        $total+=$modelOrderItems->amount;
                        $total_vat += $modelOrderItems->tax_vat_amount;
                    endforeach;
                    $grand_total = $total;
                    $grand_total += $total_vat; ?>
                    <?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " "); ?>
                </li>
            </ul>
        </div>
    </div> 
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="order_close" data-dismiss="modal">Close</button>
        <?php
        $btn = 'Approve';
        $url = Yii::app()->createUrl('features/approvelevel/saveapprove');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#order-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Order Approved!","Success");
                    $("#order_close").click();
                    reloadTable("#tble_order");
                } else {
                    $("#order-form .order-save-btn").prop("disabled", false);
                    $("#order-form .order-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#order-form #"+key+"_em_").text(val).show();
                            t8.error(""+val+"");
                        });
                    }
                }',
                'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'order-save-btn btn btn-theme'));
        $btn = 'Reject';
        $url = Yii::app()->createUrl('features/approvelevel/savereject');
        echo CHtml::ajaxSubmitButton($btn, $url, array(
            'dataType' => 'json',
            'data' => 'js:$("#order-form").serialize()',
            'type' => 'post',
            'success' => 'function(data) {
                $("#loader").hide();
                if(data.status=="success"){
                    t8.success("Order Rejected!","Success");
                    $("#order_close").click();
                    reloadTable("#tble_order");
                } else {
                    $("#order-form .order-save-btn").prop("disabled", false);
                    $("#order-form .order-save-btn").addClass("btn-theme").removeClass("btn_loading");
                    $.each(data, function(key, val) {
                        $("#order-form #"+key+"_em_").text(val).show();
                        t8.error(""+val+"");
                    });
                }
            }',
            'complete' => 'function(){}'
        ), array('id' => 'save_convert' . rand(), 'class' => 'order-save-btn btn btn-theme')); ?>        
        <?php $this->endWidget(); ?>
    </div>
</div>