<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadOpeningCash", '
        $(document).ready(function() {

        var table_id ="#tbl_openingcash_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('openingcash/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
			columnDefs: [
                {
                    targets: [3],
                    className: "text-right"
                }
            ],
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },

             "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            
AddContextMenu(nRow, aData);
              
            }
        } );
        $(".dataTables_scrollFoot").hide(); 
    });', CClientScript::POS_HEAD);
?>

<script>
    function AddContextMenu(row, datas) {
         $(row).contextMenu({
              selector: 'td',
               items: {
                   "edit": {
                        name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                            loadPopupModal("openingcash/create&id=" + datas[4].id, datas[2], "lg");
                        }
                   }
               }
         });
    }
</script>    
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-sign-out"></i> Opening Cash
        <?php // if (isset(Yii::app()->user->haveHrPermissionOn['opening_cash_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('openingcash/create', 'Add Opening Cash', 'lg')"><i class="fa fa-plus"></i> ADD</button>

            </div>
        <?php // } ?>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_openingcash_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Date</th>
                        <th>Warehouse</th>
                        <th>Amount</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
