<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'openingcash-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class = "col-sm-4">
                <?php
                echo $form->dropDownList($model, 'warehouse_id', MasInventoryWarehouse::getUserWarehousees() , ['data-label' => 'Warehouse']);
                ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php 
                if(empty($model->opening_date)){
                    $model->opening_date = date('d/m/Y');
                }else{
                    $model->opening_date = date('d/m/Y', strtotime($model->opening_date));
                }
                
                echo $form->textField($model, 'opening_date', array('data-label' => 'Date', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'opening_cash', array('data-label' => 'Cash Amount')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="openingcash_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('openingcash/Save');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                        if(data.status=="success"){
                             t8.success("Details Saved Successfully!");
                             $("#openingcash_close").click();
                            reloadTable("#tbl_openingcash_details");
                        } else {
                            $.each(data, function(key, val) {
                                t8.error(""+val+"");
                            });
                        }
                }',
        'beforeSend' => 'function(){
                    $("#loader").show();
                    $(".toast8-error").hide();
                    $("#openingcash-form .openingcash-save-btn").prop("disabled", true);
                    $("#openingcash-form .openingcash-save-btn").addClass("btn_loading").removeClass("btn-theme");
                }',
        'complete' => 'function(){
                    $("#loader").hide();
                    $("#openingcash-form .openingcash-save-btn").prop("disabled", false);
                    $("#openingcash-form .openingcash-save-btn").addClass("btn-theme").removeClass("btn_loading");
                }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'openingcash-save-btn btn btn-theme'));
    ?>


</div>
<?php $this->endWidget(); ?>








