<?php $emp_details = Employee::getEmployee(); ?>
<ul class="clearfix form-ul material">
    <li class="col-sm-3">
        <?php echo $form->hiddenField($model, 'id'); ?>

        <?php echo $form->dropDownList($model, 'type_id', MeetingType::getList(), array('class' => 'tooltipster', 'data-label' => 'Meeting Type <span style="color:red;">*</span>')); ?>                    
    </li>
    <li class="col-sm-3">               
        <?php echo $form->textField($model, 'meeting_title', array('class' => 'tooltipster', 'data-label' => 'Meeting Title <span style="color:red;">*</span>')); ?>                 

    </li>
    <li class="col-sm-3">           
        <?php echo $form->textField($model, 'venue', array('class' => 'tooltipster', 'data-label' => 'Meeting Venue <span style="color:red;">*</span>')); ?>                 
    </li>
    <li class="col-sm-3">       
        <?php echo $form->dropDownList($model, 'isMeeting', ['Y' => 'Meeting', 'N' => "Action List"], array('class' => 'tooltipster', 'data-label' => 'Is Meeting<span style="color:red;">*</span>')); ?>      
    </li>
    <li class="col-sm-4">
        <?php
        $model->country_id = explode(',', $model->country_id);
        echo $form->dropDownList($model, 'country_id', MasCountry::getCountry(), array('class' => 'tooltipster', 'data-label' => 'Country <span style="color:red;">*</span>', 'onchange' => 'getMeetingsLocations(this.id);', 'multiple' => TRUE, 'data-search' => 'true'));
        ?>
    </li>

    <li  class="col-sm-4">
        <?php echo $form->textField($model, 'meeting_date', array('class' => 'datepicker tooltipster', 'data-label' => 'Meeting date')); ?>
    </li>
    <li class="col-sm-3">               
        <?php echo $form->textField($model, 'meeting_time', array('class' => 'clockpicker tooltipster', 'data-label' => 'Meeting Time <span style="color:red;">*</span>')); ?>  
    </li>

    <li class="col-sm-3"  id= "meeting_conducted_by_li">
        <?php
        $conducted_by = explode(",", $model->conducted_by);
        echo CHtml::dropDownList('conducted_by', $conducted_by, $emp_details, array("name" => "conducted_by", 'class' => 'tooltipster', 'data-label' => 'Conducted by <span style="color:red;">*</span>', 'multiple' => true, 'data-search' => true, 'onchange' => 'updateDropDown()'));
        ?> 
    </li>

    <li class="col-sm-3"  id= "meeting_attendees_li" >
        <?php
        $attendees = explode(",", $model->attendees);
        echo CHtml::dropDownList('attendees', $attendees, $emp_details, array('class' => 'tooltipster', 'data-label' => 'Attendees <span style="color:red;">*</span>', 'multiple' => true, 'data-search' => true, 'onchange' => 'updateDropDown()'));
        ?>
    </li>

    <li class="col-sm-3"  id= "meeting_notify_li" > 
        <?php
        $notify = explode(",", $model->notify);
        echo CHtml::dropDownList('notify', $notify, $emp_details, array('class' => 'tooltipster', 'data-label' => 'Notify ', 'multiple' => true, 'data-search' => true));
        ?> 
    </li>
    <li class="col-sm-4" >
        <?php echo $form->hiddenField($model, 'others'); ?>
<?php echo $form->textField($model, 'other_name', array('class' => '', 'data-label' => 'Other Attendees')); ?> 
    </li>
    <li class="col-sm-4" >
<?php echo $form->textField($model, 'other_email', array('class' => '', 'data-label' => 'Other Attendees Email')); ?> 
    </li>

    <li class="col-sm-1" >
        <a class="btn btn-primary" onclick="return AddToList()">Add </a>
        <script>
            function AddToList() {
                var email = $("#Meeting_other_email").val();
                var name = $("#Meeting_other_name").val();
                if (email.length > 3 & name.length > 3) {
                    var li = document.createElement('li');
                    li.innerHTML = name + "&lt;" + email + "&gt;" + '<button class="btn btn-xs" title="Send Mail" onclick="deleteothers(this)"><i class="fa fa-close"></i></button>';
                    $("#other_attendee_list").prepend(li);
                    $("#Meeting_other_email").val('');
                    $("#Meeting_other_name").val('');
                    $("#Meeting_other_name").focus();
                    $("#Meeting_other_name").select();
                    let op = document.createElement('option');
                    op.innerHTML = name;
                    op.value = email;
                    $('.employee_dropdown').append(op);
                    notifyOthers();
                } else {
                    t8.error('Please add Other attendees valid  Name/Email');
                }
                return false;
            }
            function deleteothers(evt) {
                var text = $(evt).parent().text();
                var text_array = text.split('<');
                var email = text_array[1].replace('>', '');
                $(".employee_dropdown option[value='" + email + "']").remove();
                $(evt).parent().remove();
                notifyOthers();
                return false;
            }

        </script>

    </li>

    <li class="col-sm-12" >
        <?php
        $other_array = json_decode($model->others);
        ?>
        <ul id="other_attendee_list" style="list-style: none;display: flex;list-style-position: inside;">
            <?php foreach ($other_array as $value) {
                ?>
                <li><?= $value->name ?>&lt;<?= $value->email ?>&gt;<button class="btn btn-xs" title="Send Mail" onclick="deleteothers(this)"><i class="fa fa-close"></i></button></li>
            <?php }
            ?>
        </ul>
        <style>
            #other_attendee_list li{
                margin: 5px;
            }
        </style>
    </li>
</ul>
<script>
    /**
     * Comment
     */
    function loadgroup() {
        var employee = $("#Meeting_emp_group").val();
        $.ajax({
            url: 'index.php?r=meeting/getemployeelist',
            data: {'id': employee},
            dataType: 'json',
            type: 'POST',
            success: function (data, textStatus, jqXHR) {
                $(data.data).each((index, emp_id) => {

                    $("#notify option[value='" + emp_id + "']").prop('selected', true);
                });
                $("#notify").multiselect('rebuild');
            },
            beforeSend: function (xhr) {

            },
            complete: function (jqXHR, textStatus) {

                // reloadTable("");
            }
        });
    }

    /**
     * Comment
     */
    function notifyOthers() {
        var json = [];
        $("#other_attendee_list li").each((index, el) => {
            var list_text = $(el).text();
            list_text = list_text.replace('>', '');
            var list_array = list_text.split('<');
            let name = list_array[0];
            var email = list_array[1];
            var person = {'name': name, email: email};
            json.push(person)
        });
        $("#Meeting_others").val(JSON.stringify(json));
    }
</script>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("getMeetingLocations", "
    function getMeetingsLocations(id){
        var value = $('#'+id).val();        
        var val = value.join(',');
        jQuery.ajax({
            'dataType': 'json',
            'data' : {'countryid':val},
            'type':'post',
            'url': '" . Yii::app()->createUrl('meeting/getAllLocations') . "',
            'cache': false,
            'success': function(data) {
                $('#meeting_location_li').html(data.location);
            }
        });
    }", CClientScript::POS_HEAD);
?>