<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadevents", '
    function filterDataTable() {
        var table_id ="#tbl_master_events";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('masternotification/GetEvents') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
	  $(document).ready(function() {  	
  	  		
      filterDataTable();
    })
	
', CClientScript::POS_HEAD);
?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-info-circle"></i> Events
            <div class="pull-right">	
                <?php if (Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('masternotification/createevents','Create','sm')"><i class="fa fa-plus"></i> ADD</button> 
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_master_events">
                    <thead>
                        <tr>
                            <th>No</th>  
                            <th class="tetx-center">Event Name</th>
                            <th>Actions</th>  
                        </tr>
                    </thead>
                    <tfoot>
                            <th>No</th>  
                            <th>Event Name</th>  
                            <th>Actions</th>  
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
